/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<math.h>
#include	"xl.h"
#include	"task.h"
#include	"lock_level.h"
#include	"win_flame.h"

#define BW_LOAD_MAX	10

extern GBVIEW_ENV env;
SEM	ls_lock;

void
init_load_structure()
{
	ls_lock = new_lock(LL_LOAD_STRUCTURE);
}

void
assert_ls(int flags)
{
	lock_task(ls_lock);
	env.ls_flags |= flags;
	wakeup_task((int)&env.ls_flags);
	unlock_task(ls_lock,"assert_ls");
}

int
check_assert(int flags)
{
int ret;
	lock_task(ls_lock);
	ret = env.ls_flags & flags;
	unlock_task(ls_lock,"check_assert");
	return ret;
}

void
load_structure_task()
{
BROWSE_WORK bw;
RESOURCE * c;
WIN_FLAME * wf;
GB_POINT pp;
REAL1 reso;
REAL1 n_reso,p_reso;
int retry;
int b_ret,bb_ret;
int ses;
XL_INTERPRETER * xli;
int no;
RESOURCE * draw;
WF_ID wfid;
extern WIN_FLAME * _get_wf_ptr();
GB_RECT win_r;

printf("load structure %i\n",get_tid());
	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	ses = open_session(SEST_OPTIMIZE);

	for ( ; ; ) {
		bb_ret = 0;

		for ( wfid = get_next_wfid(0) ; wfid ; 
				wfid = get_next_wfid(wfid)  ) {
			lock_task(env.wf_lock);
			wf = _get_wf_ptr(wfid);
			if ( wf == 0 ) {
				unlock_task(env.wf_lock,"ls");
				continue;
			}
			if ( _win_lock(wf) < 0 ) {
				unlock_task(env.wf_lock,"ls");
				continue;
			}
			unlock_task(env.wf_lock,"load_structure");
			bw.type = BWT_CHILDREN;
			bw.mh = 0;
			bw.base = wfid;
			bw.ses = ses;
			bw.load_max = BW_LOAD_MAX;

			win_r.tl.x = win_r.tl.y = 0;
			win_r.br.x = env.win_width;
			win_r.br.y = env.win_height;

			lock_task(env.wf_lock);

			set_surp(&bw.surp,&win_r,env.flame_base_resolution);
			map_from_flame(
				&env.flame_base_display_map,
				bw.surp.ptr,
				bw.surp.reso,
				SURP_NOS);
			if ( wf->mh ) {
				map_from_flame(wf->mh,bw.surp.ptr,bw.surp.reso,
						SURP_NOS);
			}
			draw = wf->draw;

			unlock_task(env.wf_lock,"load_structure_task");

			browse_resource(draw,&bw);

			wf_check_resource();

			if ( bw.load_max != BW_LOAD_MAX )
				win_flame_dirty(wfid,0,WFF_DIRTY,0);

			if ( bw.load_max == 0 )
				bb_ret = 1;

			win_unlock(wf);
		}
		wf_wakeup();
		lock_task(ls_lock);
		if ( (env.ls_flags & LSF_ASSERT) || bb_ret ) {
			env.ls_flags &= ~LSF_ASSERT;
			wakeup_task((int)&env.ls_flags);
			unlock_task(ls_lock,"ls");
		}
		else {
/*
printf("ls sleep\n");
*/
			sleep_task((int)&env.ls_flags,ls_lock);
/*
printf("ls wakeup\n");
*/

		}
	}
}
