/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	"memory_debug.h"
#include	"xlerror.h"
#include	"resource.h"
#include	"utils.h"
#include	"xl.h"
#include	"task.h"
#include	"lock_level.h"
#include	"pri_level.h"

#define HANDLING_MAX		20
#define LOAD_RES_TASKS		4

typedef struct res_que {
	struct res_que *	next;
	int			lock;
	LOAD_RESOURCE_WORK *	w;
	L_CHAR *		server;
	int			port;
} RES_QUE;

extern SEM res_lock;
void _load_resource_task();
RES_QUE * que_head;
extern GV_FUNC gv_new_table[RT_MAX];
extern XLISP_ENV * gv_resource_env[RT_MAX];

int loading_coord();
int setup_coord();

RESOURCE_TYPE_LIST res_type_list[] = {
	{"coordinate","*",0,RT_COORDINATE,loading_coord,setup_coord},
	{"map","xl",0,RT_MAP,0,0},
	{"luster","cr",RTF_TARGET,RT_LUSTER,0,0},
	{"luster","r64",RTF_TARGET,RT_LUSTER,0,0},
	{"vector","pdb",RTF_TARGET,RT_VECTOR,0,0},
	{"vector","xl",0,RT_VECTOR,0,0},
	{0,0,0,0,0,0}
};

void
init_load_resource()
{
int i;
	for ( i = 0 ; i < LOAD_RES_TASKS ; i ++ )
		create_task(_load_resource_task,0,PRI_FETCH);
}



void
__insert_res_que(LOAD_RESOURCE_WORK * w)
{
RES_QUE * r, ** rp;
LOAD_RESOURCE_WORK ** wp;

	for ( rp = &que_head ; *rp ; rp = &(*rp)->next )
		if ( l_strcmp(w->url.server,(*rp)->server) == 0 &&
				w->url.port == (*rp)->port ) {
			r = *rp;
			for ( wp = &r->w ; *wp ; wp = &(*wp)->next[QUE_NEXT] )
				if ( (*wp)->pri > w->pri )
					break;
			w->next[QUE_NEXT] = *wp;
			*wp = w;
			return;
		}
	w->next[QUE_NEXT] = 0;
	r = d_alloc(sizeof(*r),122);
	r->lock = 0;
	r->w = w;
	r->next = 0;
	r->server = ll_copy_str(w->url.server,11);
	r->port = w->url.port;
	*rp = r;
}

void
_insert_res_que(LOAD_RESOURCE_WORK * w,int pri)
{
	for ( ; w ; w = w->next[REQ_NEXT] ) {
		w->pri = pri;
		__insert_res_que(w);
	}
	wakeup_task((int)&que_head);
}

void
check_lrw(int next_type,LOAD_RESOURCE_WORK * w)
{
	printf("CHECK\n");
	for ( ; w ; w = w->next[next_type] );
	printf("CHECK END\n");
}

LOAD_RESOURCE_WORK *
delete_res_que()
{
LOAD_RESOURCE_WORK * ret, * w;
RES_QUE * r, ** rp;
int max;

retry:
	lock_task(res_lock);
retry2:
	for ( ; que_head && que_head->w == 0 ; ) {
		r = que_head;
		que_head = r->next;
		d_f_ree(r->server);
		d_f_ree(r);
	}
	for ( ; que_head == 0 ; ) {
		sleep_task((int)&que_head,res_lock);
		lock_task(res_lock);
	}
	ret = 0;
	for ( rp = &que_head ; *rp ; rp = &(*rp)->next )
		if ( (*rp)->lock == get_tid() )
			break;
	if ( *rp == 0 ) {
		for ( r = que_head ; r ; r = r->next )
			if ( r->lock == 0 )
				break;
	}
	else if ( (*rp)->w == 0 ) {
		r = *rp;
		*rp = r->next;
		d_f_ree(r->server);
		d_f_ree(r);
		goto retry2;
	}
	else {
		r = *rp;
	}
	if ( r == 0 ) {
		sleep_task((int)&que_head,res_lock);
		goto retry;
	}
	r->lock = get_tid();
	max = HANDLING_MAX;
	for ( ; r->w && max > 0 ; max -- ) {
		w = r->w;
		r->w = w->next[QUE_NEXT];
		w->next[QUE_NEXT] = ret;
		ret = w;
	}
	unlock_task(res_lock,"delete_res_que");
	return ret;
}

RESOURCE_TYPE_LIST *
get_resource_type(RESOURCE_TYPE_LIST * rt,char * tag)
{
	if ( rt == 0 )
		rt = &res_type_list[0];
	else if ( rt->tag_name == 0 )
		return 0;
	else 	rt ++;
	for ( ; rt->tag_name ; rt ++ ) {
		if ( strcmp(rt->tag_name,tag) == 0 )
			return rt;
	}
	return 0;
}

void
free_lrw(int next_type,LOAD_RESOURCE_WORK * w)
{
int i;
LOAD_RESOURCE_WORK * w2;
	for ( ; w ; w = w2 ) {
		w2 = w->next[next_type];
		if ( w->err != LRWE_NOTUSE )
			continue;
		free_url(&w->url);
		if ( w->target )
			d_f_ree(w->target);
		d_f_ree(w);
	}
}


int
loading_coord(LOAD_RESOURCE_WORK * ret,LOAD_RESOURCE_WORK * w)
{
L_CHAR * buf;
int len;
	copy_url(&ret->url,&w->url);
	len = l_strlen(ret->url.resource);
	buf = d_alloc(sizeof(L_CHAR)*(len+10),1235);
	memcpy(buf,ret->url.resource,
		sizeof(L_CHAR)*len);
	memcpy(&buf[len],l_string(std_cm,".chi"),sizeof(L_CHAR)*5);
	d_f_ree(ret->url.resource);
	ret->url.resource = buf;
	return 0;
}

int
setup_coord(LOAD_RESOURCE_WORK * lp,LOAD_RESOURCE_WORK * w)
{
	load_children(w->result,lp->meta_result);
	return 0;
}

LOAD_RESOURCE_WORK * 
new_lrw(LOAD_RESOURCE_WORK * w,int next_type)
{
LOAD_RESOURCE_WORK * ret;
	ret = d_alloc(sizeof(*ret),1234);
	ret->next[next_type] = w;
	ret->next[1-next_type] = 0;
	ret->option = LRO_FULL;
	ret->wup = 0;
	zero_url(&ret->url);
	ret->err = LRWE_NOTUSE;
	ret->result = 0;
	ret->meta_result = 0;
	ret->data_result = 0;
	ret->target = 0;
	ret->rt = 0;
	ret->co = 0;
	return ret;
}

void
_load_resource_list(int ses,int next_type,LOAD_RESOURCE_WORK * w)
{
LOAD_RESOURCE_WORK * wp, * lp, * lpp;
XL_SEXP * cat,* file, * ret,* meta;
RESOURCE_TYPE_LIST * rt;
L_CHAR * _cat;
RESOURCE * rr;
XL_SEXP * set_resource_header();
XLISP_ENV * env;
XL_SEXP * last_tag;
COORDINATE_UNIT * cup;



	gc_push(0,0,"_load_resource_list");



	_load_meta_list(ses,"meta",1,next_type,w);
	wp = w;
	for ( ; wp ; wp = wp->next[next_type] ) {
		if ( wp->err != LRWE_HANDLING )
			continue;
		cat = get_el_by_symbol(
			meta = get_el_by_symbol(
				wp->meta_result,
				l_string(std_cm,"meta"),0),
			l_string(std_cm,"category"),0);
		if ( cat == 0 ) {
			wp->err = LRWE_ERROR_FORMAT1;
			continue;
		}
		cat = get_el(cat,1);
		if ( cat == 0 ) {
			wp->err = LRWE_ERROR_FORMAT2;
			continue;
		}
		if ( get_type(cat) != GBT_STRING ) {
			wp->err = LRWE_ERROR_FORMAT3;
			continue;
		}
		_cat = cat->string.data;
		rt = 0;
		for ( ; ; ) {
			rt = get_resource_type(rt,n_string(std_cm,_cat));
			if ( rt == 0 ) {
				wp->err = LRWE_ERROR_NO_RES_TYPE;
				goto next;
			}
			if ( strcmp(rt->file_type,"*") == 0 )
				file = get_el_by_symbol(
					meta,
					l_string(std_cm,"file"),
					0);
			else	file = get_el_by_symbol(
					meta,
					l_string(std_cm,"file"),
					l_string(std_cm,"type"),
					l_string(std_cm,rt->file_type),
					0);
			if ( file == 0 )
				continue;
			if ( rt->flags & RTF_TARGET ) {
				file = get_el(file,1);
				if ( get_type(file) != GBT_STRING )
					continue;
				wp->target = compose_url(
					get_url_str2(&wp->url),
					file->string.data);
			}
			else {
				wp->target = 0;
			}
			wp->rt = rt;
			break;
		}
	next:
		{}
	}
	wp = w;
	cup = d_alloc(sizeof(*cup),123);
	for ( ; wp ; wp = wp->next[next_type] ) {
		if ( wp->err != LRWE_HANDLING )
			continue;
		switch ( wp->option ) {
		case LRO_UNIT:
			setup_c_unit(cup,ses,get_url_str2(&wp->url),
				wp->meta_result,0);
			wp->err = LRWE_OK;
			wp->result = 0;
			free_c_unit(cup);
			break;
		}
	}
	d_f_ree(cup);

	wp = w;
	for ( ; wp ; wp = wp->next[next_type] ) {
		if ( wp->err != LRWE_HANDLING )
			continue;
		rr = search_resource_by_entry(&wp->url);
		if ( rr ) {
			wp->err = LRWE_OK;
			wp->result = rr;
			continue;
		}
		rr = wp->result = new_resource_entry(
			wp->rt->resource_type_num,&wp->url);
		if ( wp->target ) {
		URL u;
			get_url2(&u,wp->target,12);
			set_resource_target(rr,&u);
			free_url(&u);
		}
		else	set_resource_target(rr,&wp->url);

		gc_push(0,0,"new_resouce");
		gc_push(0,0,"new_resouce1");

		meta = get_el_by_symbol(
			wp->meta_result,
			l_string(std_cm,"meta"),0);

		ret = set_resource_header(rr,meta);
		if ( get_type(ret) == GBT_ERROR ) {
			set_init_status_error(rr,ret);
			wp->err = LRWE_ERROR_HEADER_INIT;
			goto err_end;
		}
		ret = (*gv_new_table[wp->rt->resource_type_num])
			(rr,meta,NR_NEW);
		if ( get_type(ret) == GBT_ERROR ) {
			set_init_status_error(rr,ret);
			wp->err = LRWE_ERROR_BODY_INIT;
			goto err_end;
		}

		new_resource_option();

		if ( wp->rt->resource_type_num == RT_COORDINATE )
			call_gv_event(RID_HIDE_COORD,
				l_string(std_cm,"insert-coord"));
		gc_pop(0,0);

		gc_push(0,0,"new_resouce2");

		if ( gv_resource_env[rr->h.type] ) {
			env = new_env(
				new_env_pair(gv_resource_env[rr->h.type],
					gblisp_top_env0));
			set_env(env,l_string(std_cm,"__resource"),
				get_ptr(rr,0));
			last_tag = wp->data_result;
			for ( ; get_type(last_tag) == GBT_PAIR &&
				get_type(cdr(last_tag)) != GBT_NULL ;
				last_tag = cdr(last_tag) );
			if ( get_type(last_tag) != GBT_PAIR ) {
				set_init_status_error(rr,0);
				wp->err = LRWE_ERROR_NO_ROOT_XML;
				goto err_end;
			}
			ret = eval(env,car(last_tag));
			if ( get_type(ret) == GBT_ERROR ) {
ss_printf("--------- ERROR %i\n",rr->h.type);
print_sexp(s_stdout,last_tag,0);
ss_printf("\n");
print_sexp(s_stdout,ret,0);
ss_printf("\n");

				set_init_status_error(rr,ret);
				wp->err = LRWE_ERROR_BODY_EVAL;
				goto err_end;
			}
		}

	err_end:
		gc_pop(0,0);
		gc_pop(0,0);
	}
	wp = w;
	lp = 0;
	for ( ; wp ; wp = wp->next[next_type] ) {
		if ( wp->err == LRWE_HANDLING && 
				wp->rt->loading_function ) {
			lp = new_lrw(lp,QUE_NEXT);
			lp->co = wp;
			lp->err = LRWE_HANDLING;
			(*wp->rt->loading_function)(lp,wp);
		}
	}
	if ( lp )
		_load_meta_list(ses,"data",0,QUE_NEXT,lp);
	lpp = lp;
	for ( ; lpp ; lpp = lpp->next[QUE_NEXT] ) {
	int er;
		if ( lpp->err != LRWE_HANDLING ) {
			lpp->co->err = lpp->err;
			continue;
		}
		er = (*lpp->co->rt->setup_function)(lpp,lpp->co);
		if ( er ) {
			lpp->co->err = er;
			lpp->co->result = 0;
		}
	}
	free_lrw(QUE_NEXT,lp);
	lock_task(res_lock);
	wp = w;
	for ( ; wp ; wp = wp->next[QUE_NEXT] ) {
		if ( wp->err == LRWE_HANDLING ) {
			wp->err = LRWE_OK;
			wp->result->h.flags |= RF_COMPLETE;
			wakeup_task((int)wp->result);
		}
	}
	unlock_task(res_lock,"_load_resource_task");

	gc_pop(0,0);
}


int
lrw_len(LOAD_RESOURCE_WORK * wp,int next)
{
int ret;
	ret = 0;
	for ( ; wp ; wp = wp->next[next] )
		ret ++;
	return ret;
}


void
_load_resource_task()
{
int ses;
LOAD_RESOURCE_WORK * wp, * wp2;
XL_INTERPRETER * xli;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);


	ses = open_session(SEST_DIRECT);
	for ( ; ; ) {
		wp = delete_res_que();
		if ( wp == 0 )
			er_panic("_load_resource_task");
		_load_resource_list(ses,QUE_NEXT,wp);
		for ( wp2 = wp ; wp2 ; wp2 = wp2->next[QUE_NEXT] ) {
			wakeup_task(wp2->wup);
		}
	}
}


void
lrl_test(LOAD_RESOURCE_WORK * w)
{
LOAD_RESOURCE_WORK * wp;
	fflush(stdout);
	ss_printf("LRL\n");
	for ( wp = w ; wp ; wp = wp->next[REQ_NEXT] ) {
		ss_printf("\t%ls %i %x %x %x %x\n",
			get_url_str2(&wp->url),
			wp->err,
			wp->result,
			wp->meta_result,
			wp->data_result,
			wp->co);
/*
		if ( wp->meta_result ) {
			ss_printf("\tmeta:");
			print_sexp(s_stdout,wp->meta_result,0);
			ss_printf("\n");
		}
		if ( wp->data_result ) {
			ss_printf("\tdata:");
			print_sexp(s_stdout,wp->data_result,0);
			ss_printf("\n");
		}
*/
	}
	ss_printf("LRL END\n");
}

void
load_resource_list(LOAD_RESOURCE_WORK * w,int pri)
{
L_CHAR * entry;
LOAD_RESOURCE_WORK * wp;
int handling;

	if ( w == 0 )
		return;

	wp = w;
	handling = 0;
/*
ss_printf("IN - \n");
*/
	for ( ; wp ; wp = wp->next[REQ_NEXT] ) {
		entry = get_url_str2(&wp->url);
/*
ss_printf("IN %ls\n",entry);
*/
		if ( entry == 0 ) {
			wp->err = LRWE_ERROR_URL;
			continue;
		}
		entry = ll_copy_str(entry,123);
		wp->result = search_resource_by_entry(&wp->url);
		wp->meta_result = 0;
		wp->wup = (int)w;
		if ( wp->result )
			wp->err = LRWE_OK;
		else 	wp->err = LRWE_HANDLING;
		switch ( wp->option ) {
		case 0:
			break;
		case LRO_UNIT:
			if ( search_c_unit(entry) )
				wp->err = LRWE_OK;
			break;
		default:
			er_panic("load_resource_list");
		}
		if ( wp->err == LRWE_HANDLING )
			handling ++;
		d_f_ree(entry);
	}
	wp = w;
	lock_task(res_lock);
	if ( handling == 0 )
		goto slp2;
	_insert_res_que(w,pri);
slp:

	sleep_task((int)w,res_lock);
	lock_task(res_lock);
	wp = w;
	for ( ; wp ; wp = wp->next[REQ_NEXT] )
		if ( wp->err == LRWE_HANDLING )
			goto slp;
slp2:
	for ( wp = w ; wp ; wp = wp->next[REQ_NEXT] ) {
		if ( wp->err != LRWE_OK )
			continue;
		if ( wp->result == 0 )
			continue;
		if ( !(wp->result->h.flags & RF_COMPLETE) ) {
			sleep_task((int)wp->result,res_lock);
			lock_task(res_lock);
			goto slp2;
		}
	}
	unlock_task(res_lock,"load_resource_list");
/*
ss_printf("OUT\n");
*/

	return;
}


RESOURCE *
get_lrw(LOAD_RESOURCE_WORK * w,URL * u)
{
LOAD_RESOURCE_WORK * wp;

	wp = w;
	for ( ; wp ; wp = wp->next[REQ_NEXT] ){

		if ( wp->err != LRWE_OK )
			continue;
		if ( 	l_strcmp(wp->url.proto,u->proto) == 0 &&
			l_strcmp(wp->url.server,u->server) == 0 &&
			wp->url.port == u->port &&
			l_strcmp(wp->url.db,u->db) == 0 &&
			l_strcmp(wp->url.resource,u->resource) == 0 )  {

			return wp->result;
		}
	}
	return 0;
}


RESOURCE *
load_resource(int ses,URL * u,int pri)
{
LOAD_RESOURCE_WORK * w;
RESOURCE * r;

	w = new_lrw(0,REQ_NEXT);
	copy_url(&w->url,u);
	w->err = LRWE_HANDLING;
	load_resource_list(w,pri);
	if ( w->err != LRWE_OK ) {
printf("load_resource error %x %i\n",w,w->err);
		r = 0;
	}
	else {
		r = w->result;
		free_lrw(REQ_NEXT,w);
	}
	return r;
}



