/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"resource.h"
#include	"xl.h"
#include	"memory_debug.h"

XL_SEXP * 
load_meta(int ses,char * mode,L_CHAR * target)
{
XL_SEXP * ret;
XL_SEXP * gt;
L_CHAR * f;
URL u;
void gc_gb_sexp();

	get_url2(&u,target,1609);

	gc_push(0,0,"remote_fetch");
	gt = get_symbol(l_string(std_cm,"Get"));
	set_attribute(gt,
		l_string(std_cm,"mode"),
		l_string(std_cm,mode));

	f = get_url_filepath(&u);

	ret = remote_session(
		gblisp_top_env0,
		ses,
		&u,
		0,
		l_string(std_cm,"user"),
		l_string(std_cm,"Get"),
		List(List(gt,
			get_string(f),
			-1),
			-1),
		0,0,0);
	d_f_ree(f);

if ( get_type(ret) == GBT_ERROR ){
fflush(stdout);
ss_printf("loadmeta(%i)(%s) %ls = ",get_tid(),mode,get_url_str2(&u));
print_sexp(s_stdout,ret,0);
ss_printf("\n");
ss_printf("\n");
log_print_sexp(LOG_DEBUG,"loadmeta=",ret,0);
}
	gc_pop(ret,gc_gb_sexp);
	return ret;
}




void
_load_meta_list(int ses,char * mode,int data_flag,
		int next_type,LOAD_RESOURCE_WORK * w)
{
XL_SEXP * ret, * s;
XL_SEXP * gt;
L_CHAR * f;
URL u;
void gc_gb_sexp();
XL_SEXP * query;
LOAD_RESOURCE_WORK * wp,* target;


	gc_push(0,0,"remote_fetch");

	gt = get_symbol(l_string(std_cm,"Get"));
	set_attribute(gt,
		l_string(std_cm,"mode"),
		l_string(std_cm,mode));

	query = 0;
	wp = w;
	target = 0;
	for ( ; wp ; wp = wp->next[next_type] ) {
		if ( wp->err != LRWE_HANDLING )
			continue;
		if ( target == 0 )
			target = wp;
		f = get_url_filepath(&wp->url);
		query = cons(
			List(gt,
				get_string(f),
				-1),
			query);
		d_f_ree(f);
	}
	if ( target == 0 )
		goto end;
	if ( data_flag ) {
		wp = w;
		for ( ; wp ; wp = wp->next[next_type] ) {

			if ( wp->err != LRWE_HANDLING )
				continue;
			f = get_url_filepath(&wp->url);
			query = cons(
				List(n_get_symbol("Get"),
					get_string(f),
					-1),
				query);
			d_f_ree(f);
		}
	}
	ret = 0;
	for ( ; get_type(query) ; query = cdr(query) )
		ret = cons(car(query),ret);
	query = ret;


	query = cons(n_get_symbol("List"),query);

	ret = remote_session(
		gblisp_top_env0,
		ses,
		&target->url,
		0,
		l_string(std_cm,"user"),
		l_string(std_cm,"Get"),
		List(query,-1),
		0,0,0);

	if ( get_type(ret) != GBT_ERROR ) {
		wp = w;
		s = ret;

		for ( ; wp ; wp = wp->next[next_type] ) {
			if ( wp->err != LRWE_HANDLING )
				continue;
			if ( get_type(s) == GBT_ERROR )
				goto err;
			wp->meta_result = car(s);
			s = cdr(s) ;
		}
		if ( data_flag ) {
			wp = w;
			for ( ; wp ; wp = wp->next[next_type] ) {
				if ( wp->err != LRWE_HANDLING )
					continue;
				if ( get_type(s) == GBT_ERROR )
					goto err;
				wp->data_result = car(s);
				s = cdr(s);
			}
		}
	}
	else {
	err:
		wp = w;
		ret = 0;
		for ( ; wp ; wp = wp->next[next_type] ) {
			if ( wp->err != LRWE_HANDLING )
				continue;
			wp->meta_result
				= load_meta(ses,mode,
					get_url_str2(&wp->url));
			if ( get_type(wp->meta_result) == GBT_ERROR ) {
				wp->meta_result = 0;
				wp->err = LRWE_ERROR_GET1;
				continue;
			}
			else	ret = cons(wp->meta_result,ret);
			wp->data_result
				= load_meta(ses,"data",
					get_url_str2(&wp->url));
			if ( get_type(wp->data_result) == GBT_ERROR ) {
				wp->err = LRWE_ERROR_GET2;
				wp->data_result = 0;
				continue;
			}
			else	ret = cons(wp->data_result,ret);
		}
	}
end:
	gc_pop(ret,gc_gb_sexp);
}



