/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"acrp.h"

int *
list2cid(XL_SEXP * s)
{
int * ret;
int len,i;
XL_SEXP * t;
	t = car(s);
	switch ( get_type(t) ) {
	case GBT_SYMBOL:
		s = cdr(s);
		break;
	case GBT_INTEGER:
		break;
	default:
		return 0;
	}
	len = list_length(s);
	if ( len < 0 )
		return 0;
	ret = d_alloc(sizeof(int)*(len+1),1);
	i = 1;
	for ( ; get_type(s) ; s = cdr(s) , i ++ ) {
		t = car(s);
		if ( get_type(t) != GBT_INTEGER )
			goto err;
		ret[i] = t->integer.data;
	}
	ret[0] = len;
	return ret;
err:
	d_f_ree(ret);
	return 0;
}
