/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"acrp.h"

int
get_acrp_entry_dir(ACRP_DIR * d,XL_SEXP * s)
{
XL_SEXP * t;
	d->flags = 0;
	s = cdr(s);
	t = car(s);
	if ( get_type(t) != GBT_INTEGER )
		return -1;
	d->hops = t->integer.data;
	s = cdr(s);
	t = car(s);
	if ( get_type(t) != GBT_STRING )
		return -1;
	d->map = ll_copy_str(t->string.data,1438);
	s = cdr(s);
	t = car(s);
	if ( get_type(t) != GBT_STRING )
		return -1;
	d->crd = ll_copy_str(t->string.data,1437);
	if ( d->hops == 0 ) {
		if ( d->map )
			d_f_ree(d->map);
		if ( d->crd )
			d_f_ree(d->crd);
		d->map = nl_copy_str(std_cm,"");
		d->crd = nl_copy_str(std_cm,"");
	}
	return 0;
}

void
init_entry_dir(ACRP_DIR * d)
{
	d->hops = -1;
	d->map = 0;
	d->crd = 0;
}

int
get_acrp_entry(int * id,ACRP_ENTRY * e,XL_SEXP * s)
{
XL_SEXP * t;
int i;
	s = cdr(s);
	t = car(s);
	if ( get_type(t) != GBT_INTEGER )
		return -1;
	*id = t->integer.data;
	s = cdr(s);
	t = car(s);
	if ( get_type(t) != GBT_STRING )
		return -1;
	e->pri = ll_copy_str(t->string.data,1436);
	s = cdr(s);
	t = car(s);
	if ( get_type(t) != GBT_INTEGER )
		return -1;
	e->sum = t->integer.data;

	s = cdr(s);

	for ( i = 0 ; i < ACRP_DIR_NOS ; i ++ )
		init_entry_dir(&e->dir[i]);
	i = 0;
	for ( ; get_type(s) && i < ACRP_DIR_NOS ; s = cdr(s) , i ++ ) {
		if ( get_acrp_entry_dir(&e->dir[i],car(s)) < 0 )
			return -1;
	}
	return 0;
}


MAP_PATH_TABLE *
get_one_mpt(XL_SEXP * s)
{
MAP_PATH_TABLE * m;
int i,j;
ACRP_ENTRY e;
int id;
XL_SEXP * t;
	m = new_mpt(); 
	s = cdr(s);
	t = car(s);
	if ( get_type(t) != GBT_INTEGER ) {
		d_f_ree(m);
		return 0;
	}
	m->level = t->integer.data;
	s = cdr(s);
	for ( ; get_type(s) == GBT_PAIR ; s = cdr(s) ) {
		if ( get_acrp_entry(&id,&e,car(s)) < 0 ) {
			free_mpt(m);
			return 0;
		}
		m->ent[id] = e;
		if ( e.dir[0].hops == 0 )
			m->id = id;
	}
	return m;
}


MAP_PATH_TABLE *
get_mpt(unsigned int * reg,XL_SEXP * s)
{
MAP_PATH_TABLE * mpt;
MAP_PATH_TABLE ** mp;
MAP_PATH_TABLE * m1;
XL_SEXP * t, * sym;
XL_SEXP * r;
	mpt = 0;
	s = cdr(s);
	*reg = 0;
	for ( ; get_type(s) ; s = cdr(s) ) {
		t = car(s);
		if ( get_type(t) != GBT_PAIR )
			continue;
		sym = car(t);
		if ( get_type(sym) != GBT_SYMBOL )
			continue;
		if ( l_strcmp(sym->symbol.data,l_string(std_cm,"regulation"))
				== 0 ) {
			r = get_el(t,1);
			if ( get_type(r) != GBT_INTEGER )
				goto err;
			*reg = r->integer.data;
		}
		else if ( l_strcmp(sym->symbol.data,l_string(std_cm,"level"))
				== 0 ) {
			m1 = get_one_mpt(t);
			if ( m1 == 0 )
				goto err;
			m1->next = 0;
			for ( mp = &mpt ; *mp ; mp = &(*mp)->next ) {
				if ( (*mp)->level < m1->level )
					continue;
				m1->next = *mp;
				*mp = m1;
				goto next;
			}
			*mp = m1;
		next:
			{}
		}
	}
	return mpt;
err:
	free_mpt(mpt);
	return 0;
}
