/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

#include "HTMLDB.h"

XL_SEXP * xl_Raw();

void
init_Raw(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Raw"),
		get_func_prim(xl_Raw,FO_NORMAL,0,2,2));
}

XL_SEXP *
xl_Raw(XLISP_ENV * env,XL_SEXP * s,
	  XLISP_ENV * arg_env,XL_SYM_FIELD * sf)
{
	XL_SEXP * ret;
	XL_SEXP* html_env;
	XL_SEXP* d;
	XL_SEXP* url;
	XL_SEXP* tmp = 0;
	int i,n;
	L_CHAR* URLString;

	d = get_el(s,1);
	html_env = List(n_get_string("Raw"),d,-1);
	
	URLString = GetOption(l_string(std_cm,"url"),sf);
	url = MakeURLList(URLString,env);

//print_sexp(s_stdout,url,PF_LISP);
//printf("\n");	
	
	html_env = append(url,html_env);

//$B%m%C%/3+;O(B
lock_task(http_lock);

	d = GetElement(URLString,HTMLDataBase);
	if ( d )
		HTMLDataBase = RemoveElement(URLString,HTMLDataBase);
	HTMLDataBase = cons(html_env,HTMLDataBase);

unlock_task(http_lock,"xl_HTML()");

	ret = exec_option(
		GetOption(l_string(std_cm,"update"),sf),
		html_env,
		0,
		s->h.file,
		s->h.line);
//$B%m%C%/=*N;(B
	if ( get_type(ret) == GBT_ERROR )
		return ret;
	return HTMLDataBase;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Raw"),
		list(	n_get_string(
		"type missmatch"),
			0));
}




