/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

#include "HTMLDB.h"

XL_SEXP * xl_HTML();

void
init_HTML(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"HTML"),
		get_func_prim(xl_HTML,FO_NORMAL,0,1,-1));
}

XL_SEXP *
xl_HTML(XLISP_ENV * env,XL_SEXP * s,
	  XLISP_ENV * arg_env,XL_SYM_FIELD * sf)
{
	XL_SEXP * ret;
	XL_SEXP* html_env = 0;
	XL_SEXP* d;
	XL_SEXP* url;
	XL_SEXP* tmp = 0;
	int i,n;
	L_CHAR* URLString;

/*
	printf("xl_HTML\n");
	if(HTMLDataBase);
	print_sexp(s_stdout,HTMLDataBase,PF_LISP);
*/

	if(l_strcmp(GetOption(l_string(std_cm,"eval"),sf),l_string(std_cm,"on")) == 0)
	{
		//$BI>2A$7$FEPO?$9$k(B
		html_env = cons(eval(env,car(cdr(s))),html_env);
	}
	else {
		html_env = cons(
			cons(get_symbol(l_string(std_cm,"HTML")),
				cdr(s)),
			html_env);
	}

	html_env = cons(n_get_string("HTML"),html_env);
	
	URLString = GetOption(l_string(std_cm,"url"),sf);
	url = MakeURLList(URLString,env);

//print_sexp(s_stdout,url,PF_LISP);
//printf("\n");	
	
	html_env = append(url,html_env);

//$B%m%C%/3+;O(B
lock_task(http_lock);

	d = GetElement(URLString,HTMLDataBase);
	if ( d )
		HTMLDataBase = RemoveElement(URLString,HTMLDataBase);
	HTMLDataBase = cons(html_env,HTMLDataBase);

unlock_task(http_lock,"xl_HTML()");

	ret = exec_option(
		GetOption(l_string(std_cm,"update"),sf),
		html_env,
		0,
		s->h.file,
		s->h.line);
//$B%m%C%/=*N;(B
	if ( get_type(ret) == GBT_ERROR )
		return ret;
	return HTMLDataBase;
}




