/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

/************************************

	machine dependent
	task routines

*************************************/

#include	<stdlib.h>
#include	<stdio.h>
#include	<signal.h>
#include	<windows.h>
#include	<tlhelp32.h>
#include	<process.h>

#include	"machine/err.h"
#include	"memory_debug.h"
#include	"task.h"
#include "init.h"


#define DTI_LENGTH		10000


typedef struct task_block {
	struct task_block *	next;
	int			cmd;
#define TBC_EXEC		1
#define TBC_FINISH		2
	int			hard_tid;
	int			soft_tid;
	int			data;
	void 			(*func)();
	unsigned int		finish_time;
} TASK_BLOCK;

typedef struct dti {
	TASK_BLOCK *		tb;
	void			(*func)();
	int			msg;
	int			msg2;
} DTI;

void er_panic(char * str);

DTI * debug_task_info;
int task_init;

s_task_flag = INI_WDONTCARE;

#define PRI_MAX 6 
static const int win_pri_table[] = 
	{
		THREAD_PRIORITY_IDLE,
		THREAD_PRIORITY_LOWEST,
		THREAD_PRIORITY_BELOW_NORMAL,
		THREAD_PRIORITY_NORMAL,
		THREAD_PRIORITY_ABOVE_NORMAL,
		THREAD_PRIORITY_HIGHEST,
		THREAD_PRIORITY_TIME_CRITICAL
	};

#define MAX_TEST 10
int test_tid[MAX_TEST];
int test_tno[MAX_TEST];

void
sleep_sec(int x)
{
	Sleep(x*1000);
}

int win_pri2gbs_pri(int pri)
{
	int i;
	for(i=0; i<PRI_MAX; ++i){
		if(win_pri_table[i] == pri){
			return i;
		}
	}
	er_panic("win_pri2gbs_pri");
	return 0;
}

void
alarm_handler()
{
}

void
bpipe_handler()
{
}

void
siglwp_handler()
{
}

int (*int_handler)();

void
set_alarm_mask()
{
}

void
init_task(int level)
{
int i;
void sw_init();

	if ( task_init )
		return;
	task_init = 1;

	debug_task_info = malloc(sizeof(DTI)*DTI_LENGTH);
	for ( i = 0 ; i < DTI_LENGTH ; i ++ ) {
		debug_task_info[i].tb = 0;
		debug_task_info[i].func = 0;
		debug_task_info[i].msg = 0;
		debug_task_info[i].msg2 = 0;
	}
	
	s_task_flag = level;
	sw_init();

//	set_alarm_mask(flags);
/*	set_alarm_mask(level);
	init_thread_block();
	sw_init();

	task_lock = new_lock(LL_TASK);
	_create_task(_task_timeout,0,1);

	setup_main_thread();
	task_init = 2;
*/
}

void
set_t_msg(int msg)
{
int tid;
	tid = get_tid();
	debug_task_info[tid % DTI_LENGTH].msg = msg;
}


void
set_t_msg2(int msg)
{
int tid;
	tid = get_tid();
	debug_task_info[tid % DTI_LENGTH].msg2 = msg;
}


SEM sem_list = 0;

#ifdef DEADLOCK_CHECK
#include  <assert.h> 
SEM
new_lock(int level)
{
SEM s;
SEM *sp;
	s = d_alloc(sizeof(*s),307);
	sem_init(s,0,1);
	s->level = level;
	s->tid = 0;
	for(sp = &sem_list; *sp; sp = &((*sp)->next)){
		if((*sp)->level > level){
			s->next = *sp;
			*sp = s;
			return s;
		}
	}
	s->next = 0;
	*sp = s;
	return s;
}

void close_lock(SEM s)
{
SEM * sp;
	for ( sp = &sem_list ; *sp ; sp = &(*sp)->next ){
		if ( *sp == s ) {
			*sp = s->next;
			break;
		}
	}
	sem_destroy(s);
	d_f_ree(s);
}

void lock_task(SEM s)
{
SEM sp;
int tid;
	tid = get_tid();
	for(sp = sem_list ; sp ; sp = sp->next){
		if(s == sp){
			if(sp->tid == tid)
				assert(0); //"DOUBLELOCK"
			break;
		}
		if( sp->tid == tid){
			assert(0); //"DEADLOCK"
		}
	}
	sem_wait(s);
	s->tid = tid;
}

void unlock_task(SEM s,char *str)
{
	s->tid = 0;
	sem_post(s);
if ( s->sem_count >= 2 ) {
fprintf(stderr,"*********** ???? %s %i ************\n",str,get_tid());
exit(2);
}

#endif // DEADLOCK_CHECK

#ifndef DEADLOCK_CHECK
SEM
new_lock(int level)
{
SEM s;

	s = d_alloc(sizeof(*s),307);
	sem_init(s,0,1);
	sem_trywait(s);
	sem_post(s);
	return s;
}
void close_lock(SEM s)
{
	sem_destroy(s);
	d_f_ree(s);
}
void
lock_task(SEM s)
{
	sem_wait(s);
}

void
unlock_task(SEM s,char *str)
{
	sem_post(s);
if ( s->sem_count >= 2 ) {
fprintf(stderr,"*********** ???? %s %i ************\n",str,get_tid());
exit(2);
}

#endif // ndef DEADLOCK_CHECK


/*
if ( env.wf_lock == s )
printf("unlock %i\n",get_tid());
*/
}

/**************************************************************
int
get_pri(int tid)
{
struct sched_param sp;
int i;
int ret;
int p;
	if ( tid == 0 )
		tid = get_tid();
	ret = pthread_getschedparam(tid,&p,&sp);
	switch ( ret ) {
	case 0:
		break;
	default:
		printf("cange_priority(1)%i\n",ret);
	}
	for ( i = 0; i < PRI_MAX ; i ++ )
		if ( pri_table[i] == sp.sched_priority )
			return i;
	er_panic("invalid pri\n");
	return 0;
}
*************************************************************/
int get_pri(int tid)
{
	int pri;
	HANDLE hTread;
	if(tid==0){
		hTread = GetCurrentThread();
	}
	else{
		HANDLE hSnapShot = CreateToolhelp32Snapshot(TH32CS_SNAPTHREAD,0);
		THREADENTRY32 te;
		te.dwSize = sizeof(te);
		if(Thread32First(hSnapShot, &te)){
			do{
				if(te.th32ThreadID == (DWORD)tid){
					CloseHandle(hSnapShot);
					return win_pri2gbs_pri(te.tpBasePri + te.tpDeltaPri);
				}
			}while(Thread32Next(hSnapShot, &te));
		}
		else{
			CloseHandle(hSnapShot);
			er_panic("invalid pri\n");
			return 0;
		}
	}
	pri = GetThreadPriority(hTread);
	if(pri == THREAD_PRIORITY_ERROR_RETURN ){
		er_panic("invalid pri\n");
		return 0;
	}
	else
		return win_pri2gbs_pri(pri);
}

/************************************************************
void
change_pri(int tid,int pri)
{
struct sched_param sp;
int ret;
int p;
	if ( tid == 0 )
		tid = get_tid();
	if ( pri < 0 )
		pri = 0;
	if ( pri >= PRI_MAX )
		pri = PRI_MAX-1;
	ret = pthread_getschedparam(tid,&p,&sp);
	switch ( ret ) {
	case 0:
		break;
	default:
		printf("cange_priority(1)%i\n",ret);
	}
	sp.sched_priority = pri_table[pri];
	ret = pthread_setschedparam(tid,SCHED_RR,&sp);
	switch ( ret ) {
	case 0:
		return;
	default:
		printf("cange_priority(2)%i\n",ret);
	}
}
***********************************************************/
int 
change_pri(int tid, int pri)
{
	if(pri<0 || PRI_MAX <pri){
		fprintf(stderr,"pri is out of range : %d\n",pri);
		return 0;
	}
	if(tid == 0){
		tid = (int)GetCurrentThread();
	}
	if(!SetThreadPriority((HANDLE)tid, win_pri_table[pri]))
		fprintf(stderr,"can not set priority: %d\n",pri);
	else
		return 1;

	return 0;
}

int
create_task(void (*func)(),int data, int pri)
{
unsigned long ret;
void (__cdecl *f)(void *);
int * d;
	f = (void (__cdecl *)(void *))func;
	d = d_alloc(sizeof(int),309);
	*d = data;

	ret = _beginthread(f, 0, (void *)d);
	switch ( ret ) {
	case ESYS_AGAIN:
		fprintf(stderr,"EAGAIN\n");
		break;
	case ESYS_INVAL:
		fprintf(stderr,"EINVAL\n");
		break;
	case -1:
		fprintf(stderr,"default\n");
		break;
	default:
		change_pri(ret, pri);
	}
	return ret;
}

int
GET_TKEY(TKEY d)
{
int ret;
int * ptr;
	ptr = d;
	ret = *ptr;
	d_f_ree(d);
	return ret;
}

void
rw_lock_init(RW_LOCK * rwl,int level)
{
	rwl->lock = new_lock(level);
	rwl->read_cnt = 0;
}

void
read_lock(RW_LOCK * rwl)
{
	lock_task(rwl->lock);
	for ( ; rwl->read_cnt < 0 ; ) {
		unlock_task(rwl->lock,"read_lock(1)");
		Sleep(10);
		lock_task(rwl->lock);
	}
	rwl->read_cnt ++;
	unlock_task(rwl->lock,"read_lock(2)");
}

void
write_lock(RW_LOCK * rwl)
{
	lock_task(rwl->lock);
	for ( ; rwl->read_cnt != 0 ; ) {
		unlock_task(rwl->lock,"write_lock(1)");
		Sleep(10);
		lock_task(rwl->lock);
	}
	rwl->read_cnt = -1;
	unlock_task(rwl->lock,"write_lock(2)");
}

void
rwl_unlock(RW_LOCK * rwl)
{
	lock_task(rwl->lock);

	if ( rwl->read_cnt > 0 )
		rwl->read_cnt --;
	else if ( rwl->read_cnt < 0 )
		rwl->read_cnt = 0;
	else	er_panic("rwl_unlock(1)");
	unlock_task(rwl->lock,"rwl_unlock(1)");
}
/*
void
init_fifo(FIFO * f)
{
	f->head = f->tail = 0;
	f->lock = new_lock();
	f->length = 0;
}
*/
void
insert_fifo(FIFO * f,FIFO_EL * e)
{
	lock_task(f->lock);
	e->next = 0;
	if ( f->head == 0 )
		f->head = f->tail = e;
	else {
		f->tail->next = e;
		f->tail = e;
	}
	f->length ++;
	unlock_task(f->lock,"insert_fifo");
}


FIFO_EL *
delete_fifo(FIFO * f)
{
FIFO_EL * ret;
	lock_task(f->lock);
	if ( f->head == 0 ) {
		ret = 0;
	}
	else {
		ret = f->head;
		f->head = ret->next;
		if ( f->head == 0 )
			f->tail = 0;
		f->length --;
	}
	unlock_task(f->lock,"delete_fifo");
	return ret;
}

int
get_tid()
{
	return GetCurrentThreadId();
}

void
print_tno(char * str)
{
int i;
	printf("%s ",str);
	for ( i = 0 ; i < MAX_TEST ; i ++ ) {
		if ( test_tid[i] == 0 )
			continue;
		printf("(%i-%i)",test_tid[i],test_tno[i]);
	}
	printf("\n");
}

void
test_no(int no)
{
int tid;
int i;
	tid = get_tid();
	for ( i = 0 ; i < MAX_TEST ; i ++ )
		if ( test_tid[i] == tid ) {
			test_tno[i] = no;
			return;
		}
	for ( i = 0 ; i < MAX_TEST ; i ++ )
		if ( test_tid[i] == 0 ) {
			test_tid[i] = tid;
			test_tno[i] = no;
			return;
		}
}