//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

extern "C" {

#include	"memory_debug.h"
#include 	"v.h"
#include	"long_char.h"
#include	"change_endian.h"
#include	"CLEMWindow.h"

#define namespace namespace1

extern int fontsize;

typedef struct _v_gsp {
	V_STRING_PIC * p;
	VDISPLAY * disp;
	L_CHAR * str;
	int	len;
	int	size;
	int 	dir;
	VFONT *	vf;
	L_CHAR mask;
} _V_GSP;

extern short v_font_table[];

int
_v_get_string_pic(_V_GSP	* v)
{
int w, h;
int len;
char * buf;
Point pt;
Rect rect;
FontInfo fontinfo;
RGBColor color;
L_CHAR last = v->str[v->len];
	v->str[v->len] = 0;
	buf = n_string(std_cm, v->str);
	v->str[v->len] = last;
	len = strlen(buf);
	TextFont(v_font_table[v->vf->id]);
	TextSize(fontsize);
	GetFontInfo(&fontinfo);
	w = TextWidth(buf, 0, len);
	h = fontinfo.ascent + fontinfo.descent;
	SetRect(&rect, 0, -fontinfo.ascent, w, fontinfo.descent);
	LGWorld gworld(rect);

	gworld.BeginDrawing();
	RGBForeColor(&RGB_black);
	RGBBackColor(&RGB_white);
	EraseRect(&rect);
	TextFont(v_font_table[v->vf->id]);
	TextSize(fontsize);
	MoveTo(0, 0);
	DrawText(buf, 0, len);
	GetPen(&pt);
	w = pt.h;
	unsigned char *	pic = v->p->pic = (unsigned char *)d_alloc(w*h,23);
	v->p->width = w;
	v->p->dir = v->dir;
	for ( int y = -fontinfo.ascent;  y < fontinfo.descent;  y++) {
		for ( int x = 0;  x < w;  x++ ) {
			GetCPixel(x, y, &color);
			pic[x+w*(y+fontinfo.ascent)] = color.red >> 8;
		}
	}
	v->p->r.tl.x = 0;
	v->p->r.tl.y = -fontinfo.ascent;
	v->p->r.br.x = w;
	v->p->r.br.y = fontinfo.descent;
	
	gworld.EndDrawing();
	return 0;
}

void
v_get_string_pic_call(
	V_STRING_PIC * p,
	VDISPLAY * disp,
	L_CHAR * str,
	int len,
	VFONT * vf,
	int	size,
	int 	dir,
	L_CHAR mask)
{
_V_GSP	v;
	v.p = p;
	v.disp = disp;
	v.str = str;
	v.len = len;
	v.size = size;
	v.dir = dir;
	v.vf = vf;
	v.mask = mask;
	ms_do((int(*)())_v_get_string_pic,(void *)&v,(char *)"v_get_string_pic");
}


void
compose_pic(V_STRING_PIC * p,V_STRING_PIC * pp)
{
V_STRING_PIC ppp;
int w,h,ww,hh;
int x,y,i;
int y_ofs,x_ofs;
	ppp.width = p->width + pp->width;
	ppp.dir = p->dir;
	ppp.r.tl.x = p->r.tl.x;
	if ( p->r.tl.y < pp->r.tl.y )
		ppp.r.tl.y = p->r.tl.y;
	else	ppp.r.tl.y = pp->r.tl.y;
	ppp.r.br.x = p->width + pp->r.br.x;
	if ( p->r.br.y < pp->r.br.y )
		ppp.r.br.y = pp->r.br.y;
	else	ppp.r.br.y = p->r.br.y;
	w = ppp.r.br.x - ppp.r.tl.x;
	h = ppp.r.br.y - ppp.r.tl.y;
	ppp.pic = (unsigned char *)d_alloc(w*h,230);
	for ( i = 0 ; i < w*h ; i ++ )
		ppp.pic[i] = 255;
	ww = p->r.br.x - p->r.tl.x;
	hh = p->r.br.y - p->r.tl.y;
	y_ofs = p->r.tl.y - ppp.r.tl.y;
	i = 0;
	for ( y = y_ofs ; y < hh+y_ofs ; y ++ )
		for ( x = 0 ; x < ww ; x ++ )
			ppp.pic[x + y*w] = p->pic[i++];
	x_ofs = -ppp.r.tl.x+p->width+pp->r.tl.x;
	y_ofs = pp->r.tl.y - ppp.r.tl.y;
	ww = pp->r.br.x - pp->r.tl.x;
	hh = pp->r.br.y - pp->r.tl.y;
	i = 0;
	for ( y = y_ofs ; y < hh+y_ofs ; y ++ )
		for ( x = x_ofs ; x < ww+x_ofs ; x ++ ){
			if ( pp->pic[i] != 255 )
				ppp.pic[x + y*w] = pp->pic[i];
			i ++;
		}
	d_f_ree(p->pic);
	d_f_ree(pp->pic);
	*p = ppp;
}


void
v_get_string_pic(
	V_STRING_PIC * p,
	VDISPLAY * disp,
	L_CHAR * str,
	int	size,
	int 	dir)
{
int len;
int i,j;
V_STRING_PIC pp;
L_CHAR unknown;
int f;
WRITABLE_CODE_TABLE * t;
	len = l_strlen(str);
	unknown = '?';
	f = 0;
	for ( i = 0 ; i < len ; ) {
		t = get_wct(disp->font_work,str[i]);
		if ( t ) {
			for ( j = i ; j < len &&
				(str[j]&t->mask) == t->lcz ; j ++ );
			v_get_string_pic_call(
				&pp,
				disp,
				&str[i],
				j-i,
				(VFONT *)t->work,
				size,
				dir,
				t->mask);
			i = j;
			if ( pp.pic == 0 ) {
				v_get_string_pic_call(
					&pp,
					disp,
					&unknown,
					1,
					&disp->iso8859_1,
					size,
					dir,
					LCZM_1B_TYPE);
			}
		}
		else {
			v_get_string_pic_call(
				&pp,
				disp,
				&unknown,
				1,
				&disp->iso8859_1,
				size,
				dir,
				LCZM_1B_TYPE);
			i ++;
		}
		if ( f == 0 ) {
			*p = pp;
			f = 1;
		}
		else {
			compose_pic(p,&pp);
		}
	}
}

} // extern "C"