/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"utils.h"
#include	"memory_debug.h"

char * command_arg;

char *
get_path_from_mac_fs(FSSpec inMacFSSpec, Boolean isFolder)
{
char *ret, buf[1024], *ptr;
unsigned char * name;

	ptr = buf+sizeof(buf)-1;
	*ptr = 0;
	if ( isFolder ) {
		ptr--;
		*ptr = ':';
	}
	for ( ; ; ) {
		name = inMacFSSpec.name;
		ptr -= name[0]+1;
		if ( ptr < buf )
			er_panic("get_path_from_mac_fs buffer under error");
		memcpy(ptr+1, name+1, name[0]);
		if ( inMacFSSpec.parID != fsRtParID ) {
			*ptr = ':';
		} else {
			ret = d_alloc(buf+sizeof(buf)-ptr-1,1023);
			strcpy(ret,ptr+1);
			return ret;
		}
		if ( noErr != FSMakeFSSpec(inMacFSSpec.vRefNum, 
					inMacFSSpec.parID, "\p", &inMacFSSpec) ) 
			er_panic("get_path_from_mac_fs");
	}
}

char *
get_peripheral_path()
{
	return ":peripheral:";
}


char *
get_preference_path()
{
short vref;
long dirID;
FSSpec spec;
OSErr err;
char * ret;
	if ( err = FindFolder(kUserDomain, kPreferencesFolderType, 
				kCreateFolder, &vref, &dirID) ) {
		er_panic("get_preference_path(1)");
	}
	err = FSMakeFSSpec(vref, dirID, "\ppxlconf", &spec);

	switch ( err ) {
	case noErr :
		break;
	case fnfErr :
		if ( noErr != FSpDirCreate(&spec, smSystemScript, &dirID) )
			er_panic("get_preference_path(1)");
		break;
	default : 
		er_panic("get_preference_path(2)");
	}
		
	ret = get_path_from_mac_fs(spec,true);
	set_buffer(ret);
	return ret;
}
