//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

extern "C" {

#include	<stdlib.h>
#include	<errno.h>
#include	"memory_debug.h"
#include	"task.h"
#include	"lock_level.h"
#include	"LSimpleThread.h"
#include	"UThread.h"

void* new_block();
void free_block(void * t);

#define SW_HASH_SIZE	1000


SEM sw_lock;
SW_HASH * hash[SW_HASH_SIZE];

void
sw_init()
{
	sw_lock = new_lock(LL_SLEEP_WAKEUP);
	for ( int i = 0;  i < SW_HASH_SIZE;  i++ ) {
		hash[i] = NULL;
	}
}

void
sleep_task(unsigned int key,SEM s)
{
unsigned int kk;
SW_HASH * h;

	lock_task(sw_lock);

	kk = key%SW_HASH_SIZE;
	h = (SW_HASH *)new_block();
	h->key = key;
	h->thread = (THREAD)LThread::GetCurrentThread();
	h->next = hash[kk];
	hash[kk] = h;
	if ( s )
		 unlock_task(s,"sleep_task(1)");
	unlock_task(sw_lock,"sleep_task(2)");
	h->thread->Suspend();
}


void _ExStop(void);
void _ExRevert(void);
void _ExThrow(void);

void
wakeup_task(unsigned int key)
{
unsigned int kk;
SW_HASH *h, *hp = NULL, *hn;
THREAD	thread;

	kk = key%SW_HASH_SIZE;
	lock_task(sw_lock);
	for ( h = hash[kk];  h;  h = hn ) {
		hn = h->next;
		if ( h->key == key ) {
			if (hp)
				hp->next = hn;
			else
				hash[kk] = hn;
			thread = h->thread;
			free_block(h);
			thread->Resume();
		} else {
			hp = h;
		}
	}
	unlock_task(sw_lock,"wakeup_task");
} 

} //extern "C"