// ===========================================================================
//	mac_cosmos.cp		COSMOS Startup for Macintosh by Tomoki Sekiyama
// ===========================================================================

extern "C" {

#include "mac_cosmos.h"

#include <LGrowZone.h>
#include <UDrawingState.h>
#include <UMemoryMgr.h>
#include <UModalDialogs.h>
#include <URegistrar.h>
#include <UDebugging.h>
#include <UEnvironment.h>
#include <UStandardDialogs.h>

#include <LCaption.h>
#include <LPicture.h>
#include <LChasingArrows.h>

#include <LPlacard.h>
#include <LPopupButton.h>
#include <LTextGroupBox.h>

#include <LAMPopupButtonImp.h>
#include <LAMTextGroupBoxImp.h>

#include <UControlRegistry.h>
#include <LAMControlImp.h>

#include <UAttachments.h>
#include <LSIOUXAttachment.h>
#include <SIOUX.h>

#include <LThread.h>
#include <UThread.h>
#include <LCleanupTask.h>

#include <UNetworkFactory.h>

#include "CLEMWindow.h"
#include "CYieldRepeater.h"

#include "AppConstants.h"

#include "task.h"
#include "init.h"
#include "memory_debug.h"
#include "utils.h"
#include "pri_level.h"
#include	"version.h"

COSMOS  * theApp;
LWindow * aboutWindow = nil;
LWindow * preferencesWindow = nil;
LPopupButton * popupButton_JapaneseFont = nil;
LPopupButton * popupButton_RomanFont = nil;

long free_mem_size;
Handle memoryReserve = nil;

CYieldRepeater *sCYieldRepeater = nil;
UInt32 CYieldRepeater::curTick;


extern bool startup_flag;
extern short v_font_table[];

// ===========================================================================
//		 Utility Routine
// ===========================================================================

void check_endian();
void init_msequence();
void check_endian();
void init_longchar();
void init_utils();
void init_netutils();
void init_event();
void init_resolve();
int _main(int, char**);

void cosmos_main()
{
	check_endian();
	init_task(INI_DONTWAITCHI);
	init_msequence();
	check_endian();
	init_tick();
	init_longchar();
	init_stream();
	init_utils();
	init_netutils();
	init_resolve();

	init_event();

	char *argv[2];
	argv[0] = copy_str("cosmos");
	argv[1] = copy_str("v");
	_main(2,argv);
}

void ipc_system(int argc,char ** argv);

void call_ipc_system(TKEY key)
{
	char *argv[3];
	static SEM call_ipc_lock = new_lock(0);
	argv[0] = copy_str("cosmos");
	argv[1] = copy_str("i");
	argv[2] = (char *)GET_TKEY(key);
	
	lock_task(call_ipc_lock);
	while ( !startup_flag )
		LThread::GetCurrentThread()->Sleep(100);
	printf("Open File : %s\n", argv[2]);
	LWindow *win = LWindow::FindWindowByID(128);
	LChasingArrows * ar = nil;
	if ( win ) 
		ar = dynamic_cast<LChasingArrows*>(win->FindPaneByID(ChasingArrow_IPC));
	if ( ar ) {
		ar->Show();
		ar->Enable();
	}
	ipc_system(3, argv);
	if ( ar )
		ar->Hide();
	unlock_task(call_ipc_lock, "call_ipc_system");
	d_f_ree(argv[2]);
}

void DeleteAllServerMaster();

void
DisplayAlert(char *msg)
{
	Str255 pmsg;
	if (memoryReserve) {
		::DisposeHandle(memoryReserve);
		memoryReserve = nil;
	}
	c2pstrcpy(pmsg, msg);
	::ParamText(pmsg,"\p","\p","\p");
	::StopAlert(ALRT_Msg, nil);
}

void 
exit0()
{
	exit(0);
}

void
QuitApplication()
{
extern SEM sw_lock;
	printf("QuitApplication...\n");
	if (memoryReserve) {
		::DisposeHandle(memoryReserve);
		memoryReserve = nil;
	}
	::ThreadBeginCritical();
	if (theApp->GetState() != programState_Quitting )
		theApp->SendAEQuit();
	DeleteAllServerMaster();
	LCleanupTask::CleanUpAtExit();
}

void CheckICMapEntry();
char * get_path_from_mac_fs(FSSpec, Boolean);

#ifdef PROFILE
#include	"UProfiler.h"
#endif

#ifdef MEMORY_DEBUG
	void			indicate_md();
#endif

// ===========================================================================
//		 Main Program
// ===========================================================================

int main()
{
		// Set Debugging options
	SetDebugThrow_(debugAction_Alert);
	SetDebugSignal_(debugAction_Alert);

		// Initialize Memory Manager. Parameter is the number of
		// master pointer blocks to allocate
	InitializeHeap(1);
	
		// Initialize standard Toolbox managers
	UQDGlobals::InitializeToolbox();

	UEnvironment::InitEnvironment();

		// Check for Thread Manager.
	if (UEnvironment::HasFeature(env_HasThreadManager) == false) {
		::StopAlert(ALRT_NoThreadManager, nil);
		::ExitToShell();
	}

		// Run the application.
	new UMainThread;
	LThread::GetMainThread()->SetPriority(5);
	
	atexit(QuitApplication);

	theApp = new COSMOS;
	theApp->Run();
	
		// Make sure async tasks get cleaned up. This call is VERY IMPORTANT.
	LCleanupTask::CleanUpAtExit();
	
	return 0;
}

#pragma mark -

// ---------------------------------------------------------------------------
//	 COSMOS									[public]
// ---------------------------------------------------------------------------
//	Application object constructor

COSMOS::COSMOS()
{
		// Install a GrowZone to catch low-memory situations	
	mLGrowZone = new LGrowZone(512);
	memoryReserve = ::NewHandle(2<<20);
		// Register ourselves with the Appearance Manager
	if (UEnvironment::HasFeature(env_HasAppearance)) {
		::RegisterAppearanceClient();
	}

	RegisterClasses();

		// Preload facilities for the Standard Dialogs
	PP_StandardDialogs::Load();

		// Require at least Navigation Services 1.1. See comments
		// above SetTryNavServices in UConditionalDialogs.cp for why
		// you might wish to do this.
#if PP_StdDialogs_Option == PP_StdDialogs_Conditional
	UConditionalDialogs::SetTryNavServices(0x01108000);
#endif

		// Increase responsiveness
	SetSleepTime(1);

	sCYieldRepeater = new CYieldRepeater(thTicksYield);
	AddAttachment(new LSIOUXAttachment);
	SIOUXSettings.toppixel = 500;
	SIOUXSettings.leftpixel = 50;
	SIOUXSettings.fontid = 0;
	SIOUXSettings.rows = 15;
	SIOUXSettings.userwindowtitle = "\pNATARAJA";
	
	if ( UEnvironment::IsRunningOSX() ) {
		Gestalt(gestaltPhysicalRAMSize, &free_mem_size);
		free_mem_size -= (512<<20)*(1.0-exp(-free_mem_size/float(784<<20)));
	} else {
		free_mem_size = FreeMem()-(10<<20);
	}
	printf("Free Memory %iMB\n", free_mem_size>>20);
	
	create_task(cosmos_main, 0, PRI_USER_INTERFACE);
	
}


// ---------------------------------------------------------------------------
//	 ~COSMOS								[public, virtual]
// ---------------------------------------------------------------------------
//	Application object destructor

COSMOS::~COSMOS()
{
	// Clean up after Standard Dialogs
	PP_StandardDialogs::Unload();
}


// ---------------------------------------------------------------------------
//	 StartUp										[protected, virtual]
// ---------------------------------------------------------------------------


void
COSMOS::StartUp()
{
}


// ---------------------------------------------------------------------------
//	 ObeyCommand									[public, virtual]
// ---------------------------------------------------------------------------
//	Respond to Commands. Returns true if the Command was handled, false if not.

Boolean
COSMOS::ObeyCommand(
	CommandT	inCommand,
	void*			ioParam)
{
	Boolean		cmdHandled = true;	// Assume we'll handle the command
	Str255		descriptor;
	Str255		fontname;

	switch (inCommand) {
	
	case cmd_About:
#ifdef MEMORY_DEBUG
		indicate_md();
#endif
#ifdef THREAD_DEBUG
		LThread::ThreadDebugDump();
#endif
		if ( aboutWindow ) {
			aboutWindow->Show();
			aboutWindow->Activate();
		} else {
			extern VERSION gv_ap_version;
			char v_text[256];
			c2pstrcpy(reinterpret_cast<unsigned char *>(v_text), gv_ap_version.version);
			aboutWindow = LWindow::CreateWindow(PPob_AboutWindow, this);
			dynamic_cast<LCaption*>(aboutWindow->FindPaneByID(CAPT_Version))
				->SetDescriptor(reinterpret_cast<unsigned char *>(v_text));
			c2pstrcpy(reinterpret_cast<unsigned char *>(v_text), gv_ap_version.publisher);
			dynamic_cast<LCaption*>(aboutWindow->FindPaneByID(CAPT_Publisher))
				->SetDescriptor(reinterpret_cast<unsigned char *>(v_text));
		}
		break;
	
	case cmd_Preferences:
		if ( preferencesWindow ) {
			preferencesWindow->Show();
			preferencesWindow->Activate();
		} else {
			preferencesWindow = LWindow::CreateWindow(PPob_PreferencesWindow,this);

			popupButton_JapaneseFont = dynamic_cast<LPopupButton*>(
					preferencesWindow->FindPaneByID(PopupButton_JapaneseFont));
			if ( v_font_table[VF_ID_JAPANESE] == 0 || v_font_table[VF_ID_JAPANESE] == 1 )
				popupButton_JapaneseFont->SetValue(v_font_table[VF_ID_JAPANESE]);
			else {
				GetFontName(v_font_table[VF_ID_JAPANESE],fontname);
				for ( int i = 3 ; i < popupButton_JapaneseFont->GetMaxValue() ; i++ ) {
					popupButton_JapaneseFont->GetMenuItemText(i,descriptor);
					if ( IdenticalString(descriptor,fontname,0) == 0 ) {
						popupButton_JapaneseFont->SetValue(i);
						break;
					}
				}
			}
			popupButton_JapaneseFont->SetValueMessage(cmd_SetJapaneseFont);
			popupButton_JapaneseFont->AddListener(this);

			popupButton_RomanFont = dynamic_cast<LPopupButton*>(
					preferencesWindow->FindPaneByID(PopupButton_RomanFont));
			if ( v_font_table[VF_ID_ROMAN] == 0 || v_font_table[VF_ID_ROMAN] == 1 )
				popupButton_JapaneseFont->SetValue(v_font_table[VF_ID_ROMAN]);
			else {
				GetFontName(v_font_table[VF_ID_ROMAN],fontname);
				for ( int i = 3 ; i < popupButton_RomanFont->GetMaxValue() ; i++ ) {
					popupButton_RomanFont->GetMenuItemText(i,descriptor);
					if ( IdenticalString(descriptor,fontname,0) == 0 ) {
						popupButton_RomanFont->SetValue(i);
						break;
					}
				}
			}
			popupButton_RomanFont->SetValueMessage(cmd_SetRomanFont);
			popupButton_RomanFont->AddListener(this);
		}
		break;
	
	default:
		cmdHandled = LDocApplication::ObeyCommand(inCommand, ioParam);
		break;
	}
	
	return cmdHandled;
}


// ---------------------------------------------------------------------------
//	 FindCommandStatus								[public, virtual]
// ---------------------------------------------------------------------------
//	Determine the status of a Command for the purposes of menu updating.

void
COSMOS::FindCommandStatus(
	CommandT	inCommand,
	Boolean&	outEnabled,
	Boolean&	outUsesMark,
	UInt16&		outMark,
	Str255		outName)
{
	switch (inCommand) {

	case cmd_New:
		outEnabled = false;
		break;

	case cmd_Close:
	case cmd_Preferences:
		outEnabled = true;
		break;

	default:
		LDocApplication::FindCommandStatus(inCommand, outEnabled,
										outUsesMark, outMark, outName);
		break;
	}
}


// ---------------------------------------------------------------------------
//	 RegisterClasses								[protected, virtual]
// ---------------------------------------------------------------------------
//	To reduce clutter within the Application object's constructor, class
//	registrations appear here in this seperate function for ease of use.

void
COSMOS::RegisterClasses()
{
	RegisterClass_(LWindow);

	RegisterClass_(LCaption);
	RegisterClass_(LPicture);

	RegisterClass_(LPlacard);
	RegisterClassID_(LAMControlImp,	LPlacard::imp_class_ID);

	RegisterClass_(LPopupButton);
	RegisterClassID_(LAMPopupButtonImp,		 LPopupButton::imp_class_ID);

	RegisterClass_(LTextGroupBox);
	RegisterClassID_(LAMTextGroupBoxImp,	 LTextGroupBox::imp_class_ID);

	RegisterClass_(LChasingArrows);
	RegisterClassID_(LAMControlImp, LChasingArrows::imp_class_ID);

#ifndef NDEBUG
	RegisterClass_(LTextEditView);	// for Debug Log Window
#endif

	RegisterClass_(CLEMWindow);

		
//	UControlRegistry::RegisterClasses();
}



// ---------------------------------------------------------------------------
//	 OpenDocument								  [public]
// ---------------------------------------------------------------------------
//	Open a Document specified by an FSSpec

void
COSMOS::OpenDocument(
	FSSpec*	inMacFSSpec)
{
	char * path = get_path_from_mac_fs(*inMacFSSpec,false);
	create_task((void(*)())call_ipc_system, (int)path, PRI_IPC_TASK);
}

// ---------------------------------------------------------------------------
//	 ChooseDocument								[protected, virtual]
// ---------------------------------------------------------------------------
void
COSMOS::ChooseDocument()
{
	PP_StandardDialogs::LFileChooser	chooser;
	
		// Open any/all TEXT files
	
	NavDialogOptions*	options = chooser.GetDialogOptions();
	if (options != nil) {
		options->dialogOptionFlags =	kNavDefaultNavDlogOptions
										+ kNavSelectAllReadableItem;
	}

	if (chooser.AskOpenFile(LFileTypeList(ResType_Text))) {
		AEDescList		docList;
		chooser.GetFileDescList(docList);
		SendAEOpenDocList(docList);
	}
}


// ---------------------------------------------------------------------------
//	 ListenToMessage								[virtual]
// ---------------------------------------------------------------------------
void
COSMOS::ListenToMessage(MessageT inMessage, void* ioParam)
{
	Str255 descriptor;

	switch(inMessage) {
	
	case msg_GrowZone :
		if ( memoryReserve ) {
			::DisposeHandle(memoryReserve);
			memoryReserve = nil;
		}
		if (::GetResource(FOUR_CHAR_CODE('ALRT'), ALRT_LowMemory) != nil) {
			::StopAlert(ALRT_LowMemory, nil);
		}
		exit(0);
		break;
	
	case cmd_SetJapaneseFont :
		if ( *(int*)ioParam == 0 || *(int*)ioParam == 1 )
			v_font_table[VF_ID_JAPANESE] = *(int*)ioParam;
		else {
			popupButton_JapaneseFont->GetMenuItemText(*(int*)ioParam,descriptor);
			GetFNum(descriptor, &v_font_table[VF_ID_JAPANESE]);
		}
		break;

	case cmd_SetRomanFont :
		if ( *(int*)ioParam == 0 || *(int*)ioParam == 1 )
			v_font_table[VF_ID_ROMAN] = *(int*)ioParam;
		else {
			popupButton_RomanFont->GetMenuItemText(*(int*)ioParam,descriptor);
			GetFNum(descriptor, &v_font_table[VF_ID_ROMAN]);
		}
		break;
	
	}
}

// ---------------------------------------------------------------------------
//	 AllowSubRemoval
// ---------------------------------------------------------------------------

Boolean
COSMOS::AllowSubRemoval(LCommander*	 inSub)
{
	if ( inSub == aboutWindow ) {
		aboutWindow->Hide();
		return false;
	}
	if ( inSub == preferencesWindow ) {
		preferencesWindow->Hide();
		return false;
	}
	
	return true;
}


} // extern "C"