/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_TYPES_H___
#define ___V_TYPES_H___

#define NeedFunctionPrototypes 1

#ifdef __cplusplus
typedef class CLEMWindow *	Window;
typedef class LGWorld *		Image;
#else
typedef void * Window;
typedef void * Image;
#endif

#include	"machine/msequence.h"

//--------------------------------------------------------------------------
#pragma mark	VOBJECT
//--------------------------------------------------------------------------

typedef struct vobj_header {
	int			type;
	union vobject *		next;
	struct vwindow *	win;
	void			(*handler)(/* obj, cmd, ...*/);
	/* cmd */
#define VE_REDRAW	1
#define VE_BUTTON		2
#define VE_MAX		3

#define VES_BUTTON_PRESS		1
#define VES_BUTTON_RELEASE	2
#define VES_BUTTON_MOTION		3
} VOBJ_HEADER;

typedef struct vimage {
	VOBJ_HEADER		_h;
	char *			buf_8;
	short *			buf_16;
	long *			buf_32;
	int				x;
	int				y;
	int				w;
	int				h;
	int				w_border;

	int				select_flag;
		/* 1 --> select */
		/* 0 --> not select */
	VPOINT			select[2];
	
	Image			image;
} VIMAGE;

typedef struct vtext {
	VOBJ_HEADER		_h;
	int			mode;
#define VT_TRANS		1
#define VT_BACKGROUND		2
 	int			size;
 	int			dir;
	int			st_x;
	int			st_y;
	L_CHAR *		data;
	int			length;
	unsigned long		color;
	unsigned long		background;
	VRECT			minrect;
} VTEXT;

typedef union vobject {
	VOBJ_HEADER	header;
#define VT_IMAGE	1
#define VT_TEXT	2
	VIMAGE		vimage;
	VTEXT		vtext;
} VOBJECT;


//--------------------------------------------------------------------------
#pragma mark	VDISPLAY
//--------------------------------------------------------------------------

typedef struct v_map_tbl {
/*	unsigned int *		map[3];
#define GB2M_R	0
#define GB2M_G	1
#define GB2M_B	2
*/
	int			pixel_bits;

	char			red_shift;
	char			green_shift;
	char			blue_shift;
	char			color_bit;
	unsigned long		red_mask;
	unsigned long		green_mask;
	unsigned long		blue_mask;
} V_MAP_TBL;

typedef struct vfont {
	char *		fontname;
	short			id;
#define VF_ID_ROMAN	0
#define VF_ID_JAPANESE	1
} VFONT;

typedef struct vdisplay {
	/* machine indipendent members */

	int			(*err_handler)();
	struct vwindow *	win_list;
	void			(*handler[VE_MAX])();
	WCT *			wct;

	/* machine dipendent members */

	struct vdisplay *	next;
	V_MAP_TBL		gb2m_map;

	VFONT			jisx0201;
	VFONT			jisx0208_1978;
	VFONT			jisx0208_1983;
	VFONT			jisx0208_1990;
	VFONT			jisx0212_1990;
	VFONT			iso8859_1;
	VFONT			iso8859_2;
	VFONT			iso8859_3;
	VFONT			iso8859_4;
	VFONT			iso8859_5;
	VFONT			iso8859_6;
	VFONT			iso8859_7;
	VFONT			iso8859_8;
	VFONT			iso8859_9;
	VFONT			iso8859_10;
	VFONT			iso8859_11;
	VFONT			iso8859_12;
	VFONT			iso8859_13;
	VFONT			iso8859_14;
	VFONT			iso8859_15;
	WCT *			font_work;
	int			font_flag;
	int			depth;
} VDISPLAY;

#define GB2MCOLOR(tbl,f)							\
		(((((unsigned long)(f))&COL_MASK)				\
			>>(COL_BIT-(tbl).color_bit)					\
			<<(tbl).red_shift)&(tbl).red_mask) |			\
		((((((unsigned long)(f))>>COL_BIT)&COL_MASK)		\
			>>(COL_BIT-(tbl).color_bit)					\
			<<(tbl).green_shift)&(tbl).green_mask) |		\
		((((((unsigned long)(f))>>COL_BIT*2)&COL_MASK)	\
			>>(COL_BIT-(tbl).color_bit)					\
			<<(tbl).blue_shift)&(tbl).blue_mask)

#define GB2MCOLOR_D(d,f)	GB2MCOLOR(d->gb2m_map,f)

#define MCOLOR2GB(r,g,b,tbl,f)					\
	{										\
		(r) = ((((unsigned long)(f))&(tbl).red_mask)		\
			>>(tbl).red_shift)						\
			<<(COL_BIT-(tbl).color_bit);				\
		(g) = ((((unsigned long)(f))&(tbl).green_mask)	\
			>>(tbl).green_shift)					\
			<<(COL_BIT-(tbl).color_bit);				\
		(b) = ((((unsigned long)(f))&(tbl).blue_mask)		\
			>>(tbl).blue_shift)					\
			<<(COL_BIT-(tbl).color_bit);				\
	}

#define GB2RGB_M(f,n)	\
	(((f)>>COL_BIT*(n))&COL_MASK)<<(16-COL_BIT)

#define GB2RGB(f,rgb)	\
	{							\
	(rgb).red		= GB2RGB_M(f,0);	\
	(rgb).green	= GB2RGB_M(f,1);	\
	(rgb).blue		= GB2RGB_M(f,2);	\
	}

extern RGBColor RGB_black, RGB_white;

//--------------------------------------------------------------------------
#pragma mark	VWINDOW
//--------------------------------------------------------------------------

typedef struct vwindow {
	struct vwindow *	next;
	VOBJECT *		obj_list;

	VDISPLAY *		d;
	Window			w;
} VWINDOW;

typedef struct vwindow_attributes {
	int			x;
	int			y;
	int			w;
	int			h;
} VWINDOW_ATTRIBUTES;

VWINDOW * _get_vwin(VDISPLAY *,Window);

//#define CB_MACHINE_ORDER	CB_MSB_FIRST

#endif
