/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



extern "C" {
#include	"machine/include.h"
#include	"memory_debug.h"
#include	"gif_rgb.h"
#include	"utils.h"
#include	"task.h"
#include	"win_flame.h"
#include	"lock_level.h"
}

#include	"v/v.h"
#include 	"v/VgbWPMenuEdit.h"
#include	"v/VgbQueryIndicate.h"
#include "v/VTableView.h"



void
VgbWPMenuEdit::_delete_space(L_CHAR * a)
{
L_CHAR * p;
int q;
	for ( p = a ; *p && *p == ' ' ; p ++ );
	if ( p == a )
		goto next1;
	memcpy(a,p,(l_strlen(p)+1)*sizeof(L_CHAR));
next1:
	for ( q = l_strlen(a)-1 ; q >= 0 && a[q] == ' ' ; q -- );
	if ( q < 0 ) {
		a[0] = 0;
		return;
	}
	q ++;
	a[q] = 0;
}

void 
VgbWPMenuEdit::copy_wpmedit_status(
	VgbWPMenuEditStatus * dest,
	VgbWPMenuEditStatus * src,
	int * flags)
{
	if ( (*flags) & VSF_GB_WPE_MENU ) {
		dest->menu = copy_wpm(src->menu);
		(*flags) &= ~VSF_GB_WPE_MENU;
	}
	if (  (*flags) & VSF_GB_WPE_NEW_BUTTON_DESC ) {
		dest->new_button_descriptor = ll_copy_str(src->new_button_descriptor);
		(*flags) &= ~VSF_GB_WPE_NEW_BUTTON_DESC;
	}
	if (  (*flags) & VSF_GB_WPE_DEL_BUTTON_DESC ) {
		dest->del_button_descriptor = ll_copy_str(src->del_button_descriptor);
		(*flags) &= ~VSF_GB_WPE_DEL_BUTTON_DESC;
	}
	if (  (*flags) & VSF_GB_WPE_EDIT_BUTTON_DESC ) {
		dest->edit_button_descriptor = ll_copy_str(src->edit_button_descriptor);
		(*flags) &= ~VSF_GB_WPE_EDIT_BUTTON_DESC;
	}
	if (  (*flags) & VSF_GB_WPE_UNTITLED ) {
		dest->untitled = ll_copy_str(src->untitled);
		(*flags) &= ~VSF_GB_WPE_UNTITLED;
	}
	if (  (*flags) & VSF_GB_WPE_DETAILS ) {
		dest->details = ll_copy_str(src->details);
		(*flags) &= ~VSF_GB_WPE_DETAILS;
	}
	if (  (*flags) & VSF_GB_WPE_CLOSE ) {
		dest->close = ll_copy_str(src->close);
		(*flags) &= ~VSF_GB_WPE_CLOSE;
	}
	if (  (*flags) & VSF_GB_WPE_WP_CONFIGURE ) {
		dest->wp_configure = ll_copy_str(src->wp_configure);
		(*flags) &= ~VSF_GB_WPE_WP_CONFIGURE;
	}
	if (  (*flags) & VSF_GB_WPE_LOADING_TARGET ) {
		dest->loading_target = ll_copy_str(src->loading_target);
		if ( dest->loading_target[0] == 0 ) {
			d_f_ree(dest->loading_target);
			dest->loading_target = 0;
		}
		(*flags) &= ~VSF_GB_WPE_LOADING_TARGET;
	}

	if (  (*flags) & VSF_GB_WPE_INFO_ITEM ) {
		dest->info_item = ll_copy_str(src->info_item);
		(*flags) &= ~VSF_GB_WPE_INFO_ITEM;
	}



	if (  (*flags) & VSF_GB_WPE_INFO_CONTENT ) {
		dest->info_content = ll_copy_str(src->info_content);
		(*flags) &= ~VSF_GB_WPE_INFO_CONTENT;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_MENU_TITLE ) {
		dest->info_menu_title = ll_copy_str(src->info_menu_title);
		(*flags) &= ~VSF_GB_WPE_INFO_MENU_TITLE;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_MENU_LINK ) {
		dest->info_menu_link = ll_copy_str(src->info_menu_link);
		(*flags) &= ~VSF_GB_WPE_INFO_MENU_LINK;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_TYPE ) {
		dest->info_type = ll_copy_str(src->info_type);
		(*flags) &= ~VSF_GB_WPE_INFO_TYPE;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_TITLE ) {
		dest->info_title = ll_copy_str(src->info_title);
		(*flags) &= ~VSF_GB_WPE_INFO_TITLE;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_TRACKING ) {
		dest->info_tracking = ll_copy_str(src->info_tracking);
		(*flags) &= ~VSF_GB_WPE_INFO_TRACKING;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_RESOLUTION ) {
		dest->info_resolution = ll_copy_str(src->info_resolution);
		(*flags) &= ~VSF_GB_WPE_INFO_RESOLUTION;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_ROTATE ) {
		dest->info_rotate = ll_copy_str(src->info_rotate);
		(*flags) &= ~VSF_GB_WPE_INFO_ROTATE;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_CENTER_X ) {
		dest->info_center_x = ll_copy_str(src->info_center_x);
		(*flags) &= ~VSF_GB_WPE_INFO_CENTER_X;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_CENTER_Y ) {
		dest->info_center_y = ll_copy_str(src->info_center_y);
		(*flags) &= ~VSF_GB_WPE_INFO_CENTER_Y;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_BASE ) {
		dest->info_base = ll_copy_str(src->info_base);
		(*flags) &= ~VSF_GB_WPE_INFO_BASE;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_LOCK_BASE ) {
		dest->info_lock_base = ll_copy_str(src->info_lock_base);
		(*flags) &= ~VSF_GB_WPE_INFO_LOCK_BASE;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_LAYER_ENTRY ) {
		dest->info_layer_entry = ll_copy_str(src->info_layer_entry);
		(*flags) &= ~VSF_GB_WPE_INFO_LAYER_ENTRY;
	}
	if (  (*flags) & VSF_GB_WPE_INFO_LAYER_FLAGS ) {
		dest->info_layer_flags = ll_copy_str(src->info_layer_flags);
		(*flags) &= ~VSF_GB_WPE_INFO_LAYER_FLAGS;
	}
	if (  (*flags) & VSF_GB_WPE_LOAD_MENU_LINK ) {
		dest->load_menu_link = ll_copy_str(src->load_menu_link);
		(*flags) &= ~VSF_GB_WPE_LOAD_MENU_LINK;
	}
	if (  (*flags) & VSF_GB_WPE_UNLOAD_MENU_LINK ) {
		dest->unload_menu_link = ll_copy_str(src->unload_menu_link);
		(*flags) &= ~VSF_GB_WPE_UNLOAD_MENU_LINK;
	}
	if (  (*flags) & VSF_GB_WPE_OPEN_IN_IND_WINDOW ) {
		dest->open_in_ind_window = ll_copy_str(src->open_in_ind_window);
		(*flags) &= ~VSF_GB_WPE_OPEN_IN_IND_WINDOW;
	}
	if (  (*flags) & VSF_GB_WPE_OPEN_FUNC ) {
		dest->open_func = ll_copy_str(src->open_func);
		(*flags) &= ~VSF_GB_WPE_OPEN_FUNC;
	}
	
	if (  (*flags) & VSF_GB_WPE_WP_IMG ) {
		dest->wp_img = src->wp_img;
		v_image_ref(dest->wp_img);
		(*flags) &= ~VSF_GB_WPE_WP_IMG;
	}
	if (  (*flags) & VSF_GB_WPE_WPGROUP_IMG ) {
		dest->wpgroup_img = src->wpgroup_img;
		v_image_ref(dest->wpgroup_img);
		(*flags) &= ~VSF_GB_WPE_WPGROUP_IMG;
	}
}
void 
VgbWPMenuEdit::free_wpmedit_status(
	VgbWPMenuEditStatus * dest)
{
	free_wpm(dest->menu);
	if ( dest->new_button_descriptor )
		d_f_ree(dest->new_button_descriptor);
	if ( dest->del_button_descriptor )
		d_f_ree(dest->del_button_descriptor);
	if ( dest->edit_button_descriptor )
		d_f_ree(dest->edit_button_descriptor);
	if ( dest->untitled )
		d_f_ree(dest->untitled);
	if ( dest->details )
		d_f_ree(dest->details);
	if ( dest->close )
		d_f_ree(dest->close);
	if ( dest->loading_target )
		d_f_ree(dest->loading_target);
	if ( dest->info_item )
		d_f_ree(dest->info_item);
	if ( dest->info_content )
		d_f_ree(dest->info_content);
	if ( dest->info_menu_title )
		d_f_ree(dest->info_menu_title);
	if ( dest->info_menu_link )
		d_f_ree(dest->info_menu_link);
	if ( dest->info_type )
		d_f_ree(dest->info_type);
	if ( dest->info_title )
		d_f_ree(dest->info_title);
	if ( dest->info_tracking )
		d_f_ree(dest->info_tracking);
	if ( dest->info_resolution )
		d_f_ree(dest->info_resolution);
	if ( dest->info_rotate )
		d_f_ree(dest->info_rotate);
	if ( dest->info_center_x )
		d_f_ree(dest->info_center_x);
	if ( dest->info_center_y )
		d_f_ree(dest->info_center_y);
	if ( dest->info_base )
		d_f_ree(dest->info_base);
	if ( dest->info_lock_base )
		d_f_ree(dest->info_lock_base);
	if ( dest->info_layer_entry )
		d_f_ree(dest->info_layer_entry);
	if ( dest->info_layer_flags )
		d_f_ree(dest->info_layer_flags);
	if ( dest->wp_img )
		v_image_unref(dest->wp_img);
	if ( dest->wpgroup_img )
		v_image_unref(dest->wpgroup_img);
	if ( dest->load_menu_link )
		d_f_ree(dest->load_menu_link);
	if ( dest->unload_menu_link )
		d_f_ree(dest->unload_menu_link);
	if ( dest->open_in_ind_window )
		d_f_ree(dest->open_in_ind_window);
	if ( dest->wp_configure )
		d_f_ree(dest->wp_configure);
	if ( dest->open_func )
		d_f_ree(dest->open_func);
}

typedef struct min_size_t {
	VObject *		sp;
	VObject *		qi;
	VObject *		xltv;
	VObject *		macro;
	VSize			size;
} MIN_SIZE_T;


void
VgbWPMenuEdit::_set_tv_node_info(VTreeView * tv,int key,L_CHAR * data1,bool editable)
{
VTreeNode * node1, * node2;
L_CHAR null_ch = 0;
L_CHAR edit_ch[2] = {'*',0};
L_CHAR null_ch_2[2] = {' ',0};

	node1 = tv->get_row((void*)key);
	node2 = new VTreeNode(tv->get_n_cols());
	node2->key = (void*)(unsigned int)key;
	node2->dirty = 0;

	node2->editable = editable;

	node2->data[0] = node1->data[0];

	if ( editable )
		node2->data[1] = &edit_ch[0];
	else	node2->data[1] = &null_ch;
	if ( data1 ) {
		node2->data[2] = data1;
	}
	else {
		if ( node1 )
			node2->data[2] = node1->data[2];
		else	node2->data[2] = 0;
	}
	if ( node2->data[2] == 0 || *(L_CHAR*)node2->data[2] == 0 ) {
		node2->data[2] = &null_ch_2[0];
	}
	if ( node1 == 0 )
		tv->add_row(node2);
	else	tv->set_row(node2);
	delete node2;
}

void
VgbWPMenuEdit::_set_tv_node_layers(VTreeView * tv,int key,int data0,L_CHAR * data1,bool editable)
{
VTreeNode * node1, * node2;
L_CHAR null_ch = 0;
	node1 = tv->get_row((void*)key);
	node2 = new VTreeNode(tv->get_n_cols());
	node2->key = (void*)(unsigned int)key;
	node2->dirty = 0;

	node2->editable = editable;

	switch ( data0 ) {
	case 0:
		node2->data[0] = VTF_FALSE;
		break;
	case 1:
		node2->data[0] = VTF_TRUE;
		break;
	default:
		if ( node1 )
			node2->data[0] = node1->data[0];
		else	node2->data[0] = VTF_FALSE;
	}
	if ( data1 ) {
		node2->data[1] = data1;
	}
	else {
		if ( node1 )
			node2->data[1] = node1->data[1];
		else	node2->data[1] = &null_ch;
	}
	if ( node1 == 0 )
		tv->add_row(node2);
	else	tv->set_row(node2);
	delete node2;
}

int
VgbWPMenuEdit::_check_edit_wpm_text(L_CHAR ** tp,int key)
{
VTreeNode * n;
	n = wpm_w.meta_data_obj->get_row((void*)key);
	if ( n && n->dirty ) {
		if ( *tp )
			d_f_ree(*tp);
		*tp = ll_copy_str((L_CHAR*)n->data[POS_GB_WPE_INFO_CONTENT]);
		_delete_space(*tp);
		if ( (*tp)[0] == 0 ) {
			d_f_ree(*tp);
			*tp = 0;
		}
		_set_dirty_flag();
		return 1;
	}
	return 0;
}

int
VgbWPMenuEdit::_check_edit_wpm_floating(REAL1 * tp,int key)
{
VTreeNode * n;
L_CHAR * str;
	n = wpm_w.meta_data_obj->get_row((void*)key);
	if ( n && n->dirty ) {
		str = (L_CHAR*)n->data[POS_GB_WPE_INFO_CONTENT];
/*
		_ret = code_convert_with_combine(str,l_strlen(str),
				sjis_cm.main_code,CBF_SRC_PLANE|CBF_DST_PLANE);
*/
		sscanf(n_string(&sjis_cm,str),"%f",tp);
		_set_dirty_flag();
		return 1;
	}
	return 0;
}

int
VgbWPMenuEdit::_check_edit_wpm_layer(WARP_POINT_LAYER * lr,int key)
{
VTreeNode * n;
	n = wpm_w.layers_data_obj->get_row((void*)key);
	if ( n && n->dirty ) {
		if  ( n->data[POS_GB_WPE_INFO_LAYER_FLAGS] == VTF_FALSE )
			lr->flags |= WFF_HIDE;
		else
			lr->flags &= ~WFF_HIDE;
		_set_dirty_flag();
		return 1;
	}
	return 0;
}

void
VgbWPMenuEdit::_check_edit_wpm()
{
WARP_POINT_MENU * m;
WARP_POINT * wp;
WARP_POINT_MENU_EXT * e;
WARP_POINT_LAYER * lr;
int i;
VgbQueryIndicateStatus _sts;
VObjectStatus v_sts;
	if ( wpm_w.edit_wpm_detail == 0 )
		return;
	e = wpm_w.edit_wpm_detail;
	m = e->wpm;
	if ( m == 0 )
		return;
	if ( m->submenu_type ) {
		if ( _check_edit_wpm_text(&m->path,POS_GB_WPE_INFO_MENU_LINK) ) {
			if ( m->path == 0 )
				m->submenu_type = WPM_ST_NORMAL;
			else if ( memcmp(m->path,l_string(std_cm,"file:///"),sizeof(L_CHAR)*8) == 0 )
				m->submenu_type = WPM_ST_FILE;
			else if ( l_strcmp(m->path,l_string(std_cm," ")) == 0 ||
					l_strcmp(m->path,l_string(std_cm,"")) == 0 )  {
				m->submenu_type = WPM_ST_NORMAL;
				d_f_ree(m->path);
				m->path = 0;
			}
			else	m->submenu_type = WPM_ST_NET;
			if ( m->submenu_type == WPM_ST_NORMAL || m->submenu_type == WPM_ST_NONE ) {
				v_sts.visible = 0;
				e->submenu->submenu_ctl[SC_VISIBLE]->set_status(&v_sts,VSF_VISIBLE);
			}
			else {
				v_sts.visible = 1;
				if ( e->submenu == 0 || e->submenu->next == 0 ) {
					v_sts.descriptor = wpm_w.sts.load_menu_link;
					v_sts.value_event_handler = _load_button;
					v_sts.value_eh_arg = (void*)this;
				}
				else {
					v_sts.descriptor = wpm_w.sts.unload_menu_link;
					v_sts.value_event_handler = _unload_button;
					v_sts.value_eh_arg = (void*)this;
				}
				e->submenu->submenu_ctl[SC_VISIBLE]->set_status(&v_sts,VSF_VISIBLE);
				e->submenu->submenu_ctl[SC_LOAD]->set_status(&v_sts,VSF_DESC|VSF_VALUE_EH);
			}
		}
		return;
	}
	wp = m->wp;
	if ( wp == 0 )
		return;
	_check_edit_wpm_text(&wp->title,POS_GB_WPE_INFO_TITLE);
	_check_edit_wpm_floating(&wp->resolution,POS_GB_WPE_INFO_RESOLUTION);
	_check_edit_wpm_floating(&wp->rotate,POS_GB_WPE_INFO_ROTATE);
	_check_edit_wpm_floating(&wp->center.x,POS_GB_WPE_INFO_CENTER_X);
	_check_edit_wpm_floating(&wp->center.y,POS_GB_WPE_INFO_CENTER_Y);
	if ( _check_edit_wpm_text(&wp->lock_base,POS_GB_WPE_INFO_LOCK_BASE) ) {
		for ( lr = wp->layers ; lr ; lr = lr->next ) {
			if ( wp->lock_base && l_strcmp(lr->entry,wp->lock_base) == 0 ) {
				lr->flags |= WFF_BASE_LOCK;
			}
			else {
				lr->flags &= ~WFF_BASE_LOCK;
			}
		}
	}

	for ( i = 1, lr = wp->layers ; lr ; lr = lr->next , i ++ ) {
		_check_edit_wpm_layer(lr,i);
	}
	
	memset(&_sts,0,sizeof(_sts));
	wpm_w.qi_obj->get_queryindicate_status(&_sts,VSF_QINDICATE_QTH_GET|VSF_QINDICATE_DIRTY_BIT);
	if ( _sts.dirty ) {
		free_query_thread(wp->qth);
		wp->qth = _sts.qth_get;
		_set_dirty_flag();
	}
}

void
VgbWPMenuEdit::_set_tv_wpm(WARP_POINT_MENU_EXT * e)
{
WARP_POINT_MENU * m;
WARP_POINT * wp;
char buffer[50];
char *p;
int f;
int i;
L_CHAR null_ch = 0;
L_CHAR null_ch_2[2] = {' ',0};
int nos;
WARP_POINT_LAYER * lr;
char *q;
VgbQueryIndicateStatus qsts;

	_check_edit_wpm();
	wpm_w.edit_wpm_detail = e;
	if ( e == 0 || e->wpm == 0 ) {
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_MENU_TITLE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_MENU_LINK,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TYPE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TITLE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TRACKING,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_RESOLUTION,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_ROTATE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_CENTER_X,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_CENTER_Y,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_BASE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_LOCK_BASE,&null_ch,0);
		
		for ( i = 1 ; i <= wpm_w.layer_rows ; i ++ )
			wpm_w.layers_data_obj->remove_row((void*)(unsigned int)i);
		wpm_w.layer_rows = 0;
		
		memset(&qsts,0,sizeof(qsts));
		wpm_w.qi_obj->set_queryindicate_status(&qsts,
			VSF_QINDICATE_QTH_REPLACE|VSF_QINDICATE_DIRTY_BIT);
	}
	else if ( e->wpm->submenu_type ) {
		m = e->wpm;
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_MENU_TITLE,m->name,0);
		if ( m->path ) 
			_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_MENU_LINK,m->path,1);
		else	_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_MENU_LINK,&null_ch_2[0],1);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TYPE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TITLE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TRACKING,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_RESOLUTION,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_ROTATE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_CENTER_X,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_CENTER_Y,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_BASE,&null_ch,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_LOCK_BASE,&null_ch,0);
		
		for ( i = 1 ; i <= wpm_w.layer_rows ; i ++ )
			wpm_w.layers_data_obj->remove_row((void*)(unsigned int)i);
		wpm_w.layer_rows = 0;
		
		memset(&qsts,0,sizeof(qsts));
		wpm_w.qi_obj->set_queryindicate_status(&qsts,
			VSF_QINDICATE_QTH_REPLACE|VSF_QINDICATE_DIRTY_BIT);
	}
	else {
		m = e->wpm;
		wp = m->wp;
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_MENU_TITLE,m->name,0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_MENU_LINK,&null_ch,0);
		p = &buffer[0];
		f = 0;
		if ( wp->type & WPT_SIMPLE ) {
			strcpy(p,"SIMPLE");
			p += strlen(p);
			f = 1;
		}
		if ( wp->type & WPT_CRD ) {
			if ( f )
				*p++ = ' ';
			strcpy(p,"CRD");
			p += strlen(p);
			f = 1;
		}
		if ( wp->type & WPT_ONLY_ACTIVE ) {
			if ( f )
				*p++ =  ' ';
			strcpy(p,"ONLY-ACTIVE");
			p += strlen(p);
		}
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TYPE,l_string(std_cm,buffer),0);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TITLE,wp->title,1);
		p = get_xltime_str(wp->tracking_time,TFMT_UNIX);
		for ( q = p ; *q ; q ++ )
			if ( *q < ' ' )
				*q = ' ';
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_TRACKING,l_string(std_cm,p),0);
		d_f_ree(p);
		sprintf(buffer,"%f",wp->resolution);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_RESOLUTION,l_string(std_cm,buffer),1);
		sprintf(buffer,"%f",wp->rotate);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_ROTATE,l_string(std_cm,buffer),1);
		sprintf(buffer,"%f",wp->center.x);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_CENTER_X,l_string(std_cm,buffer),1);
		sprintf(buffer,"%f",wp->center.y);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_CENTER_Y,l_string(std_cm,buffer),1);
		_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_BASE,wp->base,0);
		if ( wp->lock_base )
			_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_LOCK_BASE,wp->lock_base,1);
		else
			_set_tv_node_info(wpm_w.meta_data_obj,POS_GB_WPE_INFO_LOCK_BASE,0,1);

		lr = wp->layers;
		for ( i = 1 ; lr ; i ++ , lr = lr->next ) {
			if ( lr->flags & WFF_HIDE )
				_set_tv_node_layers(wpm_w.layers_data_obj,i,0,lr->entry,1);
			else	_set_tv_node_layers(wpm_w.layers_data_obj,i,1,lr->entry,1);
		}
		nos = i-1;
		for ( ; i <= wpm_w.layer_rows ; i ++ )
			wpm_w.layers_data_obj->remove_row((void*)(unsigned int)i);
		wpm_w.layer_rows = nos;

		memset(&qsts,0,sizeof(qsts));
		qsts.qth_replace = wp->qth;
		wpm_w.qi_obj->set_queryindicate_status(&qsts,
			VSF_QINDICATE_QTH_REPLACE|VSF_QINDICATE_DIRTY_BIT);
	}
}

void
VgbWPMenuEdit::_make_tv_node_info(VTreeView * tv,int key,L_CHAR * item,bool editable)
{
VTreeNode * node;
L_CHAR null_ch = 0;
L_CHAR edit_ch[2] = {'*',0};

	node = new VTreeNode(tv->get_n_cols());
	node->key = (void*)(unsigned int)key;
	if ( item ) {
		node->editable = editable;
		node->data[0] = item;
	}
	else {
		node->editable = 0;
		node->data[0] = &null_ch;
	}
	if ( editable ) {
		node->data[1] = &edit_ch;
	}
	else	node->data[1] = &null_ch;
	node->data[2] = &null_ch;
	tv->add_row(node,0,0);
	delete node;
}

void
VgbWPMenuEdit::_make_value_tree_view(VObjectStatus * s,int flags)
{
char types[POS_GB_WPE_COLS];
const L_CHAR * titles[POS_GB_WPE_COLS];
short widths[POS_GB_WPE_COLS];
	
VTreeView::tree_set set;
VObject * vav;
VExError err;
VTreeView * tv;
VSize tmp_size;
L_CHAR nil_ch = 0;

	tmp_size = s->min_size;
	vav = s->parent;

	s->alignh = VALIGN_TOP;
	s->alignv = VALIGN_LEFT;
	s->min_size.h = 300;

	types[0] = VTT_TEXT;
	types[1] = VTT_TEXT;
	types[2] = VTT_TEXT|VTT_EDITABLE;
	
	titles[0] = wpm_w.sts.info_item;
	titles[1] = &nil_ch;
	titles[2] = wpm_w.sts.info_content;
	
	widths[0] = 200;
	widths[1] = 40;
	widths[2] = 500;
	set.cols = POS_GB_WPE_INFO_COLS;
	set.types = types;
	set.title = titles;
	set.widths = widths;
	s->attr = VTreeView::select_single;
	
	wpm_w.meta_data_obj = tv = VTreeView::create(
		s,
		flags|VSF_PARENT|VSF_SPACING|VSF_PADDING|VSF_MIN_SIZE|VSF_ATTR|VSF_MIN_SIZE,
		&set,&err);

	_make_tv_node_info(tv,POS_GB_WPE_SPACE_1,0,0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_MENU_TITLE,	wpm_w.sts.info_menu_title,	0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_MENU_LINK,	wpm_w.sts.info_menu_link,	0);
	_make_tv_node_info(tv,POS_GB_WPE_SPACE_2,0,0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_TYPE,		wpm_w.sts.info_type,		0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_TITLE,		wpm_w.sts.info_title,		0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_TRACKING,	wpm_w.sts.info_tracking,	0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_RESOLUTION,	wpm_w.sts.info_resolution,	0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_ROTATE,	wpm_w.sts.info_rotate,		0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_CENTER_X,	wpm_w.sts.info_center_x,	0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_CENTER_Y,	wpm_w.sts.info_center_y,	0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_BASE,		wpm_w.sts.info_base,		0);
	_make_tv_node_info(tv,POS_GB_WPE_INFO_LOCK_BASE,	wpm_w.sts.info_lock_base,	0);


	s->parent = vav;
	s->alignh = VALIGN_TOP;
	s->alignv = VALIGN_LEFT;
	s->min_size.h = 400;
	s->size = s->min_size;


	types[1] = VTT_TEXT;
	types[0] = VTT_BOOL|VTT_EDITABLE;
	
	titles[1] = wpm_w.sts.info_layer_entry;
	titles[0] = wpm_w.sts.info_layer_flags;
	
	widths[0] = 50;
	widths[1] = 650;
	
	set.cols = POS_GB_WPE_INFO_LAYERS_COLS;
	set.types = types;
	set.title = titles;
	set.widths = widths;
	s->attr = VTreeView::select_single|VTreeView::scrollbar_v;
	
	wpm_w.layers_data_obj = VTreeView::create(
		s,
		flags|VSF_PARENT|VSF_SPACING|VSF_PADDING|VSF_MIN_SIZE|VSF_ATTR|VSF_SIZE,
		&set,&err);

	s->min_size = tmp_size;
}

VExError
VgbWPMenuEdit::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
VExError err;
//VObjectStatus _sts;

VgbWPMenuEditStatus * in_sts;
VxlTreeViewStatus * tv_sts;
VgbQueryIndicateStatus * qi_sts;
int in_flags,tv_flags,qi_flags;
VObjectAppStatusAry * app;
VObjectStatus v_sts;
short def_size[2];
VObjectAppStatusAry app2[2];
VVAlignView * vav;
VHAlignView * hav;
VScrollView * sc;
VSize tmp_size,org_size;
int pos1,pos2;


	inherit_child_flags = ~VSF_ATTR;
	if ( arg == 0 )
		return initial_VExError(V_ER_NO_ERR,0,0);
	_lb_head = _lb_tail = 0;
	
	memset(&wpm_w,0,sizeof(wpm_w));
	app = (VObjectAppStatusAry*)arg;
	in_sts = (VgbWPMenuEditStatus*)app[0].sts;
	in_flags = app[0].flags;
	tv_sts = (VxlTreeViewStatus*)app[1].sts;
	if ( tv_sts == 0 ) {
		tv_flags = 0;
		err =  initial_VExError(V_ER_PARAM,0,0);
		goto end;
	}
	else {
		tv_flags = app[1].flags;
		VxlTreeView::copy_VxlTreeViewStatus(&wpm_w.xltv_sts,tv_sts,
			wpm_w.xltv_flags = tv_flags&(
				VSF_XL_TREEVIEW_DIR|
				VSF_XL_TREEVIEW_IMG)|VSF_XL_TREEVIEW_SCROLL|
					VSF_XL_TREEVIEW_FOCUS|
					VSF_XL_TREEVIEW_SND_CLICK);
		wpm_w.xltv_sts.focus_handler = _xltv_focus_handler;
		wpm_w.xltv_sts.focus_handler_arg = this;
		wpm_w.xltv_sts.second_click_enable = 1;
		qi_sts = (VgbQueryIndicateStatus*)app[2].sts;
		if ( qi_sts == 0 ) {
			qi_flags = 0;
			err =  initial_VExError(V_ER_PARAM,0,0);
			goto end;
		}
		else {
			qi_flags = app[2].flags;
			VgbQueryIndicate::copy_queryindicate_status(&wpm_w.qi_sts,qi_sts,
				wpm_w.qi_flags = qi_flags&(
					VSF_QINDICATE_EYE|VSF_QINDICATE_EDIT_EVENT
					|VSF_QINDICATE_DIRTY_BIT));
			wpm_w.qi_sts.dirty = 0;
		}
	}

	VgbWPMenuEdit::copy_wpmedit_status(&wpm_w.sts,(VgbWPMenuEditStatus*)in_sts,&in_flags);
	copy_vobject_status(&sts,s,VSF_WS&flags);
	
	copy_vobject_status(&v_sts,s,flags);
	v_sts.attr = 0;
	v_sts.parent = this;
	v_sts.padding.w = v_sts.padding.h = 0;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.visible = 1;
	v_sts.alignh = VALIGN_FILL;
	v_sts.alignv = VALIGN_FILL;
	org_size = tmp_size = v_sts.min_size;
	pos1 = (int)(v_sts.min_size.w * 0.9);
	pos2 = v_sts.min_size.w - pos1;
//	v_sts.min_size.h = v_sts.min_size.w = 100;
	switch ( wpm_w.xltv_sts.dir ) {
	default:
	case VSD_H_L2R:
		v_sts.attr = VSplitView::shrinkable1|
				VSplitView::expand1_on_resize;
		def_size[0] = org_size.w;
		def_size[1] = -1;
		wpm_w.hsv_obj = VHSplitView::create(&v_sts,flags|VSF_ATTR|VSF_MIN_SIZE,def_size,&err);
		if ( err.code != V_ER_NO_ERR )
			goto end;
		v_sts.parent = wpm_w.hsv_obj;
		v_sts.alignh = VALIGN_FILL;
		v_sts.alignv = VALIGN_FILL;
		vav = VVAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = vav;
//		v_sts.min_size.w = pos1;



		v_sts.alignh = VALIGN_RIGHT;
		v_sts.alignv = VALIGN_TOP;
		hav = VHAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = hav;

		v_sts.value_event_handler = _wpe_details;
		v_sts.value_eh_arg = (void*)this;
		v_sts.descriptor = wpm_w.sts.details;
		wpm_w.details_button =
			VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
						|VSF_VALUE_EH|VSF_DESC);


		v_sts.alignh = VALIGN_FILL;
		v_sts.alignv = VALIGN_FILL;
		v_sts.parent = vav;
		app2[0].sts = (void*)&wpm_w.xltv_sts;
		app2[0].flags = wpm_w.xltv_flags;
		app2[1].sts = 0;
		app2[1].flags = 0;
		wpm_w.xltv_obj = VxlTreeView::create(&v_sts,
				flags|VSF_PARENT|VSF_SPACING|VSF_PADDING|VSF_MIN_SIZE,app2,&err);
		if ( err.code != V_ER_NO_ERR )
			goto end;

		v_sts.parent = wpm_w.hsv_obj;

		v_sts.alignh = VALIGN_FILL;
		v_sts.alignv = VALIGN_FILL;
		vav = VVAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = vav;
//		v_sts.min_size.w = pos1;



		v_sts.alignh = VALIGN_RIGHT;
		v_sts.alignv = VALIGN_TOP;
		hav = VHAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = hav;

		v_sts.value_event_handler = _wpe_close;
		v_sts.value_eh_arg = (void*)this;
		v_sts.descriptor = wpm_w.sts.close;
		wpm_w.close_button =
			VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
						|VSF_VALUE_EH|VSF_DESC);



		v_sts.parent = vav;
		v_sts.alignh = VALIGN_FILL;
		v_sts.alignv = VALIGN_FILL;
		sc = VScrollView::create(&v_sts,flags|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		tmp_size = v_sts.min_size;
		v_sts.parent = sc;
		v_sts.min_size.h = v_sts.min_size.w = 10;
		v_sts.alignh = VALIGN_FILL;
		v_sts.alignv = VALIGN_FILL;
		vav = VVAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);


		v_sts.parent = vav;
		_make_value_tree_view(&v_sts,flags);






		v_sts.alignh = VALIGN_TOP;
		v_sts.alignv = VALIGN_LEFT;
		v_sts.parent = vav;
		hav = VHAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = hav;
		v_sts.descriptor = wpm_w.sts.new_button_descriptor;
		wpm_w.qi_sts.new_button =
			VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
						|VSF_DESC);
		v_sts.descriptor = wpm_w.sts.del_button_descriptor;
		wpm_w.qi_sts.del_button =
			VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
						|VSF_DESC);
		v_sts.descriptor = wpm_w.sts.edit_button_descriptor;
		wpm_w.qi_sts.edit_button =
			VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
						|VSF_DESC);
		wpm_w.qi_flags |= VSF_QINDICATE_NEW_BUTTON|
				VSF_QINDICATE_DEL_BUTTON|
				VSF_QINDICATE_EDIT_BUTTON|
				VSF_QINDICATE_DIRTY_BIT;
		wpm_w.qi_sts.dirty = 0;


		v_sts.parent = vav;
		app2[0].sts = (void*)&wpm_w.qi_sts;
		app2[0].flags = wpm_w.qi_flags;
		app2[1].sts = 0;
		app2[1].flags = 0;
		v_sts.min_size = tmp_size;
		wpm_w.qi_obj = VgbQueryIndicate::create(&v_sts,
				flags|VSF_PARENT|VSF_SPACING|VSF_PADDING|VSF_MIN_SIZE|VSF_ATTR,app2,&err);
		if ( err.code != V_ER_NO_ERR )
			goto end;
/*
		v_sts.min_size.w = pos2;
		wpm_w.xltv_obj->set_status(&v_sts,VSF_MIN_SIZE);
*/
		wpm_w.hsv_obj->hide_pane(1,-1);
		break;
	case VSD_H_R2L:
		v_sts.attr = VSplitView::shrinkable0|
				VSplitView::expand0_on_resize;
		def_size[1] = -1;
		def_size[0] = v_sts.min_size.w;
		wpm_w.hsv_obj = VHSplitView::create(&v_sts,flags|VSF_ATTR|VSF_MIN_SIZE,def_size,&err);
		if ( err.code != V_ER_NO_ERR )
			goto end;
		v_sts.min_size = tmp_size;
		v_sts.parent = wpm_w.hsv_obj;
		sc = VScrollView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = sc;
		tmp_size = v_sts.min_size;
		v_sts.min_size.w = v_sts.min_size.h = 10;
		vav = VVAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = vav;
		hav = VHAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = hav;
		v_sts.descriptor = wpm_w.sts.new_button_descriptor;
		v_sts.alignh = VALIGN_TOP;
		v_sts.alignv = VALIGN_LEFT;
		wpm_w.qi_sts.new_button =
			VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
						|VSF_DESC);
		v_sts.descriptor = wpm_w.sts.del_button_descriptor;
		wpm_w.qi_sts.del_button =
			VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
						|VSF_DESC);
		v_sts.descriptor = wpm_w.sts.edit_button_descriptor;
		wpm_w.qi_sts.edit_button =
			VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
						|VSF_DESC);
		wpm_w.qi_flags |= VSF_QINDICATE_NEW_BUTTON|
				VSF_QINDICATE_DEL_BUTTON|
				VSF_QINDICATE_EDIT_BUTTON|
				VSF_QINDICATE_DIRTY_BIT;
		wpm_w.qi_sts.dirty = 0;





		v_sts.parent = vav;
		v_sts.min_size = tmp_size;
		app2[0].sts = (void*)&wpm_w.qi_sts;
		app2[0].flags = wpm_w.qi_flags;
		app2[1].sts = 0;
		app2[1].flags = 0;
		wpm_w.qi_obj = VgbQueryIndicate::create(&v_sts,
				flags|VSF_PARENT|VSF_SPACING|VSF_PADDING|VSF_MIN_SIZE,app2,&err);
		if ( err.code != V_ER_NO_ERR )
			goto end;



		v_sts.parent = wpm_w.hsv_obj;
		v_sts.alignh = VALIGN_FILL;
		v_sts.alignv = VALIGN_FILL;
		vav = VVAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = vav;
//		v_sts.min_size.w = pos1;



		v_sts.alignh = VALIGN_LEFT;
		v_sts.alignv = VALIGN_TOP;
		hav = VHAlignView::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING);
		v_sts.parent = hav;


		app2[0].sts = (void*)&wpm_w.xltv_sts;
		app2[0].flags = wpm_w.xltv_flags;
		app2[1].sts = 0;
		app2[1].flags = 0;
		v_sts.min_size = tmp_size;
		wpm_w.xltv_obj = VxlTreeView::create(&v_sts,
				flags|VSF_PARENT|VSF_SPACING|VSF_PADDING,app2,&err);
		if ( err.code != V_ER_NO_ERR )
			goto end;
		wpm_w.hsv_obj->hide_pane(0,-1);
		break;
	}

	_loading_target_wpm();
	_set_wpm_ext_list(&wpm_w.wpm_ext,wpm_w.sts.menu,&v_sts,flags,1);
	wpm_w.sts.menu = 0;
	err = initial_VExError(V_ER_NO_ERR,VSF_WS,0);
end:
	return err;
}

void
VgbWPMenuEdit::_wpe_close_handler(VObject * object,void * sys_arg)
{
VWindow * win;
DIALOG_IO io;
	if ( wpm_w.dirty_flag ) {
		if ( wpm_w.sts.loading_target == 0 ) {
			memset(&io,0,sizeof(io));
			io.type = "modal-require-save-untitled";
			io.ret = DIO_NONE;
			win = get_window_object(this);
			win->win_dialog(&io);
			switch ( io.ret ) {
			case DIO_SAVE:
				__wpe_save();
				goto next;
			case DIO_DONTSAVE:
				goto next;
			case DIO_CANCEL:
				return;
			default:
				er_panic("_wpe_close_handler");
			}
		}
		else {
			memset(&io,0,sizeof(io));
			io.type = "modal-require-save";
			if ( l_strcmp(wpm_w.sts.loading_target,l_string(std_cm,"#warpmenu")) == 0 &&
				wpm_w.sts.wp_configure )
				io.msg[0] = wpm_w.sts.wp_configure;
			else	io.msg[0] = wpm_w.sts.loading_target;
			io.ret = DIO_NONE;
			win = get_window_object(this);
			win->win_dialog(&io);
			switch ( io.ret ) {
			case DIO_SAVE:
				goto save;
			case DIO_DONTSAVE:
				goto next;
			case DIO_CANCEL:
				return;
			default:
				er_panic("_wpe_close_handler");
			}
		}
	}
	goto next;
save:
	__wpe_save();
/*
	if ( l_strcmp(wpm_w.sts.loading_target,l_string(std_cm,"#warpmenu")) == 0 ) {
		wpm = _copyout_wpm_ext_list(&wpm_w.wpm_ext,0,0x7fffffff);
		VgbFlame_set_wpm(wpm,2);
		wpm_w.dirty_flag = 0;
	}
*/	
next:
	if ( win_close_handler ) {
		(*win_close_handler)(object,win_close_arg,sys_arg);
	}
	else {
		win = get_window_object(this);
		if ( win )
			win->destroy();
	}
}

V_CALLBACK_D(VgbWPMenuEdit::_wpe_close_handler)
{
VgbWPMenuEdit * obj;
	obj = (VgbWPMenuEdit*)user_arg;
	obj->_wpe_close_handler(object,sys_arg);
}

VExError 
VgbWPMenuEdit::create_do_out_of_lock(
	const VObjectStatus *,int flags,VObject * nmp,void * arg)
{
VWindow * win;
	win = get_window_object(this);
	if ( win == 0 )
		return initial_VExError(V_ER_NO_ERR,0,0);
	win->get_window_close_handler(&win_close_handler,&win_close_arg);
	win->set_window_close_handler(_wpe_close_handler,this);
	_set_window_title();
	return initial_VExError(V_ER_NO_ERR,0,0);
}



void
VgbWPMenuEdit::destroy_do(VObject * nmp)
{
_LOAD_BUTTON_T * t;
	for ( ; _lb_head ; ) {
		t = _lb_head;
		_lb_head = t->next;
		if ( t->end_flag == 0 )
			continue;
		free_wpm(t->wpm);
		d_f_ree(t->target);
		d_f_ree(t);
	}
	VgbQueryIndicate::free_queryindicate_status(&wpm_w.qi_sts);
	VxlTreeView::free_VxlTreeViewStatus(&wpm_w.xltv_sts);
	free_wpmedit_status(&wpm_w.sts);
	_free_wpm_ext_list(&wpm_w.wpm_ext);
	memset(&wpm_w,0,sizeof(wpm_w));
}


void
VgbWPMenuEdit::destroy_do_out_of_lock(VObject * nmp)
{
}

void
VgbWPMenuEdit::redraw(VRect * rect) const
{
}


VgbWPMenuEdit::~VgbWPMenuEdit()
{
}


void
VgbWPMenuEdit::__wpe_details()
{
VObjectStatus _sts;
	switch ( wpm_w.xltv_sts.dir ) {
	default:
	case VSD_H_L2R:
		wpm_w.hsv_obj->show_pane(1,0);
		break;
	case VSD_H_R2L:
		wpm_w.hsv_obj->show_pane(0,0);
		break;
	}
	_sts.visible = 0;
	wpm_w.details_button->set_status(&_sts,VSF_VISIBLE);
}

V_CALLBACK_D(VgbWPMenuEdit::_wpe_details)
{
VgbWPMenuEdit * e;
	e = (VgbWPMenuEdit*)user_arg;
	e->__wpe_details();
}


void
VgbWPMenuEdit::__wpe_close()
{
VObjectStatus _sts;
	switch ( wpm_w.xltv_sts.dir ) {
	default:
	case VSD_H_L2R:
		wpm_w.hsv_obj->hide_pane(1,0);
		break;
	case VSD_H_R2L:
		wpm_w.hsv_obj->hide_pane(0,0);
		break;
	}
	_sts.visible = 1;
	wpm_w.details_button->set_status(&_sts,VSF_VISIBLE);
}

V_CALLBACK_D(VgbWPMenuEdit::_wpe_close)
{
VgbWPMenuEdit * e;
	e = (VgbWPMenuEdit*)user_arg;
	e->__wpe_close();
}


void
VgbWPMenuEdit::_set_dirty_flag()
{
VWindow * win;
	win = get_window_object(this);
	if ( win == 0 )
		return;
	_VM_OP_START_VOID		
	wpm_w.dirty_flag = 1;
	VCustomizedMenuBar::set_menu_flag_que(win,VMT_SAVE,VMF_ENABLED);
	VCustomizedMenuBar::set_menu_func_que(win,VMT_SAVE,_wpe_save,(int)this);
	VM_OP_END
}

WARP_POINT_MENU *
VgbWPMenuEdit::_get_selected_wpm(VxlTreeView * tv,WARP_POINT_MENU_EXT ** v,int type,
	VBackColorView ** bcl,int len)
{
int i;
WARP_POINT_MENU_EXT ** ep,*e;
WARP_POINT_MENU * ret, ** rp, *r;

	_VM_OP_START_ZERO
	ret = 0;
	rp = &ret;
	for ( ep = v ; *ep ; ) {
		e = *ep;
		if ( e->header ) {
			ep = &e->next;
			continue;
		}
		for ( i = 0 ; i < len ; i ++ ) {
			if ( e->main_bc == bcl[i] )
				goto ok;
		}
		if ( e->wpm->submenu_type ) {
			r = _get_selected_wpm(e->submenu_xltv_obj,&e->submenu,type,bcl,len);
			*rp = r;
			for ( ; *rp ; rp = &(*rp)->next );
		}
		ep = &e->next;
		continue;
	ok:
		r = copy_wpm(e->wpm);
		*rp = r;
		rp = &r->next;
		if ( e->wpm && e->wpm->submenu_type ) {
			r->submenu = _copyout_wpm_ext_list(&e->submenu,0,0x7fffffff);
		}
		if ( type == VMT_CUT ) {
			_delete_wpm_ext_list(tv,v,e->no,e->no+1);
		}
		else {
			ep = &e->next;
		}
	}
	VM_OP_END
	return ret;
}

WARP_POINT_MENU_EXT *  
VgbWPMenuEdit::__insert_after_selected_wpm(
	VxlTreeView ** tv_ret,
	WARP_POINT_MENU_EXT *** v_ret,
	VxlTreeView * tv,WARP_POINT_MENU_EXT ** v,
	VBackColorView ** bcl,int len)
{
int i;
WARP_POINT_MENU_EXT *e, * e1, * ret, ** sub_v_ret;
VxlTreeView * sub_tv_ret;

	_VM_OP_START_ZERO
	ret = 0;
	for ( e = *v ; e ; e = e->next ) {
		for ( i = 0 ; i < len ; i ++ ) {
			if ( e->main_bc == bcl[i] )
				goto ok;
		}
		if ( e->wpm && e->wpm->submenu_type ) {
			e1 = __insert_after_selected_wpm(
					&sub_tv_ret,
					&sub_v_ret,
					e->submenu_xltv_obj,&e->submenu,bcl,len);
			if ( e1 ) {
				ret = e1;
				*tv_ret = sub_tv_ret;
				*v_ret = sub_v_ret;
			}
		}
		continue;
	ok:
		ret = e;
		*tv_ret = tv;
		*v_ret = v;
	}
	VM_OP_END
	return ret;
}

void
VgbWPMenuEdit::_insert_after_selected_wpm(VxlTreeView * tv,WARP_POINT_MENU_EXT ** v,
			VBackColorView ** bcl,int len,WARP_POINT_MENU * wpm)
{
WARP_POINT_MENU_EXT * e;
VxlTreeView * tv_ret;
WARP_POINT_MENU_EXT ** v_ret;

	_VM_OP_START_VOID
	e = __insert_after_selected_wpm(&tv_ret,&v_ret,tv,v,bcl,len);
	if ( e == 0 ) {
		if ( *v == 0 )
			return;
		for ( e = *v ; e->next ; e = e->next );
		tv_ret = tv;
		v_ret = v;
	}
	tv->set_hilite(0);
	_copyin_wpm_ext_list(tv_ret,v_ret,wpm,e->no+1,1);
	VM_OP_END
}

int
VgbWPMenuEdit::_xltv_focus_handler_obey_edit(
	int event_type,
	VxlTreeView * tv,
	int type,
	int len,
	VBackColorView  ** bcl,
	void * arg)
{
VdataWPM * v;
int ret;
WARP_POINT_MENU * wpm;
int err;
	_VM_OP_START(0)
	ret = 0;
	switch ( type ) {
	case VMT_COPY:
	case VMT_CUT:
	case VMT_CLEAR:
		wpm = _get_selected_wpm(wpm_w.xltv_obj,&wpm_w.wpm_ext,type,bcl,len);

		if ( type != VMT_CLEAR ) {
			v = new VdataWPM(wpm);
			v->store_into_clipboard();
			free_wpm(wpm);
		}

		_set_tv_wpm_event();

		if ( type == VMT_COPY )
			ret = VMT_COPY;
		else	ret = 0;
		break;
	case VMT_PASTE:
		ret = 0;
		v = VdataWPM::new_from_clipboard();
		if ( v == 0 )
			break;
		wpm = v->get_VdataWPM(&err);
		if ( err < 0 ) {
			delete v;
			break;
		}
		_insert_after_selected_wpm(wpm_w.xltv_obj,&wpm_w.wpm_ext,bcl,len,wpm);
		
		delete v;

		_set_tv_wpm_event();

		ret = VMT_PASTE;
		break;
	default:
		break;
	}
	VM_OP_END
	return ret;
}

void
VgbWPMenuEdit::__wpe_new_group()
{
WARP_POINT_MENU * e;
VBackColorView ** bcl;
int len;
	_VM_OP_START_VOID
	e = (WARP_POINT_MENU*)d_alloc(sizeof(*e));
	memset(e,0,sizeof(*e));
	e->submenu_type = WPM_ST_NORMAL;
	if ( wpm_w.sts.untitled == 0 )
		e->name = nl_copy_str(std_cm,"Untitled");
	else	e->name = ll_copy_str(wpm_w.sts.untitled);
	
	bcl = wpm_w.xltv_obj->get_selected_bc_list(GST_LIST,&len);
	_insert_after_selected_wpm(wpm_w.xltv_obj,&wpm_w.wpm_ext,bcl,len,e);
	d_f_ree(bcl);
	VM_OP_END
}

V_CALLBACK_D(VgbWPMenuEdit::_wpe_new_group)
{
VgbWPMenuEdit * obj;
VMenuItem * item;
ss_printf("warp_point_callback_add_group\n");
	item = static_cast<VMenuItem*>(user_arg);
	VCustomizedMenuBar::menu_lock_inheritance(item->i_tid,__FILE__,__LINE__);
	obj = (VgbWPMenuEdit*)item->get_user_work();
	obj->__wpe_new_group();
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
}

void
VgbWPMenuEdit::_wpe_save_as()
{
DIALOG_IO io;
VWindow * win;
WARP_POINT_MENU * wp;
XL_SEXP * data;
char * filename;
STREAM * st;

retry:
	memset(&io,0,sizeof(io));
	io.type = "modal-select-save-file";
	if ( l_strcmp(wpm_w.sts.loading_target,l_string(std_cm,"#warpmenu")) == 0 &&
		wpm_w.sts.wp_configure )
		io.msg[0] = wpm_w.sts.wp_configure;
	else	io.msg[0] = wpm_w.sts.loading_target;
	io.ret = DIO_NONE;
	win = get_window_object(this);
	win->win_dialog(&io);
	if ( io.ret == DIO_OK ) {
		_VM_OP_START_VOID
		wp = _copyout_wpm_ext_list(&wpm_w.wpm_ext,0,0x7fffffff);
		VM_OP_END

		gc_push(0,0,"");
		data = wpm2sexp(wp,1);
		data = convert_code(data,utf8_cm.main_code,0);
		free_wpm(wp);
		filename = get_machine_filename_string(io.ret_msg[0]);
		st = s_open_file(filename,O_RDWR|O_CREAT|O_TRUNC,0644);
		if ( st == 0 ) {
			io.msg[0] = io.ret_msg[0];
			io.type = "modal-cannot-open-file";
			win->win_dialog(&io);
			d_f_ree(io.msg[0]);
			gc_pop(0,0);
			goto retry;
		}
		else {
			s_set_cm(st,&utf8_cm);
			s_printf(st,"<?xml version=\"0.1\" encoding=\"UTF-8\"?>\n");
			print_sexp(st,data,PF_XML|PF_INDENT);
			s_printf(st,"\n");
			s_close(st);
			d_f_ree(io.ret_msg[0]);
		}
		gc_pop(0,0);
	}
	return;
}

V_CALLBACK_D(VgbWPMenuEdit::_wpe_save_as)
{
VgbWPMenuEdit * obj;
VMenuItem * item;
ss_printf("warp_point_callback_save_as\n");
	item = static_cast<VMenuItem*>(user_arg);
	VCustomizedMenuBar::menu_lock_inheritance(item->i_tid,__FILE__,__LINE__);
	obj = (VgbWPMenuEdit*)item->get_user_work();
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
	obj->_wpe_save_as();
}

void
VgbWPMenuEdit::_wpe_open()
{
DIALOG_IO io;
VWindow * win;
XL_SEXP * r;

	memset(&io,0,sizeof(io));
	io.type = "modal-select-open-file";
	io.msg[0] = 0;
	io.msg[1] = 0;
	io.ret = DIO_NONE;
	win = get_window_object(this);
	win->win_dialog(&io);
	if ( io.ret == DIO_OK ) {
		gc_push(0,0,"");
		if ( wpm_w.sts.open_func ) {
			r = eval(vobj_env,List(get_symbol(wpm_w.sts.open_func),
					get_string(io.ret_msg[0]),
					-1));
		}
		
		gc_pop(0,0);
	}
	return;
}


V_CALLBACK_D(VgbWPMenuEdit::_wpe_open)
{
VgbWPMenuEdit * obj;
VMenuItem * item;
	item = static_cast<VMenuItem*>(user_arg);
	VCustomizedMenuBar::menu_lock_inheritance(item->i_tid,__FILE__,__LINE__);
	obj = (VgbWPMenuEdit*)item->get_user_work();
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
	obj->_wpe_open();
}

void
VgbWPMenuEdit::_wpe_new()
{
XL_SEXP * r;

	gc_push(0,0,"");
	if ( wpm_w.sts.open_func ) {
		r = eval(vobj_env,List(get_symbol(wpm_w.sts.open_func),
				n_get_string(""),
				-1));
	}
	gc_pop(0,0);
	return;
}


V_CALLBACK_D(VgbWPMenuEdit::_wpe_new)
{
VgbWPMenuEdit * obj;
VMenuItem * item;
	item = static_cast<VMenuItem*>(user_arg);
	VCustomizedMenuBar::menu_lock_inheritance(item->i_tid,__FILE__,__LINE__);
	obj = (VgbWPMenuEdit*)item->get_user_work();
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
	obj->_wpe_new();
}

void
VgbWPMenuEdit::__wpe_save()
{
WARP_POINT_MENU * wpm;
VWindow * win;
STREAM * st;
XL_SEXP * data;
char * filename;
DIALOG_IO io;
VObjectStatus v_sts;
	_VM_OP_START_VOID
	if ( wpm_w.dirty_flag == 0 )
		goto end;
	if ( wpm_w.sts.loading_target == 0 ) {
		VM_OP_END
	retry:
		memset(&io,0,sizeof(io));
		io.type = "modal-select-save-file";
		io.ret = DIO_NONE;
		win = get_window_object(this);
		win->win_dialog(&io);
		if ( io.ret == DIO_OK ) {
			v_sts.descriptor = io.ret_msg[0];
			win->set_status(&v_sts,VSF_DESC);
			wpm_w.sts.loading_target = io.ret_msg[0];

			_VM_OP_START_VOID
			wpm = _copyout_wpm_ext_list(&wpm_w.wpm_ext,0,0x7fffffff);
			VM_OP_END

			gc_push(0,0,"");
			data = wpm2sexp(wpm,1);
			data = convert_code(data,utf8_cm.main_code,0);
			free_wpm(wpm);
			filename = get_machine_filename_string(io.ret_msg[0]);
			st = s_open_file(filename,O_RDWR|O_CREAT|O_TRUNC,0644);
			if ( st == 0 ) {
				io.msg[0] = io.ret_msg[0];
				io.type = "modal-cannot-open-file";
				win->win_dialog(&io);
				d_f_ree(io.msg[0]);
				gc_pop(0,0);
				goto retry;
			}
			else {
				s_set_cm(st,&utf8_cm);
				s_printf(st,"<?xml version=\"0.1\" encoding=\"UTF-8\"?>\n");
				print_sexp(st,data,PF_XML|PF_INDENT);
				s_printf(st,"\n");
				s_close(st);
				d_f_ree(io.ret_msg[0]);
			}
			gc_pop(0,0);
		}
		_VM_OP_START_VOID
	}
	else if ( l_strcmp(wpm_w.sts.loading_target,l_string(std_cm,"#warpmenu")) == 0 ) {
		wpm = _copyout_wpm_ext_list(&wpm_w.wpm_ext,0,0x7fffffff);
		VgbFlame_set_wpm(wpm,2);
	}
	else {
		wpm = _copyout_wpm_ext_list(&wpm_w.wpm_ext,0,0x7fffffff);
		filename = get_machine_filename_string(wpm_w.sts.loading_target);
		st = s_open_file(filename,O_CREAT|O_TRUNC|O_RDWR,0644);
		if ( st ) {
			gc_push(0,0,"_save");
			data = wpm2sexp(wpm,1);
			data = convert_code(data,utf8_cm.main_code,0);
			s_set_cm(st,&utf8_cm);
			s_printf(st,"<?xml version=\"0.1\" encoding=\"UTF-8\"?>\n");
			print_sexp(st,data,PF_XML|PF_INDENT);
			s_printf(st,"\n");
			s_close(st);
			
			gc_pop(0,0);
		}
		free_wpm(wpm);
	}
	wpm_w.dirty_flag = 0;
	VM_OP_END
	win = get_window_object(this);
	return;
end:
	VM_OP_END
}

V_CALLBACK_D(VgbWPMenuEdit::_wpe_save)
{
VgbWPMenuEdit * obj;
VMenuItem * item;
ss_printf("warp_point_callback_save\n");
	item = static_cast<VMenuItem*>(user_arg);
	VCustomizedMenuBar::menu_lock_inheritance(item->i_tid,__FILE__,__LINE__);
	obj = (VgbWPMenuEdit*)item->get_user_work();
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
	obj->__wpe_save();
}

void
VgbWPMenuEdit::_finish_edit_wpm(int flag)
{
VObjectStatus _sts;
	_VM_OP_START_VOID
ss_printf("FINISH TEXT-1 %i\n",get_tid());
	if ( wpm_w.edit_wpm == 0 )
		goto end;
ss_printf("FINISH TEXT-2 %i\n",get_tid());
	wpm_w.edit_wpm->main_text->get_status(&_sts,VSF_DESC|VSF_FOCUS);
	if ( flag && _sts.focused == 1 )
		goto end;
ss_printf("FINISH TEXT-3 %i\n",get_tid());
	if ( l_strcmp((L_CHAR*)_sts.descriptor,wpm_w.edit_wpm->wpm->name) )
		_set_dirty_flag();
	d_f_ree(wpm_w.edit_wpm->wpm->name);
	wpm_w.edit_wpm->wpm->name = ll_copy_str((L_CHAR*)_sts.descriptor);
	_sts.value = 0;
ss_printf("FINISH TEXT-4 %i\n",get_tid());
	wpm_w.edit_wpm->main_text->set_status(&_sts,VSF_VALUE);
	wpm_w.edit_wpm = 0;
end:
ss_printf("FINISH TEXT-5 %i\n",get_tid());
	VM_OP_END
}

WARP_POINT_MENU_EXT*
VgbWPMenuEdit::_get_wpm_by_bc(WARP_POINT_MENU_EXT **v,VBackColorView * bc)
{
WARP_POINT_MENU_EXT * e, * ret;

	_VM_OP_START_ZERO
	for ( e = *v ; e ; e = e->next ) {
		if ( e->main_bc == bc ) {
			VM_OP_END
			return e;
		}
		if ( e->submenu ) {
			ret = _get_wpm_by_bc(&e->submenu,bc);
			if ( ret ) {
				VM_OP_END
				return ret;
			}
		}
	}
	VM_OP_END
	return 0;
}

void
VgbWPMenuEdit::_start_edit_wpm(VBackColorView ** bcl,int len)
{
WARP_POINT_MENU_EXT * e;
VObjectStatus _sts;

	_VM_OP_START_VOID
	if ( len == 0 )
		goto end;
	if ( wpm_w.edit_wpm ) {
		if ( wpm_w.edit_wpm->main_bc == bcl[0] )
			goto end;
		_finish_edit_wpm(0);
	}
	wpm_w.edit_wpm = _get_wpm_by_bc(&wpm_w.wpm_ext,bcl[0]);
	if ( wpm_w.edit_wpm == 0 )
		goto end;
	if ( wpm_w.edit_wpm->wpm == 0 ) {
		wpm_w.edit_wpm = 0;
		goto end;
	}
	if ( wpm_w.edit_wpm->wpm->name == 0 ) {
		wpm_w.edit_wpm = 0;
		goto end;
	}
	e = wpm_w.edit_wpm;
	_sts.value = 1;
	_sts.descriptor = wpm_w.edit_wpm->wpm->name;
	e->main_text->set_status(&_sts,VSF_VALUE|VSF_DESC|VSF_FOCUS);
end:
	VM_OP_END
}

void
VgbWPMenuEdit::_set_tv_wpm_event()
{
WARP_POINT_MENU_EXT * e;
VBackColorView ** bcl;
int len;
	_VM_OP_START_VOID
	bcl = wpm_w.xltv_obj->get_selected_bc_list(GST_LIST,&len);
	if ( len == 1 )
		e = _get_wpm_by_bc(&wpm_w.wpm_ext,bcl[0]);
	else	e = 0;
	d_f_ree(bcl);
	_set_tv_wpm(e);
	VM_OP_END
}

int
VgbWPMenuEdit::_xltv_focus_handler(
	int event_type,
	VObject * tv,
	int type,
	int len,
	VBackColorView  ** bcl,
	void * arg)
{
int ret=0;
VgbWPMenuEdit * e;
VMenuItem *itm;
VMenuBar * mb;
VWindow * win;
short modify[] = {
	VMT_FILE,1,
	VMT_WARP_EDIT_NEW_GROUP,1,
	0,0
};
	e = (VgbWPMenuEdit*)arg;

	switch ( event_type ) {
	case FHT_SND_CLICK_BC|FHT_CLICK_BC:
		e->_start_edit_wpm(bcl,len);
	case FHT_CLICK_BC:
		if ( len ) {
			ret = VMF_COPY|VMF_CUT|VMF_CLEAR;
			if ( event_type == FHT_CLICK_BC )
				e->_finish_edit_wpm(0);
			e->_set_tv_wpm_event();
		}
		else {
			ret = 0;
		}

		if ( VdataWPM::clipboard_available() )
			ret |= VMF_PASTE;
		break;
	case FHT_OBEY_EDIT:
		e->_xltv_focus_handler_obey_edit(event_type,static_cast<VxlTreeView*>(tv),type,len,bcl,arg);
		break;
	case FHT_FOCUS_IN:
		mb = VMenuBar::get_menu_bar(0);
		if ( mb == 0 )
			return 0;
		itm = mb->search_VMenuItem(VMT_WARP_EDIT_NEW_GROUP);
		win = get_window_object(e);
		if ( win == 0 || itm == 0 )
			return 0;
		VCustomizedMenuBar::set_menu_flag_que(win,VMT_WARP_EDIT_NEW_GROUP,VMF_ENABLED);
		VCustomizedMenuBar::set_menu_func_que(win,VMT_WARP_EDIT_NEW_GROUP,_wpe_new_group,(int)e);

		VCustomizedMenuBar::set_menu_flag_que(win,VMT_NEW,VMF_ENABLED);
		VCustomizedMenuBar::set_menu_func_que(win,VMT_NEW,_wpe_new,(int)e);
		VCustomizedMenuBar::set_menu_flag_que(win,VMT_SAVE_AS,VMF_ENABLED);
		VCustomizedMenuBar::set_menu_func_que(win,VMT_SAVE_AS,_wpe_save_as,(int)e);
		VCustomizedMenuBar::set_menu_flag_que(win,VMT_OPEN,VMF_ENABLED);
		VCustomizedMenuBar::set_menu_func_que(win,VMT_OPEN,_wpe_open,(int)e);

		if ( e->wpm_w.dirty_flag ) {
			VCustomizedMenuBar::set_menu_flag_que(win,VMT_SAVE,VMF_ENABLED);
			VCustomizedMenuBar::set_menu_func_que(win,VMT_SAVE,_wpe_save,(int)e);
		}
		else {
			VCustomizedMenuBar::set_menu_flag_que(win,VMT_SAVE,0);
		}
		break;
	case FHT_FOCUS_OUT:
		e->_finish_edit_wpm(1);
		mb = VMenuBar::get_menu_bar(0);
		if ( mb == 0 )
			return 0;
		itm = mb->modify_VMenuItem(modify,VMI_MOD_SEARCH);
		win = get_window_object(e);
		if ( win == 0 || itm == 0 )
			return 0;
		VCustomizedMenuBar::set_menu_flag_que(win,VMT_WARP_EDIT_NEW_GROUP,0);
		break;
	default:
		er_panic("_xltv_focus_handler");
	}
	return ret;
}

void
VgbWPMenuEdit::_set_window_title()
{
VWindow * win;
VObjectStatus v_sts;
int p;
	if ( wpm_w.sts.loading_target == 0 ) {
		if ( wpm_w.sts.untitled ) {
			win = get_window_object(this);
			v_sts.descriptor = wpm_w.sts.untitled;
			win->set_status(&v_sts,VSF_DESC);
		}
	}
	else if ( l_strcmp(wpm_w.sts.loading_target,l_string(std_cm,"#warpmenu")) == 0 ) {
	}
	else {

		win = get_window_object(this);
		for ( p = l_strlen(wpm_w.sts.loading_target)-1 ; p >= 0 ; p -- )
			if ( wpm_w.sts.loading_target[p] == '/' )
				break;
		p ++;
		v_sts.descriptor = &wpm_w.sts.loading_target[p];
		win->set_status(&v_sts,VSF_DESC);
	}
}


void
VgbWPMenuEdit::_loading_target_wpm()
{
char * filename;
XL_SEXP * data;
STREAM * st;

	_VM_OP_START_VOID
	if ( wpm_w.sts.loading_target == 0 ) {
	}
	else if ( l_strcmp(wpm_w.sts.loading_target,l_string(std_cm,"#warpmenu")) == 0 ) {
		free_wpm(wpm_w.sts.menu);
		wpm_w.sts.menu = VgbFlameStandard::get_wpm();
	}
	else {
		filename = get_machine_filename_string(wpm_w.sts.loading_target);

		st = s_open_file(filename,O_RDONLY);
		if ( st == 0 ) {
		}
		else {
			s_set_cm(st,&utf8_cm);
			data = init_parse(st,l_string(std_cm,"warp-point"),l_string(std_cm,"warp-point"));
			wpm_w.sts.menu = sexp2wpm(get_el_by_symbol(data,l_string(std_cm,"warp-point-menu"),0));

		}
	}
	VM_OP_END
}

void
VgbWPMenuEdit::_new_wpm_object_1(VxlTreeView * tv,WARP_POINT_MENU_EXT * e,
	VObjectStatus * s,int flags)
{
VObjectStatus v_sts;
VHAlignView * base,* base2;
VVAlignView * base3;
VObjectAppStatusAry app2[2];
VExError err;
VexDraw * d;
VObject * chi;
VxlEditLineStatus e_sts;

	_VM_OP_START_VOID
	copy_vobject_status(&v_sts,s,flags);
	v_sts.parent = tv->macro_base_parent();
	v_sts.padding.w = v_sts.padding.h = 1;
	v_sts.spacing.w = v_sts.spacing.h = 1;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = 1;
	v_sts.descriptor = l_string(std_cm,"BASE");
	base = VHAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);

	v_sts.parent = base;
	v_sts.visible = 1;
	if ( e->wpm == 0 )
		v_sts.descriptor = nl_copy_str(std_cm,"---");
	else	v_sts.descriptor = ll_copy_str(e->wpm->name);

	e->main_bc = static_cast<VBackColorView*>(
		v_sts.parent = tv->get_backcolorview(
			&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE));
	v_sts.padding.w = v_sts.padding.h = 0;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = 1;
	base2 = VHAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);
	v_sts.parent = base2;
	v_sts.padding.w = v_sts.padding.h = 0;
	v_sts.spacing.w = v_sts.spacing.h = 0;
//	v_sts.alignh = VALIGN_LEFT;
	base3 = VVAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);
	v_sts.parent = base3;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignh = VALIGN_LEFT;
	base2 = VHAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);

	switch ( wpm_w.xltv_sts.dir ) {
	default:
	case VSD_H_L2R:
		v_sts.parent = base2;
		
		if ( wpm_w.sts.wp_img ) {
			v_sts.padding.w = v_sts.padding.h = 0;
			v_sts.spacing.w = v_sts.spacing.h = 0;
			v_sts.value = 0;
			d = VexDraw::create(&v_sts,
					VSF_PADDING|VSF_SPACING|VSF_VALUE|
					VSF_PARENT|
					VSF_ALIGN|
					VSF_DESC|
					VSF_VISIBLE);
			if ( e->wpm == 0 )
				d->set_images(1,&wpm_w.sts.wp_img,wpm_w.sts.wp_img->size);
			else if ( e->wpm->submenu_type )
				d->set_images(1,&wpm_w.sts.wpgroup_img,wpm_w.sts.wp_img->size);
			else
				d->set_images(1,&wpm_w.sts.wp_img,wpm_w.sts.wp_img->size);
		}

		v_sts.padding.w = v_sts.padding.h = 0;
		v_sts.spacing.w = v_sts.spacing.h = 0;
		v_sts.alignh = VALIGN_LEFT;
/*
		e->main_text = VStaticText::create(&v_sts,
				VSF_PADDING|VSF_SPACING|VSF_WS|
				VSF_PARENT|
				VSF_ALIGN|
				VSF_DESC|
				VSF_VISIBLE);
*/
		v_sts.value = 0;
		e_sts.items = VEL_ITEM_EDIT_TEXT_2;
		e_sts.max_len = 50;
		e_sts.min_len = 10;
		app2[0].sts = &e_sts;
		app2[0].flags = VSF_EL_ITEMS|VSF_EL_EDIT_TEXT_MAX_LEN|VSF_EL_EDIT_TEXT_MIN_LEN;
		app2[1].sts = 0;
		app2[1].flags = 0;
		e->main_text = VxlEditLine::create(&v_sts,
				VSF_PADDING|VSF_SPACING|VSF_WS|VSF_VALUE|
				VSF_PARENT|VSF_WS|
				VSF_ALIGN|
				VSF_DESC|
				VSF_VISIBLE,app2);
		break;
	case VSD_H_R2L:
		v_sts.parent = base2;
		v_sts.padding.w = v_sts.padding.h = 0;
		v_sts.spacing.w = v_sts.spacing.h = 0;
/*
		e->main_text = VStaticText::create(&v_sts,
				VSF_PADDING|VSF_SPACING|VSF_WS|
				VSF_PARENT|
				VSF_ALIGN|
				VSF_DESC|
				VSF_VISIBLE);
*/
		if ( wpm_w.sts.wp_img ) {
			v_sts.padding.w = v_sts.padding.h = 0;
			v_sts.spacing.w = v_sts.spacing.h = 0;
			v_sts.value = 0;
			d = VexDraw::create(&v_sts,
					VSF_PADDING|VSF_SPACING|VSF_VALUE|
					VSF_PARENT|
					VSF_ALIGN|
					VSF_DESC|
					VSF_VISIBLE);
			d->set_images(1,&wpm_w.sts.wp_img,wpm_w.sts.wp_img->size);
			if ( e->wpm == 0 )
				d->set_images(1,&wpm_w.sts.wp_img,wpm_w.sts.wp_img->size);
			else if ( e->wpm->submenu_type )
				d->set_images(1,&wpm_w.sts.wpgroup_img,wpm_w.sts.wp_img->size);
			else
				d->set_images(1,&wpm_w.sts.wp_img,wpm_w.sts.wp_img->size);
		}

		break;
	}
	if ( e->wpm && e->wpm->submenu_type ) {
		v_sts.parent = tv->macro_base_parent();

		v_sts.padding.w = v_sts.padding.h = 0;
		v_sts.spacing.w = v_sts.spacing.h = 0;
		v_sts.alignv = VALIGN_TOP;
		v_sts.alignh = VALIGN_FILL;
		v_sts.visible = 0;
		chi = base2 = VHAlignView::create(&v_sts,
				VSF_PADDING|VSF_SPACING|
				VSF_PARENT|
				VSF_ALIGN|
				VSF_DESC|
				VSF_VISIBLE);
		v_sts.parent = base2;

		v_sts.visible = 1;
		v_sts.padding.w = v_sts.padding.h = 0;
		v_sts.spacing.w = v_sts.spacing.h = 0;
		v_sts.alignh = VALIGN_FILL;
		base3 = VVAlignView::create(&v_sts,
				VSF_PADDING|VSF_SPACING|
				VSF_PARENT|
				VSF_ALIGN|
				VSF_DESC|
				VSF_VISIBLE);
		v_sts.parent = base3;

		v_sts.spacing.w = v_sts.spacing.h = 0;
		v_sts.alignh = VALIGN_FILL;
		base2 = VHAlignView::create(&v_sts,
				VSF_PADDING|VSF_SPACING|
				VSF_PARENT|
				VSF_ALIGN|
				VSF_DESC|
				VSF_VISIBLE);
		v_sts.parent = base2;

		app2[0].sts = (void*)&wpm_w.xltv_sts;
		app2[0].flags = wpm_w.xltv_flags&(~(VSF_XL_TREEVIEW_SCROLL|VSF_XL_TREEVIEW_FOCUS));
		app2[1].sts = 0;
		app2[1].flags = 0;
		e->submenu_xltv_obj = VxlTreeView::create(&v_sts,
				VSF_PARENT|VSF_SPACING|VSF_ALIGN|VSF_PADDING,app2,&err);
		wpm_w.xltv_obj->set_cascade_focus(e->submenu_xltv_obj);
		_new_wpm_objects(e->submenu_xltv_obj,e->submenu,s,flags,e->wpm->submenu_type);
	}
	tv->insert_line(base,e->no);
	if ( e->submenu ) 
		tv->attach_child(chi,e->no);
	VM_OP_END
}


void
VgbWPMenuEdit::_new_wpm_object_header(VxlTreeView * tv,WARP_POINT_MENU_EXT * e,
	VObjectStatus * s,int flags,int submenu_type,WARP_POINT_MENU_EXT * submenu)
{
VObjectStatus v_sts;
VTableView * base;
VObject * base2;
VObject * base4;
int normal;


	_VM_OP_START_VOID
	if ( submenu_type != WPM_ST_NONE && submenu_type != WPM_ST_NORMAL )
		normal = 1;
	else	normal = 0;

	copy_vobject_status(&v_sts,s,flags);
	v_sts.parent = tv->macro_base_parent();

	v_sts.padding.w = v_sts.padding.h = 0;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = 1;
	v_sts.descriptor = l_string(std_cm,"BASE");
	
	base = VTableView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE,2,1);


	v_sts.parent = base;
	v_sts.padding.w = v_sts.padding.h = 0;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = normal;
	v_sts.descriptor = l_string(std_cm,"BASE");
	e->submenu_ctl[SC_VISIBLE] = base4 = VVAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);
	base->attach_child(base4,0,0);


	v_sts.parent = base4;
	v_sts.padding.w = v_sts.padding.h = 4;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = 1;
	base2 = VHAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);

	v_sts.parent = base2;
	v_sts.padding.w = v_sts.padding.h = 4;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = 1;
	VHSeparator::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);

	v_sts.visible = 1;
	v_sts.parent = base4;
	v_sts.padding.w = v_sts.padding.h = 0;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignh = VALIGN_LEFT;
	v_sts.alignh = VALIGN_LEFT;
	base2 = VHAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);

	v_sts.parent = base2;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignh = VALIGN_LEFT;
	v_sts.alignh = VALIGN_LEFT;

	v_sts.visible = 1;
	if ( submenu == 0 ) {
		v_sts.descriptor = wpm_w.sts.load_menu_link;
		v_sts.value_event_handler = _load_button;
		v_sts.value_eh_arg = (void*)this;
		e->submenu_ctl[SC_LOAD] = VPushButton::create(&v_sts,
				(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
					|VSF_DESC|VSF_VALUE_EH);
	}
	else {
		v_sts.descriptor = wpm_w.sts.unload_menu_link;
		v_sts.value_event_handler = _unload_button;
		v_sts.value_eh_arg = (void*)this;
		e->submenu_ctl[SC_LOAD] = VPushButton::create(&v_sts,
				(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
					|VSF_DESC|VSF_VALUE_EH);
	}
	v_sts.descriptor = wpm_w.sts.open_in_ind_window;
	e->submenu_ctl[SC_OPEN] = 
		VPushButton::create(&v_sts,(flags&(~VSF_MIN_SIZE))|VSF_PARENT|VSF_SPACING|VSF_PADDING
				|VSF_DESC);



	v_sts.parent = base;
	v_sts.padding.w = v_sts.padding.h = 1;
	v_sts.spacing.w = v_sts.spacing.h = 1;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = 1;
	v_sts.descriptor = l_string(std_cm,"BASE");
	base4 = VHAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);
	base->attach_child(base4,1,0);

	v_sts.parent = base4;
	v_sts.visible = 1;

	e->main_bc = static_cast<VBackColorView*>(
		v_sts.parent = tv->get_backcolorview(
			&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE));
	v_sts.padding.w = v_sts.padding.h = 0;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = 1;
	base2 = VHAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);
/*
	v_sts.parent = base2;
	v_sts.padding.w = v_sts.padding.h = 0;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	base3 = VVAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);
	v_sts.parent = base3;
	v_sts.spacing.w = v_sts.spacing.h = 0;
	v_sts.alignh = VALIGN_LEFT;
	base2 = VHAlignView::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);
*/
	v_sts.parent = base2;
	v_sts.padding.w = v_sts.padding.h = 4;
	v_sts.spacing.w = v_sts.spacing.h = 2;
	v_sts.alignv = VALIGN_TOP;
	v_sts.alignh = VALIGN_FILL;
	v_sts.visible = 1;
	VHSeparator::create(&v_sts,
			VSF_PADDING|VSF_SPACING|
			VSF_PARENT|
			VSF_ALIGN|
			VSF_DESC|
			VSF_VISIBLE);
	
	tv->insert_line(base,e->no);
	VM_OP_END
}

void
VgbWPMenuEdit::_new_wpm_objects(VxlTreeView * tv,WARP_POINT_MENU_EXT * e,
	VObjectStatus * s,int flags,int submenu_type)
{
	_VM_OP_START_VOID
	for ( ; e ; e = e->next ) {
		if ( e->header )
			_new_wpm_object_header(tv,e,s,flags,submenu_type,e->next);
		else	_new_wpm_object_1(tv,e,s,flags);
	}
	VM_OP_END
}

void
VgbWPMenuEdit::_set_wpm_ext_list(WARP_POINT_MENU_EXT ** v,WARP_POINT_MENU * wp,
	VObjectStatus * s,int flags,int header_flag)
{
int i;
WARP_POINT_MENU_EXT ** vp,* wp1;
WARP_POINT_MENU * w1;


	_VM_OP_START_VOID
	_free_wpm_ext_list(v);
	/* HEADER */
	if ( header_flag ) {
		wp1 = (WARP_POINT_MENU_EXT*)d_alloc(sizeof(*wp1));
		memset(wp1,0,sizeof(*wp1));
		wp1->next = 0;
		wp1->no = 0;
		wp1->wpm = 0;
		wp1->submenu = 0;
		wp1->header = 1;
		*v = wp1;
		vp = &wp1->next;
	}
	else {
		vp = v;
	}
	for ( i = 1 ; wp ; vp = &(*vp)->next ) {
		wp1 = (WARP_POINT_MENU_EXT*)d_alloc(sizeof(*wp1));
		memset(wp1,0,sizeof(*wp1));
		wp1->next = 0;
		wp1->no = i ++;
		wp1->wpm = wp;
		wp1->submenu = 0;
		if ( wp->submenu_type ) {
			_set_wpm_ext_list(&wp1->submenu,wp->submenu,0,0,1);
			wp->submenu = 0;
		}
		w1 = wp->next;
		wp->next = 0;
		wp = w1;
		
		*vp = wp1;
	}
	if ( s )
		_new_wpm_objects(wpm_w.xltv_obj,*v,s,flags,0);
	VM_OP_END
}

void
VgbWPMenuEdit::_free_wpm_ext_list(WARP_POINT_MENU_EXT ** v)
{
WARP_POINT_MENU_EXT * e;
	_VM_OP_START_VOID
	for ( ; *v ; ) {
		e  = *v;
		if ( e == wpm_w.edit_wpm_detail )
			wpm_w.edit_wpm_detail = 0;
		*v = e->next;
		if ( e->submenu )
			_free_wpm_ext_list(&e->submenu);
		free_wpm(e->wpm);
		d_f_ree(e);
	}
	VM_OP_END
}

WARP_POINT_MENU *
VgbWPMenuEdit::_copyout_wpm_ext_list(WARP_POINT_MENU_EXT ** v,int from,int to)
{
WARP_POINT_MENU_EXT * e;
WARP_POINT_MENU * ret,**rp, * wp;

	_VM_OP_START_ZERO
	ret = 0;
	rp = &ret;
	for ( e = *v ; e && e->no < from ; e = e->next );
	if ( e->no != from ) {
		ret = 0;
		goto end;
	}
	for ( ; e && e->no < to ; e = e->next ) {
		if ( e->header )
			continue;
		wp = copy_wpm(e->wpm);
		if ( e->submenu )
			wp->submenu = _copyout_wpm_ext_list(&e->submenu,0,0x7fffffff);
		wp->next = 0;
		*rp = wp;
		rp = &wp->next;
	}
end:
	VM_OP_END
	return ret;
}

void
VgbWPMenuEdit::_copyin_wpm_ext_list(VxlTreeView * tv,WARP_POINT_MENU_EXT ** v,WARP_POINT_MENU * wp,int at,
	int hilite_flag)
{
WARP_POINT_MENU_EXT ** ep,*e,**ep1, * stop;
WARP_POINT_MENU * wp1;
int prev = 0;
int f;

	_VM_OP_START_VOID
	for ( ep = v ; *ep && at > 0 ; ep = &(*ep)->next, at -- , prev ++ );
	ep1 = ep;
	for ( ; wp ; ) {
		wp1 = wp;
		wp = wp->next;
		wp1->next = 0;
		e = 0;
		_set_wpm_ext_list(&e,wp1,0,0,0);
		_set_dirty_flag();
		e->next = *ep;
		*ep = e;
		ep = &e->next;
		stop = e->next;
	}
	f = 1;
	for ( e = *ep1 ; e ; e = e->next , prev ++ ) {
		e->no = prev;
		if ( e == stop )
			f = 0;
		if ( f ) {
			_new_wpm_object_1(tv,e,&sts,VSF_WS);
			if ( hilite_flag )
				tv->set_hilite(e->main_bc);
		}
	}
	VM_OP_END
}

void
VgbWPMenuEdit::_delete_wpm_ext_list(VxlTreeView * tv,WARP_POINT_MENU_EXT ** v,int from,int to )
{
WARP_POINT_MENU_EXT * e, ** ep;
int i;
int no;
int prev;
	_VM_OP_START_VOID
	i = 0;
	prev = -1;
	for ( ep = v ; *ep && i < from ; i ++ , prev = (*ep)->no , ep = &(*ep)->next );
	if ( *ep == 0 )
		no = prev+1;
	else	no = (*ep)->no;
	for ( ; *ep && i < to ; i ++ ) {
		e = *ep;
		tv->delete_line(no);
		*ep = e->next;
		e->next = 0;
		_free_wpm_ext_list(&e);
		_set_dirty_flag();
	}
	for ( e = *ep ; e ; e = e->next , no ++ )
		e->no = no;
	VM_OP_END
}


VExError
VgbWPMenuEdit::set_status(const VObjectStatus * s,int flags)
{
VExError ret;

	VM_OP_START_EX
	ret = VMacro::set_status(s, flags);
	if ( ret.code )
		goto end;
	if ( wpm_w.qi_obj )
		wpm_w.qi_obj->set_status(s,flags&(VSF_ENABLED|VSF_FOCUS));
	if ( wpm_w.xltv_obj )
		wpm_w.xltv_obj->set_status(s,flags&(VSF_ENABLED|VSF_FOCUS));
end:
	VM_OP_END
	return ret;
}



VExError
VgbWPMenuEdit::get_status(VObjectStatus * s,int flags) const
{
	return VMacro::get_status(s,flags);
}


VExError
VgbWPMenuEdit::set_wpmedit_status(
		const VgbWPMenuEditStatus * _sts,
		int flags)
{
VObjectStatus vs;
	VM_OP_START_EX
	if ( flags & VSF_GB_WPE_MENU ) {
		free_wpm(wpm_w.sts.menu);
		wpm_w.sts.menu = copy_wpm(_sts->menu);
		flags &= ~VSF_GB_WPE_MENU;
	}
	if ( flags & VSF_GB_WPE_NEW_BUTTON_DESC ) {
		d_f_ree(wpm_w.sts.new_button_descriptor);
		wpm_w.sts.new_button_descriptor
			= ll_copy_str(_sts->new_button_descriptor);
		flags &= ~VSF_GB_WPE_NEW_BUTTON_DESC;
		vs.descriptor = wpm_w.sts.new_button_descriptor;
		wpm_w.qi_sts.new_button->set_status(&vs,VSF_DESC);
	}
	if ( flags & VSF_GB_WPE_DEL_BUTTON_DESC ) {
		d_f_ree(wpm_w.sts.del_button_descriptor);
		wpm_w.sts.del_button_descriptor
			= ll_copy_str(_sts->del_button_descriptor);
		flags &= ~VSF_GB_WPE_DEL_BUTTON_DESC;
		vs.descriptor = wpm_w.sts.del_button_descriptor;
		wpm_w.qi_sts.del_button->set_status(&vs,VSF_DESC);
	}
	if ( flags & VSF_GB_WPE_EDIT_BUTTON_DESC ) {
		d_f_ree(wpm_w.sts.edit_button_descriptor);
		wpm_w.sts.edit_button_descriptor
			= ll_copy_str(_sts->edit_button_descriptor);
		flags &= ~VSF_GB_WPE_NEW_BUTTON_DESC;
		vs.descriptor = wpm_w.sts.edit_button_descriptor;
		wpm_w.qi_sts.edit_button->set_status(&vs,VSF_DESC);
	}
	if ( flags & VSF_GB_WPE_LOADING_TARGET ) {
		_loading_target_wpm();
		flags &= ~VSF_GB_WPE_LOADING_TARGET;
	}
	VM_OP_END
	return initial_VExError(V_ER_NO_ERR,flags,0);
}




VExError
VgbWPMenuEdit::get_wpmedit_status(
		VgbWPMenuEditStatus * sts,
		int flags) const
{
	VM_OP_START_EX
	copy_wpmedit_status(sts,(VgbWPMenuEditStatus*)&wpm_w.sts,&flags);
	VM_OP_END
	return initial_VExError(V_ER_NO_ERR,flags,0);
}

void
VgbWPMenuEdit::_load_button(WARP_POINT_MENU_EXT * e,_LOAD_BUTTON_T * t)
{
WARP_POINT_MENU * wpm;
VObjectStatus v_sts;
	for ( ; e ; e = e->next ) {
		if ( e->wpm == 0 )
			continue;
		if ( e->wpm->path && l_strcmp(e->wpm->path,t->target) == 0 ) {
			if ( t->wpm ) {
				_delete_wpm_ext_list(e->submenu_xltv_obj,&e->submenu,1,0x7fffffff);
				wpm = copy_wpm(t->wpm);
				_copyin_wpm_ext_list(e->submenu_xltv_obj,&e->submenu,wpm,1,1);
			}
			if ( e->submenu == 0 || e->submenu->next == 0 ) {
				v_sts.descriptor = wpm_w.sts.load_menu_link;
				v_sts.value_event_handler = _load_button;
				v_sts.value_eh_arg = (void*)this;
			}
			else {
				v_sts.descriptor = wpm_w.sts.unload_menu_link;
				v_sts.value_event_handler = _unload_button;
				v_sts.value_eh_arg = (void*)this;
			}
			v_sts.enabled = 1;
			e->submenu->submenu_ctl[SC_LOAD]->set_status(&v_sts,VSF_DESC|VSF_VALUE_EH|VSF_ENABLED);
		}
		else if ( e->submenu )
			_load_button(e->submenu,t);
	}
}


int
VgbWPMenuEdit::_load_button(_LOAD_BUTTON_T * tt)
{
_LOAD_BUTTON_T * t;
	_VM_OP_START(-1);
	tt->end_flag = 1;
	for ( ; _lb_head ; ) {
		t = _lb_head;
		if ( t->end_flag == 0 )
			break;
		_lb_head = t->next;
		if ( _lb_head == 0 )
			_lb_tail = 0;
		_load_button(wpm_w.wpm_ext,t);
		d_f_ree(t->target);
		free_wpm(t->wpm);
		d_f_ree(t);
	}
	VM_OP_END
	return 0;
}

void
VgbWPMenuEdit::_load_button(XL_SEXP * ret,L_CHAR * target,void*user_arg)
{
_LOAD_BUTTON_T * t;
	t = (_LOAD_BUTTON_T*)user_arg;
	if ( get_type_sexp(ret) == XLT_ERROR ) {
		ss_printf("LOAD ERROR ");
		print_sexp(s_stdout,ret,0);
		ss_printf("\n");
		goto last;
	}
	ret = get_el_by_symbol(ret,l_string(std_cm,"warp-point-menu"),0);
	if ( get_type_sexp(ret) == 0 )
		goto last;
	t->wpm = sexp2wpm(ret);
last:
	if ( t->e_obj->_load_button(t) < 0 ) {
		d_f_ree(t->target);
		free_wpm(t->wpm);
		d_f_ree(t);
	}
}

void
VgbWPMenuEdit::_load_button(VObject * obj,WARP_POINT_MENU_EXT * e)
{
VObjectStatus _sts;
_LOAD_BUTTON_T * t;
	for ( ; e ; e = e->next ) {
		if ( obj == 0 ) {
			if ( e->wpm == 0 )
				continue;
			if ( (e->wpm->submenu_type == WPM_ST_NET || e->wpm->submenu_type == WPM_ST_FILE)
					&&
				e->submenu->next != 0 )
				break;
		}
		else {
			if ( e->submenu == 0 )
				continue;
			if ( e->submenu->submenu_ctl[SC_LOAD] == obj )
				break;
			if ( e->submenu )
				_load_button(obj,e->submenu);
		}
	}
	if ( e == 0 )
		return;
	if ( e->wpm == 0 )
		return;
	if ( e->wpm->path == 0 )
		return;
	_sts.enabled = 0;
	obj->set_status(&_sts,VSF_ENABLED);
	for ( t = _lb_head ; t ; t = t->next ) {
		if ( l_strcmp(t->target,e->wpm->path) == 0 )
			return;
	}
	t = (_LOAD_BUTTON_T*)d_alloc(sizeof(*t));
	t->e_obj = this;
	t->b_obj = e->submenu_ctl[SC_LOAD];
	t->next = 0;
	t->wpm = 0;
	t->target = ll_copy_str(e->wpm->path);
	t->end_flag = 0;
	if ( _lb_tail ) {
		_lb_tail->next = t;
		_lb_tail = t;
	}
	else	_lb_head = _lb_tail = t;
	load_meta_2("data",t->target,_load_button,(void*)t,0);
	
	_load_button(0,e->submenu);
}

void
VgbWPMenuEdit::_load_button(VObject * obj)
{
	_VM_OP_START_VOID
	_load_button(obj,wpm_w.wpm_ext);
	VM_OP_END
}

V_CALLBACK_D(VgbWPMenuEdit::_load_button)
{
VgbWPMenuEdit * eobj;
	eobj = (VgbWPMenuEdit*)user_arg;
	eobj->_load_button(object);
}


void
VgbWPMenuEdit::_unload_button(VObject * obj,WARP_POINT_MENU_EXT * e,WARP_POINT_MENU_EXT * e_submenu)
{
VObjectStatus _sts;
	for ( ; e ; e = e->next ) {
		if ( e->submenu_ctl[SC_LOAD] == obj )
			break;
		if ( e->submenu )
			_unload_button(obj,e->submenu,e);
	}
	if ( e == 0 )
		return;
	if ( e_submenu->wpm == 0 )
		return;
	if ( e_submenu->wpm->path == 0 )
		return;
	_delete_wpm_ext_list(e_submenu->submenu_xltv_obj,&e_submenu->submenu,1,0x7fffffff);
	_sts.enabled = 1;
	_sts.descriptor = wpm_w.sts.load_menu_link;
	_sts.value_event_handler = _load_button;
	_sts.value_eh_arg = (void*)this;
	obj->set_status(&_sts,VSF_ENABLED|VSF_VALUE_EH);
}


void
VgbWPMenuEdit::_unload_button(VObject * obj)
{
	_VM_OP_START_VOID
	_unload_button(obj,wpm_w.wpm_ext,0);
	VM_OP_END
}

V_CALLBACK_D(VgbWPMenuEdit::_unload_button)
{
VgbWPMenuEdit * eobj;
	eobj = (VgbWPMenuEdit*)user_arg;
	eobj->_unload_button(object);
}



// ============= VdataWP ==============


VIM VIM_VdataWP = { &VIM_VdataXL , VDT_NONE };



VdataWP::VdataWP(const L_CHAR *lstr,int * erp,bool valid)
	: VdataXL((char*)0,0,0)
{
VdataXL * xl;
WARP_POINT * q;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWP;
	xl = new VdataXL(lstr,&err);
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return;
	}
	q = sexp2wp(xl->get_VdataXL());
	if ( q == 0 ) {
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	mData = q;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}


VdataWP::VdataWP(const char *str,int * erp,bool valid)
	: VdataXL((char*)0,0,0)
{
VdataXL * xl;
WARP_POINT * q;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWP;
	xl = new VdataXL(str,&err);
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return;
	}
	q = sexp2wp(xl->get_VdataXL());
	if ( q == 0 ) {
		err = -1;
		return;
	}
	mData = q;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}

VdataWP::VdataWP(const XL_SEXP * s,int * erp,bool valid)
	: VdataXL((char*)0,0,0)
{
WARP_POINT * q;
XL_SEXP * _s;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWP;
	_s = (XL_SEXP *)s;
	for ( ; get_type_sexp((XL_SEXP*)_s) == XLT_PAIR ; _s = car(_s) ) {
		if ( get_type_sexp(car(_s)) == XLT_SYMBOL )
			break;
	}
	q = sexp2wp(_s);
	if ( q == 0 ) {
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	mData = q;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}

VdataWP::VdataWP(const WARP_POINT * wp,int * erp,bool valid)
	: VdataXL((char*)0,0,0)
{
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWP;
	mData = rc_copy_warp_point((WARP_POINT*)wp);
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}

VdataWP::VdataWP(Vdata * d,int * erp,bool valid)
	: VdataXL((char*)0,0)
{
VIM * v;
VdataXL * xl;
XL_SEXP * _xl;
VdataWP * vwp;
	if ( !valid )
		return;
	err = 0;
	vdata_type = &VIM_VdataWP;
	v = d->get_type();
	switch ( cmp_VIM(v,&VIM_VdataWP) ) {
	case 0:
	case 1:
		mData = (void*)static_cast<VdataWP*>(d)->get_VdataWP(&err);
		break;
	case -1:
		xl = new VdataXL(d,&err);
		if ( err < 0 ) {
			if ( erp )
				*erp = err;
			delete xl;
			return;
		}
		gc_push(0,0,"");
		_xl = xl->get_VdataXL();
		delete xl;
		vwp = new VdataWP(_xl);
		gc_pop(0,0);
		mData = vwp->get_VdataWP(&err);
		if ( err < 0 ) {
			if ( erp )
				*erp = err;
			return;
		}
		break;
	default:
		err = -1;
		break;
	}
	if ( erp )
		*erp = err;
	if ( err < 0 )
		return;
}

VdataWP::~VdataWP()
{
	if ( this->get_type() != &VIM_VdataWP )
		return;
	if ( mData ) {
		free_warp_point((WARP_POINT*)mData);
	}
}

char*
VdataWP::get_VdataString(int * erp)
{
XL_SEXP * xl;
VdataXL * _xl;
char * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	gc_push(0,0,"");
	xl = wp2sexp((WARP_POINT*)mData);
	_xl = new VdataXL(xl);
	ret = _xl->get_VdataString();
	delete _xl;
	gc_pop(0,0);
	if ( erp )
		*erp = 0;
	return ret;
}

L_CHAR*
VdataWP::get_VdataLString(int * erp)
{
XL_SEXP * xl;
VdataXL * _xl;
L_CHAR * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	gc_push(0,0,"");
	xl = wp2sexp((WARP_POINT*)mData);
	_xl = new VdataXL(xl);
	ret = _xl->get_VdataLString();
	gc_pop(0,0);
	delete _xl;
	if ( erp )
		*erp = 0;
	return ret;
}

XL_SEXP*
VdataWP::get_VdataXL(int * erp)
{
	if ( erp )
		*erp = 0;
	return 	wp2sexp((WARP_POINT*)mData);
}

WARP_POINT *
VdataWP::get_VdataWP(int * erp)
{
WARP_POINT * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	ret = rc_copy_warp_point((WARP_POINT*)mData);
	if ( erp )
		*erp = 0;
	return ret;
}

bool
VdataWP::clipboard_available(bool lock_flag)
{
Vdata * d;
VdataWP * d2;
int er;
bool ret;
ClipBoardList * c;
	if ( lock_flag )
		lock_task(cb_lock);
	ret = false;
	d2 = static_cast<VdataWP*>(check_clipboard_variation(&VIM_VdataWP));
	if ( d2 ) {
		ret = true;
		goto end;
	}
	c = get_clipboard();
	if ( c == 0 )
		goto end;
	d = c->target;
	if ( d == 0 )
		goto end;
	d2 = new VdataWP(d,&er);
	if ( er < 0 )
		goto end;
	insert_clipboard_variation(c,d2);
	ret = true;
end:
	if ( lock_flag )
		unlock_task(cb_lock,"new_from_clipboard");
	return ret;
}

VdataWP * 
VdataWP::new_from_clipboard()
{
VdataWP * ret;
	lock_task(cb_lock);
	if ( VdataWP::clipboard_available(false) )
		ret = static_cast<VdataWP*>(delete_clipboard_variation(&VIM_VdataWP));
	else	ret = 0;
	unlock_task(cb_lock,"new_from_clipboard");
	return ret;
}



// ============= VdataWPM ==============


VIM VIM_VdataWPM = { &VIM_VdataWP , VDT_NONE };



VdataWPM::VdataWPM(const L_CHAR *lstr,int * erp,bool valid)
	: VdataWP((char*)0,0,0)
{
VdataXL * xl;
WARP_POINT_MENU * q;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWPM;
	xl = new VdataXL(lstr,&err);
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return;
	}
	q = sexp2wpm(xl->get_VdataXL());
	if ( q == 0 ) {
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	mData = q;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}


VdataWPM::VdataWPM(const char *str,int * erp,bool valid)
	: VdataWP((char*)0,0,0)
{
VdataXL * xl;
WARP_POINT_MENU * q;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWPM;
	xl = new VdataXL(str,&err);
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return;
	}
	q = sexp2wpm(xl->get_VdataXL());
	if ( q == 0 ) {
		err = -1;
		return;
	}
	mData = q;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}

VdataWPM::VdataWPM(const XL_SEXP * s,int * erp,bool valid)
	: VdataWP((char*)0,0,0)
{
WARP_POINT_MENU * q;
VdataXL * xl;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWPM;
	xl = new VdataXL(s,&err);
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return;
	}
	q = sexp2wpm(xl->get_VdataXL());
	if ( q == 0 ) {
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	mData = q;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}

VdataWPM::VdataWPM(const WARP_POINT_MENU * wpm,int * erp,bool valid)
	: VdataWP((char*)0,0,0)
{
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWPM;
	mData = copy_wpm((WARP_POINT_MENU*)wpm);
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}

VdataWPM::VdataWPM(const WARP_POINT * wp,int * erp,bool valid)
	: VdataWP((char*)0,0,0)
{
WARP_POINT_MENU * wpm;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataWPM;
	wpm = (WARP_POINT_MENU*)d_alloc(sizeof(*wpm));
	memset(wpm,0,sizeof(*wpm));
	wpm->name = ll_copy_str(wp->title);
	wpm->wp = rc_copy_warp_point((WARP_POINT*)wp);
	mData = wpm;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}


VdataWPM::VdataWPM(Vdata * d,int * erp,bool valid)
	: VdataWP((char*)0,0)
{
VIM * v;
VdataXL * xl;
XL_SEXP * _xl;
VdataWPM * vwpm;
VdataWP * vwp;
WARP_POINT * wp;
	if ( !valid )
		return;
	err = 0;
	vdata_type = &VIM_VdataWPM;
	v = d->get_type();
	switch ( cmp_VIM(v,&VIM_VdataWPM) ) {
	case 0:
	case 1:
		mData = (void*)static_cast<VdataWPM*>(d)->get_VdataWPM(&err);
		break;
	case -1:
		if ( cmp_VIM(d->get_type(),&VIM_VdataWP) == 0 ) {
			vwp = new VdataWP(d,&err);
			if ( err < 0 ) {
				if ( erp )
					*erp = err;
				delete vwp;
				return;
			}
			wp = vwp->get_VdataWP();
			delete vwp;
			vwpm = new VdataWPM(wp);
			mData = vwpm->get_VdataWPM(&err);
			if ( err < 0 ) {
				if ( erp )
					*erp = err;
				return;
			}
		}
		else {
			xl = new VdataXL(d,&err);
			if ( err < 0 ) {
				if ( erp )
					*erp = err;
				delete xl;
				return;
			}
			gc_push(0,0,"");
			_xl = xl->get_VdataXL();
			delete xl;
			vwpm = new VdataWPM(_xl);
			gc_pop(0,0);
			mData = vwpm->get_VdataWPM(&err);
			if ( err < 0 ) {
				if ( erp )
					*erp = err;
				return;
			}
		}
		break;
	default:
		err = -1;
		break;
	}
	if ( erp )
		*erp = err;
	if ( err < 0 )
		return;
}

VdataWPM::~VdataWPM()
{
	if ( this->get_type() != &VIM_VdataWPM )
		return;
	if ( mData ) {
		free_wpm((WARP_POINT_MENU*)mData);
	}
}

char*
VdataWPM::get_VdataString(int * erp)
{
XL_SEXP * xl;
VdataXL * _xl;
char * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	gc_push(0,0,"get_VdataString");
	xl = wpm2sexp((WARP_POINT_MENU*)mData,1);
	_xl = new VdataXL(xl);
	gc_pop(0,0);
	ret = _xl->get_VdataString();
	delete _xl;
	if ( erp )
		*erp = 0;
	return ret;
}

L_CHAR*
VdataWPM::get_VdataLString(int * erp)
{
XL_SEXP * xl;
VdataXL * _xl;
L_CHAR * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	xl = wpm2sexp((WARP_POINT_MENU*)mData,1);
	_xl = new VdataXL(xl);
	ret = _xl->get_VdataLString();
	delete _xl;
	if ( erp )
		*erp = 0;
	return ret;
}

XL_SEXP*
VdataWPM::get_VdataXL(int * erp)
{
	if ( erp )
		*erp = 0;
	return 	wpm2sexp((WARP_POINT_MENU*)mData,1);
}

WARP_POINT *
VdataWPM::get_VdataWP(int * erp)
{
WARP_POINT * ret;
WARP_POINT_MENU * m;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	m = (WARP_POINT_MENU*)mData;
	if ( m->next || m->submenu ) {
		err = -1;
		if ( erp )
			*erp = -1;
		return 0;
	}
	if ( m->wp == 0 ) {
		if ( erp )
			*erp = -1;
		return 0;
	}
	ret = rc_copy_warp_point(m->wp);
	if ( erp )
		*erp = 0;
	return ret;
}

WARP_POINT_MENU *
VdataWPM::get_VdataWPM(int * erp)
{
WARP_POINT_MENU * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	ret = (WARP_POINT_MENU*)mData;
	ret = copy_wpm(ret);
	if ( erp )
		*erp = 0;
	return ret;
}

bool
VdataWPM::clipboard_available(bool lock_flag)
{
Vdata * d;
VdataWPM * d2;
int er;
bool ret;
ClipBoardList * c;
	if ( lock_flag )
		lock_task(cb_lock);
	ret = false;
	d2 = static_cast<VdataWPM*>(check_clipboard_variation(&VIM_VdataWPM));
	if ( d2 ) {
		ret = true;
		goto end;
	}
	c = get_clipboard();
	if ( c == 0 )
		goto end;
	d = c->target;
	if ( d == 0 )
		goto end;
	d2 = new VdataWPM(d,&er);
	if ( er < 0 )
		goto end;
	insert_clipboard_variation(c,d2);
	ret = true;
end:
	if ( lock_flag )
		unlock_task(cb_lock,"new_from_clipboard");
	return ret;
}

VdataWPM * 
VdataWPM::new_from_clipboard()
{
VdataWPM * ret;
	lock_task(cb_lock);
	if ( VdataWPM::clipboard_available(false) )
		ret = static_cast<VdataWPM*>(delete_clipboard_variation(&VIM_VdataWPM));
	else	ret = 0;
	unlock_task(cb_lock,"new_from_clipboard");
	return ret;
}
