/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef __KIBANDATA_H__
#define __KIBANDATA_H__

#include <stdio.h>
#include <stdlib.h>
#include "kibandata_util.h"


/* ǡμ */
#define ID_ERROR_EXT	1
#define ID_ARC			2
#define ID_POLYGON		4
#define ID_POINT		8
#define ID_NODE			16
#define ID_TIE			32
#define ID_ATTER		64
#define ID_TEXT			128
#define ID_IMAGE		256

/* եʬ */
#define ID_ERROR_BUNRUI	0
#define ID_GYOUSEI		1
#define ID_SI_TYO		2
#define ID_TYOME		3
#define ID_GAIKU		4
#define ID_ROAD			5
#define ID_KOKUDOU		6
#define ID_KASEN		7
#define ID_KASEN2		8
#define ID_OTHERS		9
#define ID_TETUDOU		10
#define ID_ZYOUTI		11
#define ID_EKI			12
#define ID_MIZU			13
#define ID_TATEMONO		14
#define ID_KIJUNTEN		15

/*
#define CL_SI_TYO_LINE		"red"
#define CL_SI_TYO_FILL		"none"
#define CL_TYOME_LINE		"red"
#define CL_TYOME_FILL		"none"
#define CL_GAIKU_LINE		"orange"
#define CL_GAIKU_FILL		"none"
#define CL_ROAD_LINE		"black"
#define CL_KOKUDOU_LINE		"gray"
#define CL_KASEN_LINE		"blue"
#define CL_KASEN_FILL		"cyan"
#define CL_ZYOUTI_FILL		"green"
#define CL_ZYOUTI_LINE		"brown"
#define CL_EKI_FILL			"bray"
#define CL_EKI_LINE			"black"
#define CL_MIZU_LINE		"blue"
#define CL_MIZU_FILL		"cyan"
#define CL_TATEMONO_LINE	"red"
#define CL_TATEMONO_FILL	"orange"
#define CL_KIJUNTEN_LINE	"red"
#define CL_KIJUNTEN_FILL	"pink"
#define CL_TETUDOU_LINE     "black"
*/
#define CL_SI_TYO_LINE		"#ff0000"
#define CL_SI_TYO_FILL		"none"
#define CL_TYOME_LINE		"#ff0000"
#define CL_TYOME_FILL		"none"
#define CL_GAIKU_LINE		"#000000"
#define CL_GAIKU_FILL		"none"
#define CL_ROAD_LINE		"#000000"
#define CL_ROAD_FILL		"#888888"
#define CL_KOKUDOU_LINE		"#888888"
#define CL_KOKUDOU_FILL		"#444444"
#define CL_KASEN_LINE		"#0000ff"
#define CL_KASEN_FILL		"#00ffff"
#define CL_KASEN2_LINE		"#0000ff"
#define CL_KASEN2_FILL		"#00ffff"
#define CL_OTHERS_FILL		"#000000"
#define CL_OTHERS_LINE		"#888888"
#define CL_ZYOUTI_FILL		"#00ff00"
#define CL_ZYOUTI_LINE		"#440000"
#define CL_EKI_FILL			"#888888"
#define CL_EKI_LINE			"#000000"
#define CL_MIZU_LINE		"#0000ff"
#define CL_MIZU_FILL		"#00ffff"
#define CL_TATEMONO_LINE	"#ff0000"
#define CL_TATEMONO_FILL	"#ff8800"
#define CL_KIJUNTEN_LINE	"#ff0000"
#define CL_KIJUNTEN_FILL	"#ff8888"
#define CL_TETUDOU_LINE     "#000000"
#define CL_TETUDOU_FILL     "#444444"

#define ID_ERR_NOERROR				0
#define ID_ERR_FILE_OPEN			1
#define ID_ERR_FILE_FORMAT			2
#define ID_ERR_NOT_ENOUGH_MEMORY	3
#define ID_ERR_MAP_NOTFOUND			4
#define ID_ERR_FORMAT				5

#define ARC_HEAD_CODE 0
#define ARC_LINE_KIND 1

/*
PrintArc 's option.
*/
#define PA_START 1

typedef struct gb_point{
	double x;
	double y;
} GB_POINT;

typedef struct gb_rect{
	double left;
	double top;
	double right;
	double bottom;
} GB_RECT;

typedef struct map_rect{
	int left;
	int top;
	int right;
	int bottom;
} MAP_RECT;

typedef struct kiban_file_header{
	int data_type;
	char name[8];
	char file_name[MAX_PATH];
	/*  */
	GB_RECT r;
	int record_count;
} KIBAN_FILE_HEADER;



/* ֥եΥǡǼ */
#define  MAX_MAP_NAMES  65536
#define  MAX_MAP_CELLS  10000
typedef struct kiban2svg_processing_info_data{
	MAP_RECT rAllMap;
	char szKibanPath[MAX_PATH];
	int nOneMapWidth;
	int nOneMapHeight;
	int nMapNameCount;
	int nMapNameLength;
	int Cols[MAX_MAP_CELLS];
	int Rows[MAX_MAP_CELLS];
	char szMapNames[MAX_MAP_NAMES];
} KIBAN2SVG_PROCESSING_INFO_DATA;


/* ꤵ줿ݥȤ󤫤顢ζ׻ */
void GetMaxRectFromPoints(GB_RECT *pRect, const GB_POINT *pt, unsigned int nPoints);

/* ե̾ɣĤѴ */
int FileNameToID(const char *szFileName );

#define RKF_ABSOLUTE 1
/*
Ͽޥǡեɤ߹
pDataɤ߹ǡ
Flags...RKF_ABSOLUTE:кɸǰ֤Ǽ
*/
int ReadKibanFile(char *szFileName, int nFileType, void **pData, int Flags);
/* եإåɤ߹ */
int ReadKibanFileHeader(FILE *fp, KIBAN_FILE_HEADER *pHeader);

void MaximizeRect(GB_RECT *pDestRect, GB_RECT *pSrcRect);

#endif
