#!/usr/bin/perl

if($#ARGV < 1){
	print "This script is preprocessing files for kiban2matrix and execute kiban2matrix.\n";
	print "usage: kiban2matrix.pl cdroms-directory matirxfile\n";
	exit;
}

$cdpath = $ARGV[0] . "/*";
$matrixfile = $ARGV[1];

$mapsfile = "maps.tmp";
$conffile = "conf.tmp";


$col_lefttop_latitude = 12;
$col_lefttop_longitude = 15;
$col_leftbottom_latitude = 18;
$col_leftbottom_longitude = 21;

$col_rightbottom_latitude = 24;
$col_rightbottom_longitude = 27;
$col_righttop_latitude = 30;
$col_righttop_longitude = 33;

$col_rightbottom_latitude = 24;
$col_rightbottom_longitude = 27;
$col_righttop_latitude = 30;
$col_righttop_longitude = 33;

$col_lefttop_x = 44;
$col_lefttop_y = 45;
$col_leftbottom_x = 46;
$col_leftbottom_y = 47;
$col_rightbottom_x = 48;
$col_rightbottom_y = 49;
$col_righttop_x = 50;
$col_righttop_y = 51;


@cdroms = glob($cdpath);

print ($#cdroms+1);
print " directory found in cdroms directory\n";

$max_pixel_per_degree=0;
$min_longitude=180.0;
$max_longitude=0;
$min_latitude=180.0;
$max_latitude=0;

print "reading kanri.csv files and writing $mapsfile\n";
open OUTMAPS, ">$mapsfile";

foreach $cdpath (@cdroms){
	$kanri_csv = "$cdpath/DATA/KANRI.CSV";
	if(-e "$cdpath/DATA/KANRI.CSV"){
		&processKanriCSV($kanri_csv);
	}
	else{
		print "kanri.csv file was not found file=$kanri_csv\n";
	}
}

close OUTMAPS;

print "read all cdroms kanri.csv done\n";

open OUTCONF, ">$conffile";
print OUTCONF "$max_pixel_per_degree $min_longitude $max_longitude $min_latitude $max_latitude\n";
close OUTCONF;

print "execute kiban2matrix\n";
$command = "kiban2matrix $conffile $mapsfile $matrixfile";
print $command . "\n";

system ($command);


sub cells2degree{
	my($cells, $index) = @_;
	($cells->[$index]) + ($cells->[$index+1] / 60.0) + ($cells->[$index+2] / 3600.0);
}

sub getPixelPerDegree{
	my ($cells, $deg_big, $deg_small, $pixel_x, $pixel_y) = @_;
	
	$lt_lon = &cells2degree(\@cells, $col_lefttop_longitude);
	$rt_lon = &cells2degree(\@cells, $col_righttop_longitude);
	
	$top_horizontal_dot_per_degree = ($cells[$col_righttop_x] - $cells[$col_lefttop_x]) / ($rt_lon - $lt_lon);
}

sub max{
	$_[0]>$_[1] ? $_[0] : $_[1];
}
sub min{
	$_[0]<$_[1] ? $_[0] : $_[1];
}


sub processKanriCSV{
	my($csv) = @_;
	open IN, "<$csv"  or die "can not open file $csv";
	print "process $csv \n";
	
	@header = split(',', <IN>);
	
	while(<IN>){
		@cells = split(',');
		
		$lt_lon = &cells2degree(\@cells, $col_lefttop_longitude);
		$rt_lon = &cells2degree(\@cells, $col_righttop_longitude);
		$top_horizontal_dot_per_degree = ($cells[$col_righttop_x]-$cells[$col_lefttop_x]) / ($rt_lon-$lt_lon);
		
		$lb_lon = &cells2degree(\@cells, $col_leftbottom_longitude);
		$rb_lon = &cells2degree(\@cells, $col_rightbottom_longitude);
		$bottom_horizontal_dot_per_degree = ($cells[$col_rightbottom_x]-$cells[$col_leftbottom_x]) / ($rb_lon-$lb_lon);
		
		$lt_lat = &cells2degree(\@cells, $col_lefttop_latitude);
		$lb_lat = &cells2degree(\@cells, $col_leftbottom_latitude);
		$left_vertical_dot_per_degree = ($cells[$col_leftbottom_y]-$cells[$col_lefttop_y]) / ($lt_lat-$lb_lat);
		
		$rt_lat = &cells2degree(\@cells, $col_righttop_latitude);
		$rb_lat = &cells2degree(\@cells, $col_rightbottom_latitude);
		$right_vertical_dot_per_degree = ($cells[$col_rightbottom_y]-$cells[$col_righttop_y]) / ($rt_lat-$rb_lat);
		
		$min_longitude = &min($min_longitude, $lt_lon);
		$min_longitude = &min($min_longitude, $lb_lon);
		$max_longitude = &max($max_longitude, $rt_lon);
		$max_longitude = &max($max_longitude, $rb_lon);
		
		$min_latitude = &min($min_latitude, $lb_lat);
		$min_latitude = &min($min_latitude, $rb_lat);
		$max_latitude = &max($max_latitude, $lt_lat);
		$max_latitude = &max($max_latitude, $rt_lat);
		
		$max_pixel_per_degree = &max($max_pixel_per_degree, $top_horizontal_dot_per_degree);
		$max_pixel_per_degree = &max($max_pixel_per_degree, $bottom_horizontal_dot_per_degree);
		$max_pixel_per_degree = &max($max_pixel_per_degree, $left_vertical_dot_per_degree);
		$max_pixel_per_degree = &max($max_pixel_per_degree, $right_vertical_dot_per_degree);
		
		$d = substr($cells[0], 0, 4);
		print OUTMAPS "$cdpath/DATA/$d/$cells[0].TIF $lt_lon $lb_lon $rt_lon $rb_lon $lb_lat $rb_lat $lt_lat $rt_lat ";
		print OUTMAPS "$cells[$col_lefttop_x] $cells[$col_lefttop_y] $cells[$col_righttop_x] $cells[$col_righttop_y] ";
		print OUTMAPS "$cells[$col_leftbottom_x] $cells[$col_leftbottom_y] $cells[$col_rightbottom_x] $cells[$col_rightbottom_y] ";
		print OUTMAPS "$top_horizontal_dot_per_degree $bottom_horizontal_dot_per_degree $left_vertical_dot_per_degree $right_vertical_dot_per_degree\n";
	}
	
	close IN;
}


