/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_FACE_H____
#define VPF_FACE_H____

#include "vpf_types.h"
#include "vpf_table.h"
#include "vpf_file.h"

typedef struct FaceRecord{
	LONG id;
	LONG aft_id[VPF_MAX_FEATURE_COL];
	LONG ring_ptr;
}VPF_FACE_RECORD;

int face_record_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
void face_record_delete(VPF_FACE_RECORD *face);
VPF_FACE_RECORD *vpf_table_get_face(VPF_TABLE *face_table, LONG id);

#endif

