/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___XL_H___
#define ___XL_H___


#ifdef __cplusplus
extern "C" {
#endif


#include	"task.h"
#include	"server.h"
#include	"xllisp.h"
#include	"utils.h"
#include	"regular.h"
#include	"queue.h"
#include	"version.h"
#include	"authentification.h"

#define INTERPRETER_HASH_SIZE	20
#define THREAD_HASH_SIZE 	20

/* open error */
#define XLIE_CANNOT_OPEN_FILE	(-2)
#define XLIE_CANNOT_OPEN_DESCRIPTER (-3)
#define XLIE_CANNOT_OPEN_ACCEPT (-4)
#define XLIE_CANNOT_OPEN_CONNECT (-5)
#define XLIE_CANNOT_OPEN_BUSY	(-6)
#define XLIE_CANNOT_OPEN_DENIED	(-7)
#define XLIE_CANNOT_OPEN_SERVICE_INVALID (-8)

/* xl accept type */
#define XLA_STDIO	1
#define XLA_FILE	2
#define XLA_IPC		3
#define XLA_ACCEPT	4
#define XLA_CONNECT	5
#define XLA_DESCRIPTER	6
#define XLA_SELF	7
#define XLA_PIPE	8

/*
#define LOG_NODE_DATA_INT_PATTERN	0b001 0000 0001 0011
*/
#define LOG_NODE_DATA_INT_PATTERN	0x1013
typedef union log_node_data {
	struct log_node_data_d {
		int		time;
		int		level;
		URL		u;
		int		layer;
		L_CHAR *	user;
		L_CHAR *	key;
		L_CHAR *	data;
	} d;
	int			_int[sizeof(struct log_node_data_d)/sizeof(int)];
	L_CHAR *		_chr[sizeof(struct log_node_data_d)/sizeof(int)];
} LOG_NODE_DATA;
#define LOG_NODE_ELEMENT_LEN	(sizeof(LOG_NODE_DATA)/sizeof(int))

typedef struct log_node {
	Q_HEADER		h;
	LOG_NODE_DATA		d;
	struct log_action *	wait_action;
} LOG_NODE;

typedef struct log_action {
	struct log_action *	next;
	struct log_cond *	cond;
	int			type;
#define LAT_SAVE_FILE		1
#define LAT_CONSOLE		2
#define LAT_RELAY		3
#define LAT_WAIT		4
	L_CHAR *		path;
	int			option;
#define LO_UNLOCK		0x80000000
#define LO_TIME			0x00000001
#define LO_LEVEL		0x00000002
#define LO_URL			0x00000004
#define LO_LAYER		0x00000008
#define LO_USER			0x00000010
#define LO_KEY			0x00000020
#define LO_DATA			0x00000040
#define LO_ALL			0x0000007f
	int			div_nos;
	int			size;
	int			ip;
	int			mask;
} LOG_ACTION;

typedef struct log_cond {
	struct log_cond *	next;
	LOG_NODE_DATA		low;
	LOG_NODE_DATA		high;
	char			op[LOG_NODE_ELEMENT_LEN];
#define LC_OP_NONE	0
#define LC_OP_EQU	1
#define LC_OP_FLONT	2
#define LC_OP_BACK	4
#define LC_OP_BOUND_NN	8
#define LC_OP_BOUND_EN	0x10
#define LC_OP_BOUND_NE	0x20
#define LC_OP_BOUND_EE	0x40
	LOG_ACTION *		action_list;
} LOG_COND;

typedef struct d_sexp {
	DELAY_FUNC		h;
	int			flags;
#define DSF_OK		0x00000001
	XL_SEXP *		ret;
} D_SEXP;


typedef struct remote_session_opt {
	int		timeout_count;
	int		return_format;
#define RFT_DONTCARE	0
#define RFT_HTTP	1
#define RFT_BODY	2
} REMOTE_SESSION_OPT;

typedef struct xl_result {
	DELAY_FUNC		h;
	struct xl_result *	next;
	struct xl_result *	my_xli_result_next;
	int			seq_from;
	int			seq_to;
	int			remote_seq;
	XL_SEXP *		ret;
	XL_SEXP *		cmd_sexp;
	L_CHAR *		cmd_str;
	int			flags;
#define XRF_INPUT	0x00000001
#define XRF_RETURN	0x00000002
	XLISP_ENV *		cur_env;
	struct xl_interpreter *	inp_interpreter;
	struct xl_interpreter *	out_interpreter;

	XL_FILE *		file;
	int			line;

	/* for session control */

	XLISP_ENV *		s_env;
	int			s_id;
	URL			s_url;
	L_CHAR *		s_agent;
	L_CHAR * 		s_login_mode;
	L_CHAR * 		s_center_cmd;
	XL_SEXP * 		s_cmd;
	XL_FILE *		s_file;
	int			s_line;
	struct con_session *	s_session;
	int			s_proxy_ses;
	REMOTE_SESSION_OPT	s_opt;

	XL_SEXP *		send;

	int			wup_key;
	unsigned 		aboat_flag:1;
} XL_RESULT;

typedef struct xl_fifo {
	struct xl_fifo *	next;
	XL_SEXP *		cmd;
} XL_FIFO;

typedef struct p_mode {
	struct p_mode *		next;
	L_CHAR *		name;
} P_MODE;

typedef struct permission_list {
	struct permission_list * next;
	ACCESS_PERMISSION 	ap;
	P_MODE *		mode;
} PERMISSION_LIST;


typedef struct delay_que_t {
	Q_HEADER			h;
	XL_SEXP *			ret;
	struct xl_interpreter * 	xli;
	int				line;
} DELAY_QUE_T;

typedef struct xl_interpreter {
	struct xl_interpreter *	next;
	unsigned int	id;
	XL_FIFO *	fifo_head;
	XL_FIFO *	fifo_tail;
	XL_RESULT *	result_head;
	int		mode;
#define XIM_RUN		0
#define XIM_FLONT_WAIT	1
#define XIM_QUEUE_WAIT	2
#define XIM_RELAY_WAIT	3
#define XIM_CLOSE	4
#define XIM_ERROR 	5
	int		front_thread;
	int		relay_thread;
	int		silent_cnt;
	int		connection_cnt;
	int		flags;
#define XIF_BREAK	0x00000001
#define XIF_CANCEL	0x00000002
#define XIF_TERMINAL	0x00010000
#define XIF_ASYNC	0x00020000
#define XIF_PERMISSION	0x00040000
#define XIF_P_MASK	0x00700000
#define XIF_P_ALLOW	0x00100000
#define XIF_P_DENIED	0x00200000
#define XIF_P_BUSY	0x00300000
#define XIF_P_ERROR	0x00400000
#define XIF_P_STREAM	0x00500000
#define XIF_FIX_CODE	0x01000000
#define XIF_CODE_SYNC	0x02000000
#define XIF_CTO_LOCK	0x04000000
#define XIF_LOCK_F	0x08000000
#define XIF_LOCK_DISE	0x10000000
#define XIF_DQUE_CLOSE	0x20000000
#define XIF_DQUE_LOCK	0x40000000
	unsigned int	open_timeout;


	struct xl_result *
			result_list;
	struct xl_interpreter *
			inp_interpreter;
	int		inp_line;

	int		out_lock;
	int		out_lock_task;

	int		connect_ip;

	char		accept_lock;
	unsigned int	accept_last_dec;

	/* user definition */
	int		ps_flags;
	char		a_type;
	char		thread_mode;
#define TM_1		1
#define TM_2		2
#define TM_SELF		3
	char		proxy_type;
#define PT_NO_PROXY		0x01
#define PT_XLoHTTP		0x02
#define PT_HTTP_PROXY		0x04
#define PT_NATIVE_PROXY		0x08
#define PT_DONT_CARE		0x40
	char		result_flag;
	L_CHAR *	msg;
	STREAM *	inp;
	STREAM *	out;
	STREAM *	err;
	XLISP_ENV *	env;
	XL_FILE * 	acc_file;

	int		port;
	int		port_limit;
	int		ip;
	L_CHAR *	hostname;
	int		max_connection;
	L_CHAR *	input_file_name;
	L_CHAR *	output_file_name;
	L_CHAR *	error_file_name;
	int		connection_timeout;
	int		silent_timeout;
	int		environment;
	PERMISSION_LIST * pl_head;
	PERMISSION_LIST * pl_tail;
	PERMISSION_LIST * pl_accept;
	int		inp_desc;
	int		out_desc;
	int		err_desc;
	int		desc_type;

	unsigned int	accept_interval;

	int		delay_que_cnt;

	struct auth_connection_set *	auth_c_set;

	char *		__file;
	int		__line;
} XL_INTERPRETER;

typedef struct xl_thread {
	struct xl_thread *	next;
	int			tid;
	XL_INTERPRETER *	xli;
} XL_THREAD;

typedef struct xl_gf_cmd {
	struct xl_gf_cmd *	next;
	L_CHAR *		cmd;
} XL_GF_CMD;

typedef struct xl_getfile {
	struct xl_getfile *	next;
	int			flags;
#define XLGFM_XLDIR		0x00000003
#define XLGF_XLSYS_ONLY		0x00000000
#define XLGF_XLDOC_ONLY		0x00000001
#define XLGF_XLSYS_PRECEDENCE	0x00000002
#define XLGF_XLDOC_PRECEDENCE	0x00000003
#define XLGFM_LOCK		0x0000000c
#define XLGF_LOCK_OFF		0x00000000
#define XLGF_URL_PATH		0x00000004
#define XLGF_FULL_PATH		0x00000008
	L_CHAR *		prefix;
	L_CHAR *		agent;
	L_CHAR *		mode;
	L_CHAR *		cmd_sym;
} XL_GETFILE;
#define GETFILE_HASH_SIZE	100

typedef struct server_info {
	int			active_flags;
#define SIA_STATUS		0x00000001
#define SIA_IP			0x00000002
#define SIA_NAME		0x00000004
#define SIA_THPUT		0x00000008
#define SIA_DATA		0x00000010
	int			status;
#define SIS_UNKNOWN		0x00000001
#define SIS_UNRESOLVE		0x00000002
#define SIS_MISSING		0x00000004
#define SIS_CONNECTABLE		0x00000008
#define SIS_CONNECT		0x00000010
#define SIS_ALL			0xffffffff
	char *			name;
	unsigned int		ip;
	int			thput;
	int			data;
} SERVER_INFO;

#define SIC_SET		1
#define SIC_SET_IF_ZERO	2
#define SIC_AVG		3

#define SI_HASH_SIZE	13


typedef struct call_lock_descripter {
	void *		d;
	int		tid;
} CALL_LOCK_DESCRIPTER;
#define CLT_READ_LOCK		1
#define CLT_WRITE_LOCK		2


#define CALL_LOCK_DESCRIPTER_ZERO	{0,0}


#define RI_COUNT_MAX	100


typedef struct ri_queue {
	struct ri_queue *	next;
	struct raw_image *	ri;
	void *			data;
	int			(*call_function)(int call_type,struct ri_queue*,void * data);
#define RICT_CALL	1
#define RICT_COPY	2
#define RICT_CMP	3
#define RICT_DELETE	4
#define RICT_TICK	5
} RI_QUEUE;

typedef int (*ri_que_cf)(int call_type,struct ri_queue*,void * data);


typedef struct raw_image_header {
	Q_HEADER		h;
	struct raw_image *	ri_next;
	struct raw_image *	ri_prev;
} RAW_IMAGE_HEADER;

typedef struct raw_image {
	RAW_IMAGE_HEADER	h;
	L_CHAR *		path;
	int			width;
	int			height;
	void *			data;
	void *			ndata;
	int			ndata_len;
	int			err;
#define RIE_OK		0
#define RIE_REQ		1
#define RIE_ERR		-1
	RI_QUEUE *		ri_que;
} RAW_IMAGE;


CALL_LOCK_DESCRIPTER
xx_call_lock(L_CHAR * lock_dir,int type,void (*)(),void *,char *,int);
#define call_lock(ldir,type,func,data)	xx_call_lock(ldir,type,func,data,__FILE__,__LINE__)

int
call_unlock(CALL_LOCK_DESCRIPTER d);
XL_SEXP * get_cl_error(XL_SEXP *,char *);
int cl_error_check(CALL_LOCK_DESCRIPTER);
CALL_LOCK_DESCRIPTER cl_invalid();

void init_xl(int);
void init_function(XLISP_ENV *,XLISP_ENV *,int,char **);
XL_INTERPRETER * xx_new_xl_interpreter(char*,int);
#define new_xl_interpreter()	xx_new_xl_interpreter(__FILE__,__LINE__);
void init_xl_interpreter(XL_INTERPRETER * xs);
void put_xl_fifo(XL_INTERPRETER *,XL_SEXP *);
XL_SEXP * get_xl_fifo(XL_INTERPRETER *,int);
#define XFF_BLOCK	0
#define XFF_NONBLOCK	1
int check_fifo(XL_INTERPRETER *);
void close_xl_fifo(XL_INTERPRETER *);
int return_result(XL_INTERPRETER *,XL_SEXP *);
XL_SEXP * remote_query(int,XLISP_ENV *,L_CHAR *,XL_SEXP *);
XL_SEXP * local_query(XLISP_ENV *,L_CHAR *,XL_SEXP *);
XL_SEXP * local_eval(int seq_no,XL_SEXP * cmd_sexp);
int setup_i(XL_INTERPRETER*);

void new_interpreter(XL_INTERPRETER *);
void close_interpreter(int id);
void close_all_interpreter();
int setup_xl_interpreter(XL_INTERPRETER *);
void wait_stop_interpreter(int );
void wait_stop_all();

XL_INTERPRETER * _search_xli_id(unsigned int);
XL_INTERPRETER * search_xli_id(int);
XL_INTERPRETER * _search_xli_thread(unsigned int tid);
int check_iid(int);

XL_INTERPRETER * _get_my_xli();
XL_INTERPRETER * get_my_xli();
XL_SEXP * get_user_ip(XLISP_ENV *);
int get_my_iid();

void
new_permission_list(XL_INTERPRETER * xli,XL_SEXP * mode);

XL_SEXP * _q_xml(XLISP_ENV *,XL_SEXP*,XLISP_ENV*,XL_SYM_FIELD*);

XL_GETFILE * search_getfile(L_CHAR *,L_CHAR *,L_CHAR *);
void insert_getfile(L_CHAR *,L_CHAR *,L_CHAR *,int,XL_SEXP *);
XL_GETFILE * search_getfile_by_prefix(L_CHAR * ,XL_GETFILE *);
XL_SEXP *
get_path(L_CHAR * target[2],XL_GETFILE ** gfp,
	 L_CHAR * _filename,XL_SEXP * s,L_CHAR * func_name);

extern int (*agent_open_xli)();
extern int (*agent_close_xli)();

XL_SEXP * connect_lock(XL_SEXP * s,L_CHAR * dir,char * type);
void connect_unlock(XL_SEXP * s,int id,L_CHAR * dir);

XL_SEXP *
load_file(XLISP_ENV * env,XL_SEXP * s,int type,L_CHAR * filename,
	L_CHAR * ,AUTOMATON * ,int,void (*func)(),void * work);
void send_code_sync(int iid);
int
lock_file(
	XL_SEXP ** retp,
	CALL_LOCK_DESCRIPTER * clp,
	L_CHAR ** app,
	L_CHAR * _filename,
	int type,
	char * __fn);
int
unlock_file(
	CALL_LOCK_DESCRIPTER cl,
	L_CHAR * app);

int open_session(int type);
#define SEST_OPTIMIZE	1
//#define SEST_DIRECT	2
int aboat_session(XL_SEXP * s);

void close_session(int);
XL_SEXP *
remote_session(
	XLISP_ENV * env,
	int id,
	URL * u,
	L_CHAR * agent,
	L_CHAR * login_mode,
	L_CHAR * center_cmd,
	XL_SEXP * cmd,
	XL_FILE * f,
	int ln,
	int session_lock_enable,
	REMOTE_SESSION_OPT * opt);
VERSION *
get_remote_version(
	int id,
	URL * u,
	char * layer);
L_CHAR * compose_path(L_CHAR *,L_CHAR *);
XL_SEXP * err_handler(XL_SEXP *,XL_FILE *,int);

/* Relational Operation flags */
#define RO_SORT1	0x00000001
#define RO_SORT2	0x00000002

int xl_log_vprintf(int,int,LOG_NODE_DATA *,char*,va_list);
void set_log_path(L_CHAR*,int,int);
int
log_print_sexp(
	int level,
	int layer,
	LOG_NODE_DATA *,
	char * str,
	XL_SEXP * s,
	int flags);
L_CHAR get_proper_code(XL_SEXP *,int);

typedef struct path_pair {
	L_CHAR * sys_path;
	L_CHAR * docs_path;
	L_CHAR * url_base;
	struct path_pair * next;
} path_pair;


void inp_lock_function(L_CHAR *);
void out_lock_function(int);
void set_lock_function(L_CHAR*);
void unlock_xli_out_iid(int iid);
void lock_xli_out_iid(int iid);

void xl_setup_file(int,char **);

int get_serverinfo(SERVER_INFO *);
int set_serverinfo(SERVER_INFO *,int cmd,int set_if);

XL_SEXP * reverse(XL_SEXP *);
void close_self_interpreter();

XL_SEXP * new_d_sexp(D_SEXP ** d);
void set_d_sexp(D_SEXP * d,XL_SEXP * ret);

int check_remote_delay(XL_RESULT * resp,int key);
int _check_remote_delay(XL_RESULT * resp,int key);
int check_remote_session_delay(XL_RESULT * resp,int key);


int set_c_timeout(int,int);
int get_c_timeout(int);


int set_initial_sexp(int,XLISP_ENV*,XL_SEXP*);
int set_native_proxy(URL * u);
int set_native_proxy_direct_access(L_CHAR *);
XL_SEXP * get_native_proxyinfo();
void compare_gc_check_point(char * msg,void * p);
void *  get_gc_check_point();
void np_divide_p_agent(URL * u);
L_CHAR * get_xlsys(L_CHAR * f);
L_CHAR * get_append_path(L_CHAR * d,char * c);
L_CHAR * get_url_path(L_CHAR * fullpath,L_CHAR * userpath);
L_CHAR * get_append_path(L_CHAR * d,char * c);

extern int default_connect_timeout_table[];
extern int default_silent_timeout_table[];

int get_next_iid(int);
int get_launch_interpreter_nos();

int set_op(XLISP_ENV * e,XL_SEXP * sym,XL_SEXP * data);
int get_xli_info(XL_INTERPRETER * buf,int iid);
int get_main_interpreter();

void set_setagent_msg(char * buf);
void gc_check_empty(char * msg,void * p);
void gc_xl_lock();
void gc_xl_unlock();
void gc_lib();
void gc_interpreter();
void sp_gc_lib();
void sp_gc_interpreter();
void after_gc_lib();


int _setup_i_self(XL_INTERPRETER * xli);
int _setup_i_stdio(XL_INTERPRETER * xli);
int _setup_i_file(XL_INTERPRETER * xli);
int _setup_i_descripter(XL_INTERPRETER * xli);
int _setup_i_pipe(XL_INTERPRETER * xli);
int _setup_i_accept(XL_INTERPRETER * xli);
int _setup_i_connect(XL_INTERPRETER * xli);

int new_file_interpreter(XL_INTERPRETER * xli,L_CHAR * filename);
void free_gf_cmd(XL_GF_CMD * c);
unsigned int getfile_hash_key(L_CHAR * prefix);
L_CHAR * get_synth_path(L_CHAR * b,L_CHAR * filepath);
int path_check(L_CHAR * filepath);
void init_gc_task();
void init_serverinfo();
void init_interpreter();
void init_session();
void init_log(XLISP_ENV * env0,XLISP_ENV * env1);
void init_call_lock();
void test_thread();
void gc_xl_fifo(XL_FIFO * f);
void gc_gblisp_env(XLISP_ENV * p);
void gc_gb_file(XL_FILE * p);
void sp_gc_result1(XL_INTERPRETER * xli);
void sp_gc_result2(XL_INTERPRETER * xli);
void gc_remote_delay(XL_RESULT * p);
void init_interpreter();
int _get_next_iid(int iid);
int _get_launch_interpreter_nos();
void timeout_lock_function();
int terminal_prompt(STREAM * s,int cc);
int terminal_prompt_2(STREAM * s);
void _lock_xli_out(XL_INTERPRETER * xli);
void lock_xli_out(XL_INTERPRETER * xli);
int _lock_xli_out_no_wait(XL_INTERPRETER * xli);
int lock_xli_out_no_wait(XL_INTERPRETER * xli);
void _unlock_xli_out(XL_INTERPRETER * xli);
void unlock_xli_out(XL_INTERPRETER * xli);
void xli_lex_lock(XL_FILE * f);
void xli_lex_unlock(XL_FILE * f);
void xli_lex_result(XL_FILE * f);
void _xli_page_feed(XL_INTERPRETER*xli);
void xli_page_feed(int iid);
PERMISSION_LIST * check_permission_list(XL_INTERPRETER * xli,int ip);
//int check_permission(ACCESS_PERMISSION * ap,int ip);
void free_permission_list(XL_INTERPRETER * xli);
void free_access_list(ACCESS_PERMISSION * ap);
int _new_xli_thread(XL_INTERPRETER * xli);
void _free_xli_thread();
int _get_xli_id();
int _get_xli_info(XL_INTERPRETER * buf,int iid);
void _dque_lock(XL_INTERPRETER * xli);
void _dque_unlock(XL_INTERPRETER * xli);
void insert_delay_que(XL_INTERPRETER * xli,int line,XL_SEXP * s);
void check_result_list(XL_INTERPRETER * xli);
void check_result_list(XL_INTERPRETER * xli);
void delete_result_list(XL_RESULT * resp);
void wait_rs_queue();
int _close_interpreter(XL_INTERPRETER * xli);
void gc_tick();
void _wait_rs_queue();
void accept_thread_tick(STREAM * s);
void launch_accept_thread(
	STREAM * pip,
	unsigned int ip,
	XL_INTERPRETER * xli,
	PERMISSION_LIST * pl);
void a_set_t_msg(int msg);
void __reply(STREAM ** stp,XL_INTERPRETER * xli,int line,XL_SEXP * ret);
void _reply(XL_INTERPRETER * xli,int line,XL_SEXP * ret);
void _front_thread_1(XL_INTERPRETER * xli);
void _cancel(XL_INTERPRETER * xli);
void _break(XL_INTERPRETER * xli);
int _get_user_info(XL_INTERPRETER * xli,XLISP_ENV * env,int line,XL_SEXP * s);
void _permission(XL_INTERPRETER * xli,XL_SEXP * r);
void _front_thread_2(XL_INTERPRETER * xli);
void flush_result_queue(XL_INTERPRETER * xli);
void interrupt_fifo(XL_INTERPRETER * xli);
void relay_loop(XL_INTERPRETER * xli,int flag);
void close_fifo(XL_INTERPRETER * xli);
void set_xli_si(XL_INTERPRETER * xli);
void _tick_check(XL_INTERPRETER * xli);
void gc_d_sexp(D_SEXP * p);
XL_SEXP * d_sexp_func(XL_SEXP * s);
int check_d_sexp(D_SEXP * d);
int delay_t_check_xli(SYS_QUEUE * q,DELAY_QUE_T * n,XL_INTERPRETER * xli);


void setup_value(XLISP_ENV * env0,char ** table,int max);
void free_v_log_node_data(LOG_NODE_DATA * ld);
void free_log_node(LOG_NODE * ln);
char * get_logfile(L_CHAR * path,int no);
int cmp_log_node_data(LOG_NODE_DATA * d,LOG_COND * lc);
void copy_log_node_data(LOG_NODE_DATA * ln1,LOG_NODE_DATA * ln2);
LOG_NODE * copy_log_node(LOG_NODE * ln);
void set_log_condition(LOG_COND * cond);
void free_log_action(LOG_ACTION * a);
void free_log_cond(LOG_COND * lc);
void reset_log_condition();
L_CHAR * get_sym_data(LOG_NODE_DATA * lnd,L_CHAR * sym);
L_CHAR * parse_dir_path(LOG_NODE_DATA * lnd,L_CHAR * path);
void do_log_action_save_file(
	LOG_ACTION * a,
	LOG_NODE * ld);
XL_SEXP * get_log_node_sexp(LOG_NODE_DATA * ld);
void do_log_action_relay(LOG_ACTION * a,LOG_NODE * ld);
void do_log_action_wait(LOG_ACTION * a,LOG_NODE * ld);
void do_log_action(LOG_ACTION * a,LOG_NODE * ld);
void get_log_node_data_from_sexp(LOG_NODE_DATA * ln,XL_SEXP * el);
void log_get_element(XL_SEXP * el);
int log_wait_q_cond(SYS_QUEUE * q,LOG_NODE * a,int * ip);
XL_SEXP * get_log_cond_element(LOG_COND * lc,XL_SEXP * lst);
XL_SEXP * get_log_cond_action(LOG_COND * lc,XL_SEXP * sym);
XL_SEXP * get_log_cond(XL_SEXP * lst);
int  get_log_cond_symbol(L_CHAR * el_data);

int cmp_round(int a,int b);
void delete_result_queue(XL_INTERPRETER * xli,XL_RESULT * r);
XL_SEXP * _remote_query(XL_INTERPRETER * xli,
	XLISP_ENV * env,L_CHAR * cmd_str,XL_SEXP * cmd_sexp);
XL_SEXP * _wait_result_inp(XL_RESULT * resp);
int aboat_remote_query(XL_SEXP * s);

void gc_lock();
void gc_unlock();
void gc();
void sp_gc();
void after_gc();

void init_Append(XLISP_ENV * env);





XL_SEXP * xl_Load(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * arg_env,XL_SYM_FIELD * sf);
void init_Local(XLISP_ENV * env);
void init_LocalEval(XLISP_ENV * env);
void init_MakeElement(XLISP_ENV * env);

XL_SEXP * xl_InsertAfter(XLISP_ENV * env,XL_SEXP * el,XL_SEXP * s);
XL_SEXP * xl_InsertBefore(XLISP_ENV * env,XL_SEXP * el,XL_SEXP * s);
XL_SEXP * xl_Delete(XLISP_ENV * env,XL_SEXP * el,XL_SEXP * s);
void init_MemoryStatistics(XLISP_ENV * env);
void init_NaturalJoin(XLISP_ENV * env);
void init_MoveDefine(XLISP_ENV * env);
int njoin_cmp_field(XL_SEXP ** retp,XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2,XL_FILE*,int);
int njoin_cmp_field_list(XL_SEXP ** retp,
	XLISP_ENV * env,
	XL_SEXP * flist,
	XL_SEXP * s1,XL_SEXP * s2);
XL_SEXP * njoin_cmp_s(XLISP_ENV * e,XL_SEXP * s);
int get_sort_option(XL_SYM_FIELD * sf);
XL_SEXP * get_join_option(XL_SYM_FIELD * sf);
XL_SEXP * _make_record(L_CHAR * field,XL_SEXP * b);
XL_SEXP *  make_record(XL_SEXP * flist,XL_SEXP * a,XL_SEXP * b);
void init_NewEnvironment(XLISP_ENV * env);
void init_NewEnvPair(XLISP_ENV * env);
void init_Next(XLISP_ENV * env);
XL_SEXP * _xl(XL_INTERPRETER ** xlip,XLISP_ENV * env,XL_SEXP * s,int gbtype,
	char * type_mis);
XL_SEXP * _xl_FormatIndent(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_FormatMode(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_Result(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_InpDescripter(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_OutDescripter(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_ErrDescripter(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * set_recv_streams(XL_INTERPRETER * xli,XL_SEXP * s);
XL_SEXP * _xl_Type(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_Port(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_IP(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_HostName(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_MaxConnection(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_ErrorFileName(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_ConnectionTimeout(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_SilentTimeout(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_Environment(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_Permission(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * aenv);
XL_SEXP * _xl_allow_deny(int ap_type,XLISP_ENV * env,XL_SEXP * s);
/*
void insert_access_list(
	ACCESS_PERMISSION * ap,
	int	ip,
	int	mask,
	char *	domain,
	int	type);
*/
XL_SEXP * _xl_Allow(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_Deny(XLISP_ENV * env,XL_SEXP * s);
void init_Permission(XLISP_ENV * env);
void init_OpenInterpreter(XLISP_ENV * env);
void init_OpenSession(XLISP_ENV * env);
void init_Parse(XLISP_ENV * env);
void init_Prefix(XLISP_ENV * env);
void init_Print(XLISP_ENV * env);

L_CHAR * _xl_l_strcat(L_CHAR * str1, L_CHAR * str2);
L_CHAR * _xl_Print_sexp(XL_SEXP * s,L_CHAR * str,XL_SEXP **ee);
void init_PrintChain(XLISP_ENV * env);
void entry_sync();
void exit_sync();
void init_PrintStd(XLISP_ENV * env);
void init_Projection(XLISP_ENV * env);
void init_RegCmp(XLISP_ENV * env);
L_CHAR * add_string(L_CHAR * a,L_CHAR * b,int size);
void init_RegSwitch(XLISP_ENV * env);
void init_RemoteSession(XLISP_ENV * env);
void rs_count(int c);
void init_ReplaceString(XLISP_ENV * env);
XL_SEXP * replace_string_pair(XL_SEXP * str,L_CHAR * org,L_CHAR * );
XL_SEXP * replace_string_string(XL_SEXP * str,L_CHAR * org,L_CHAR*);
XL_SEXP * replace_string(XL_SEXP * str,L_CHAR * org,L_CHAR *);
void init_Reverse(XLISP_ENV * env);
XL_SEXP * check_target(XL_SEXP * list,unsigned long to_time);
int make_dir(L_CHAR * dir,int mode);
XL_SEXP * xl_Exist(XLISP_ENV * e,XL_SEXP * s);
void init_Exist(XLISP_ENV * env);
XL_SEXP * xl_NotExist(XLISP_ENV * e,XL_SEXP * s);
void init_NotExist(XLISP_ENV * env);
XL_SEXP * xl_Target(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a_env,XL_SYM_FIELD * sf);
void init_Target(XLISP_ENV * env);
void init_Rule(XLISP_ENV * env);
void init_Save(XLISP_ENV * env);
int xl_save_write(STREAM * st,XL_SEXP * s);
XL_SEXP * xl_Save(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * arg_env,XL_SYM_FIELD * sf);

XL_SEXP * _xl_InputFileName(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_OutputFileName(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * get_top_core(XL_SEXP * flist,XL_SEXP * s);

void init_Sequence(XLISP_ENV * env);
void init_SetAttribute(XLISP_ENV * env);
XL_SEXP * set_attribute_symbol(XL_SEXP * target,L_CHAR * attr,L_CHAR * data);
XL_SEXP * set_attribute_pair(XL_SEXP * target,L_CHAR * attr,L_CHAR * data);
void init_SetChar(XLISP_ENV * env);
void init_SetDatabasePath(XLISP_ENV * env);
void init_SetEA(XLISP_ENV * env);
void init_SetLogPath(XLISP_ENV * env);
void init_SetMainInterpreter(XLISP_ENV * env);
void init_SetParentEnvironment(XLISP_ENV * env);
void init_SetPrefixMode(XLISP_ENV * env);
void init_SetProxy(XLISP_ENV * env);
void init_SetResultFormat(XLISP_ENV * env);
void init_SetScriptPath(XLISP_ENV * env);
void init_SetThisAgentName(XLISP_ENV * env);
void init_SetUnit(XLISP_ENV * env);
void init_Shell(XLISP_ENV * env);
void init_Export(XLISP_ENV * env);
XL_SEXP * Shell_target(L_CHAR * target,L_CHAR * eval_type,
	     XLISP_ENV * env,XL_SEXP * s);
void init_Sleep(XLISP_ENV * env);
void init_Sort(XLISP_ENV * env);
XL_SEXP * sort_list(XLISP_ENV * env,XL_SEXP * list,XL_SEXP * func);
void init_StringLength(XLISP_ENV * env);
void init_Switch(XLISP_ENV * env);
void init_symbols(XLISP_ENV * env0,XLISP_ENV * env1);
void init_Test(XLISP_ENV * env);
char * set_q(char * q,char ch);
void init_V2H(XLISP_ENV * env);
XL_SEXP * h2v(XL_SEXP * h);
XL_SEXP * _reverse_h_list(XL_SEXP * list);
XL_SEXP * reverse_h_list(XL_SEXP * list,int level);
XL_SEXP * insert_h_list(XL_SEXP * list,XL_SEXP * target,int level);
void init_WaitInterpreter(XLISP_ENV * env);
void init_While(XLISP_ENV * env);
void init_Word2String(XLISP_ENV * env);
char * get_ex_str_integer(int * size,int s,int w);
char * get_ex_str_string(int * size,L_CHAR * s,int w);
char * get_ex_str(int * size,XL_SEXP * s,int w);

void init_Trunc(XLISP_ENV * env);
void init_UnitSystem(XLISP_ENV * env);
XL_SEXP * us_system(UNIT_ENV * ue,XLISP_ENV * env,XL_SEXP * rec,XL_SEXP * sym);
XL_SEXP * us_alias(UNIT_ENV * ue,XLISP_ENV * env,XL_SEXP * rec,XL_SEXP * sym);
XL_SEXP * sexp_commands(CODE_METHOD*,...);

void init_URLStringCode(XLISP_ENV * env);
void init_SetNativeProxy(XLISP_ENV * env);
void init_Get(XLISP_ENV * env);
void init_SetLocalHostName(XLISP_ENV * env);
XL_SEXP * get_op(XLISP_ENV * env,XL_SEXP * ss,L_CHAR * filename);
void init_GetNativeProxy(XLISP_ENV * env);
void init_GetMainInterpreter(XLISP_ENV * env);
void init_GetXLIinfo(XLISP_ENV * env);
XL_SEXP * info_formating(XL_INTERPRETER * xli);
void init_IgnoreDelay(XLISP_ENV * env);
void init_SessionEnvironment(XLISP_ENV * env);

void init_session_http();
int open_session_http(int open_opt);
void close_session_http(int id);
void output_session_http(STREAM * con,char * server,int port);
L_CHAR * get_method(L_CHAR * method);
XL_SEXP * read_reply(STREAM * st,REMOTE_SESSION_OPT*,XL_FILE * f,int ln);
XL_SEXP * one_session(URL * u,XL_SEXP * s,REMOTE_SESSION_OPT*,XL_FILE * f,int ln,int wait_flag);
XL_SEXP * remote_session_http(
	XLISP_ENV * env,
	int id,
	URL * u,
	L_CHAR * _a_agent,
	L_CHAR * _a_login_mode,
	L_CHAR * _a_center_cmd,
	XL_SEXP * cmd,
	XL_FILE * f,
	int ln,
	int session_lock_enable,
	REMOTE_SESSION_OPT *);
void init_session_xlp();
void init_server_function(XLISP_ENV * env0,XLISP_ENV * env1);
void init_sv_Exit(XLISP_ENV * env);
void setup_remote_session_opt(REMOTE_SESSION_OPT *);


void init_OpenAS(XLISP_ENV*);
void init_CloseAS(XLISP_ENV*);
void init_SetAS(XLISP_ENV*);
void init_GetAS(XLISP_ENV*);
void init_GetAllAS(XLISP_ENV*);
void init_IndexAS(XLISP_ENV*);

void init_InsertCompose(XLISP_ENV*);

void init_NullRect(XLISP_ENV*);
void init_InsertRect(XLISP_ENV*);
void init_RectResolution(XLISP_ENV*);
void init_UnionRect(XLISP_ENV*);


void init_ConvertCode(XLISP_ENV * env);
void init_Madd(XLISP_ENV*);
void init_Mmul(XLISP_ENV*);
void init_Melement(XLISP_ENV*);
void init_Mzero(XLISP_ENV*);
void init_Minner(XLISP_ENV*);
void init_Msub(XLISP_ENV*);
void init_sin(XLISP_ENV*);
void init_cos(XLISP_ENV*);
void init_tan(XLISP_ENV*);
void init_sqrt(XLISP_ENV*);
void
init_exsh_function(
	XLISP_ENV * env0,
	XLISP_ENV * env1);
void send_cancel(int iid);
D_SEXP * search_d_sexp(XL_SEXP *);

void init_GetCwd(XLISP_ENV*);
void init_UTime(XLISP_ENV*);
void init_Rm(XLISP_ENV*);
void init_Mv(XLISP_ENV*);
void init_Mkdir(XLISP_ENV*);
void init_Touch(XLISP_ENV*);
void init_FormatEval(XLISP_ENV * env);
void init_GetListbaseEnv(XLISP_ENV * env);
void init_SetListbaseEnv(XLISP_ENV * env);
void init_DefineEval(XLISP_ENV * env);
void init_LaunchWWW(XLISP_ENV * env);

void kill_thread(XL_SEXP * target);


int get_call_lock_seq(CALL_LOCK_DESCRIPTER d);
VERSION * convert_to_version(XL_SEXP * );


void sexp_reconnect(XL_SEXP * s);
int get_my_port();
XL_SEXP *
convert_code(XL_SEXP * st,LCZ_SET * set,int flags);
char * convert_percent(char * inp,char*);
char *
convert_percent_reverse(char * inp);
void * xl_search_ri_org(int * err,int *,L_CHAR * path);
void *
xl_get_ri(int * err,int * w,int * h,ri_que_cf func,void * cf_data,L_CHAR * path);
void init_xl_ri();
extern XL_SEXP * (*convert_code_ptr)(XL_SEXP * st,LCZ_SET * set,int flags);
void
set_arg(int _argc,char ** _argv,int v_offset);


#ifdef __cplusplus
}
#endif


#endif
