/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___V_XL_TREEVIEW_H___
#define ___V_XL_TREEVIEW_H___

#include	"v/v_types.h"
#include	"v/VexDraw.h"
#include	"v/VTableView.h"
#include	"v/VMacro.h"
#include	"v/VFocusView.h"
#include	"v/VBackColorView.h"
#include	"v/VScrollView.h"


typedef struct _VxlTreeViewStatus {
	int			dir;
	int			line_nos;
	VImage *		img;
	VRect			elr[3];
	int			(*focus_handler)(
					int event_type,
					VObject * tv,
					int edit_type,
					int data1,
					VBackColorView  ** data2,
					void * arg);
#define FHT_CLICK_BC		0x01
#define FHT_OBEY_EDIT		0x02
#define FHT_FOCUS_IN		0x04
#define FHT_FOCUS_OUT		0x08
#define FHT_SND_CLICK_BC	0x10
	void *			focus_handler_arg;
	unsigned		second_click_enable:1;
} VxlTreeViewStatus;


#define VSF_XL_TREEVIEW_DIR		(1<<0)
#define VSF_XL_TREEVIEW_LINE_NOS	(1<<1)
#define VSF_XL_TREEVIEW_IMG		(1<<2)
#define VSF_XL_TREEVIEW_FOCUS		(1<<3)
#define VSF_XL_TREEVIEW_SCROLL		(1<<4)
#define VSF_XL_TREEVIEW_SND_CLICK	(1<<5)

typedef struct line_list {
	VObject *		obj;
	VObject *		child;
	VexDraw *		arc;
} LINE_LIST;

typedef struct bc_list {
	struct bc_list *	next;
	VBackColorView *	bc;
	unsigned 		selected:1;
} BC_LIST;



typedef struct VxlTreeView_work {
	VxlTreeViewStatus	tv_sts;
	VTableView *		tv_obj;
	LINE_LIST *		tv_lines;
	VFocusView *		tv_focus;
	VScrollView *		tv_scroll;
	BC_LIST *		bc;
} VxlTreeView_work;




class VxlTreeView : public VMacro
{
  public:
	enum { object_type = VO_XTRV };

	virtual unsigned	get_type() const { return object_type; }
	virtual VObject *	macro_base_parent();
	
	static VxlTreeView* create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VxlTreeView* create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VxlTreeView*>(
			create_tmp(internal_new, object_type, s, flags, err,arg));
	}
	virtual VObject *
				get_backcolorview(VObjectStatus *,int);
	virtual VBackColorView ** get_selected_bc_list(int type,int *lenp);
#define GST_NO_LIST		1
#define GST_LIST		2
	virtual void		set_hilite(VBackColorView * bc,VBackColorView * except=0,int * lenp = 0);

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual VExError	get_xltreeview_status(VxlTreeViewStatus *, int flags) const;
	virtual VExError	set_xltreeview_status(const VxlTreeViewStatus *, int flags);

	static void copy_VxlTreeViewStatus(VxlTreeViewStatus * tv1,VxlTreeViewStatus * tv2,int flags);
	static void free_VxlTreeViewStatus(VxlTreeViewStatus * tv2);
	
	virtual VExError 	attach_line(VObject * child,int line_no);
	virtual VExError	attach_child(VObject * child,int line_no);
	virtual VExError	insert_line(VObject * child,int line_no);
			// line_no == -1 :: last_line 
	virtual VExError	delete_line(int line_no);
	
	virtual void	redraw(VRect* rect = 0) const;


	virtual void	_click_event_handler(struct tv_callback *);
	virtual void 	_disable_focus_handler(bool );
	virtual void	_tv_backcolor_handler(VObject *);
	virtual void 	_tv_focus_command_status();
	virtual void 	_tv_focus_obey_command(int type);
	virtual void 	_tv_bc_destroy_handler(VObject * object);
	
	virtual int set_cascade_focus(VxlTreeView * chi);
	virtual int delete_cascade_focus(VxlTreeView * chi);
	virtual void purge_cascade_focus();

  protected:

  	virtual ~VxlTreeView();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject *);
	virtual void	destroy_do_out_of_lock(VObject*);
	
	int _cf_lock(char*f,int ln);
#define cf_lock()	_cf_lock(__FILE__,__LINE__)
	void cf_unlock();

	VxlTreeView *		cf_next;
	VxlTreeView *		cf_root;
	VxlTreeView *		cf_parent;
	VFocusView *		cf_focus;
	VxlTreeView_work	tv_w;

  private:

	static VObject *internal_new(){
	VxlTreeView * ret;
		ret = new VxlTreeView();
		return ret;
	}

};


typedef struct tv_callback {
	VxlTreeView *		tv_obj;
	LINE_LIST		ll;
} TV_CALLBACK;

extern "C" int
get_treeview_flags(char ** pret,VxlTreeViewStatus * sts,XLISP_ENV * env,XL_SEXP * arg,XL_SYM_FIELD * sf);
extern "C" void
init_VxlTreeView();


#endif

