/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___GBMP_H___
#define ___GBMP_H___

#include	"long_char.h"
#include	"avt.h"
#include	"xl.h"
#include	"gb.h"

/*
#define STACK_INTERVAL		60
*/
#define GRUE_2_NOS	2
#define GRUE_2_ACRP_1	0
#define GRUE_2_ACRP_2	1

#define TQT_CRD		1
#define TQT_CRD_2sec	2
#define TQT_CRD_48sec	3
#define TQT_MCRD	4
#define TQT_MCRD_2sec	5
#define TQT_MCRD_48sec	6
#define TQT_MAP		7
#define TQT_TMP		8
#define TQT_MPC		9
#define TQT_LMP		10
#define TQT_DMAP	11
#define TQT_FMAP	12
#define TQT_SMAP	13
#define TQT_LGC		14
#define TQT_EX_CRD	15
#define TQT_EX_PRG	16
#define TQT_LLT		17
#define TQT_MAX		18

#define TQL_ACRP	0
#define TQL_LUMP	1
#define TQL_NORMAL	2
#define TQL_MAX		3

typedef struct tick_que {
	struct tick_que *	next;
	unsigned int		invoke_time;
	int			type;
	L_CHAR * 		filename;
} TICK_QUE;



typedef struct tque_header {
	AVT_NODE *	tick_que;
	AVT_NODE *	name_que;
} TQUE_HEADER;

typedef struct tq_statistics {
	unsigned int	comesoon;
	int		maps;
	int		tqt_cnt[TQT_MAX];
} TQ_STATISTICS;

typedef struct mp_task_env {
	int		ses;
	int		count;
} MP_TASK_ENV;


typedef struct mp_task_t {
	Q_HEADER 	h;
	int		ins_time;
	TICK_QUE * 	tq;
	void		(*op)(MP_TASK_ENV *,struct mp_task_t *);
 	void		(*free_t)(struct mp_task_t *);
 	XL_SEXP *	sexp;
 	void *		arg;
} MP_TASK_T;


typedef struct set_target_mp_t {
	L_CHAR * target;
	char * prefix;
	MP_TASK_T *	org_thread;
	int		thread_no;
} SET_TARGET_MP_T;

typedef struct org_thread_mp_t {
	int		force;

	L_CHAR * src;
	L_CHAR * dest;
	L_CHAR * map;
	int dp;
	unsigned int mod;

	int 		lump_pmd_interval[2];
	int		lump_pmd_interval_max;
	int		lump_count;
	int		lump_fetch_count;

	int		pitch[2];
	int		count;
	unsigned int	interval;
	int		_interval;
	int		time;
	int		pmd_interval;
	int		pmd_time;
	int		tat;

	unsigned	lump_last_1:1;
	unsigned	lump_last:1;
	unsigned	ping_last:1;
} ORG_THREAD_MP_T;

typedef struct lump_trigger_mp_t {
	MP_TASK_T *	org_thread;
	int		index;
	L_CHAR *	crd;
	L_CHAR *	target;
} LUMP_TRIGGER_MP_T;

void insert_tick_que
	(unsigned int time,L_CHAR * filename,int type,int level);
TICK_QUE * delete_tick_que(int level);
void free_tick_que(TICK_QUE * tq);
void push_tq(L_CHAR *filename,int type);
TICK_QUE * pop_tq();
unsigned int get_comesoon();
XL_SEXP *
local_fetch(unsigned int * mod,URL * u,char * prefix);

XL_SEXP * get_cindex_que();

void	init_tick_que();
void tick_que_statistics(TQ_STATISTICS * w);

int mp_counter();
void trace_mapping();
void trace_crd_routing(int flag);
void trace_crd_mapping(int ses);
void ping_crd_mapping(int ses,L_CHAR* filename);

int check_my_acrp(int ses,L_CHAR * filename,int around_flag);
int ping_mapping(MP_TASK_ENV*,MP_TASK_T * tt,int force);
void trace_crd_mapping();
int get_idle_interval();
void lump_gc_path(int ses);
int tick_lump(TICK_QUE * t,unsigned int tim);
void check_my_lump(int ses,L_CHAR * filename);
int get_map_nos();

void free_mp_task_t(MP_TASK_T * tt);
void new_lump_trigger(MP_TASK_T * tt1,int,L_CHAR * crd,L_CHAR * target);
void ping_mapping_last_2(MP_TASK_ENV * te,MP_TASK_T * tt);
void ping_mapping_last_3(MP_TASK_ENV * te,MP_TASK_T * tt);

XL_SEXP *
gb_MPRouting(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf);

extern SYS_QUEUE mp_task_que_2[GRUE_2_NOS];

#endif

