/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"mx_format.h"

typedef struct gmx_work {
	MX_ENTRY * 	e;
	int		phase_mode;
} GMX_WORK;

MX_ENTRY *	mx_list;

MX_ENTRY * 
search_mx_entry(MATRIX * m)
{
MX_ENTRY * ret;
	for ( ret = mx_list ; ret ; ret = ret->next )
		if ( ret->c.m == m )
			return ret;
	return 0;
}

MX_ENTRY *
search_mx_entry_by_id(int id)
{
MX_ENTRY * ret;
	for ( ret = mx_list ; ret ; ret = ret->next )
		if ( ret->id == id )
			return ret;
	return 0;
}

int
regist_mx_entry(MX_ENTRY * e)
{
static int new_id;
MX_ENTRY * ee;

	ee = search_mx_entry(e->c.m);
	if ( ee )
		return -1;
retry:
	if ( new_id <= 0 )
		new_id = 1;
	else	new_id ++;
	for ( ee = mx_list ; ee ; ee = ee->next )
		if ( ee->id == new_id )
			goto retry;
	e->id = new_id;
	e->next = mx_list;
	mx_list = e;
	return 0;
}

MX_ENTRY *
new_mx_entry(MX_ENTRY * mx_e,MATRIX * m)
{
MX_ENTRY * e;
int i,j;
MATRIX_DATA_TYPE * tp;
int sz;

	if ( mx_e == 0 ) {
		e = d_alloc(sizeof(*e));
		memset(e,0,sizeof(*e));
		e->c.m = m;
		e->p.c = &e->c;
	}
	else {
		e = mx_e;
		m = mx_e->c.m;
	}
	e->c.access_ch = d_alloc(sizeof(int)*m->p.channel_nos);
	e->c.gn_tree_node = GN_NODE;
	e->c.gn_create = GN_ERROR_NORETRY;
	e->c.gn_wait = GN_ERROR_NORETRY;
	
	e->p.data_ix = d_alloc(sizeof(MX_CACHE_PARAM_IX)*m->p.channel_nos);
	e->p.c = &e->c;
/*
	e->p.data_ptrs[0] = d_alloc(sizeof(char)*e->c.ds_len);
	e->p.data_ptrs[1] = d_alloc(sizeof(short)*e->c.ds_len);
	e->p.data_ptrs[2] = d_alloc(sizeof(int)*e->c.ds_len);
	e->p.data_ptrs[3] = d_alloc(sizeof(INTEGER64)*e->c.ds_len);
*/
	j = 0;
	for ( i = 0 ; i < m->p.channel_nos ; i ++ ) {
		if ( m->channel_info[i].data_type == 0 ) {
			continue;
		}
		else {
			e->c.access_ch[j] = i;
			tp = m->channel_info[i].data_type;
			if ( tp->parent ) {
				sz = (*tp->parent->get_size)(tp,0);
			}
			else {
				sz = (*tp->get_size)(tp,0);
			}
			switch ( sz ) {
			case 1:
				e->p.data_ix[j].p = 0;
				e->p.data_ix[j].x = i;
				break;
			case 2:
				e->p.data_ix[j].p = 1;
				e->p.data_ix[j].x = i;
				break;
			case 4:
				e->p.data_ix[j].p = 2;
				e->p.data_ix[j].x = i;
				break;
			case 8:
				e->p.data_ix[j].p = 3;
				e->p.data_ix[j].x = i;
				break;
			default:
				e->p.data_ix[j].p = MXC_INVALID;
				e->p.data_ix[j].x = MXC_INVALID;
			}
			j ++;
		}
	}
	e->c.ds_len = j;

	mxc_setup(&e->c);

	regist_mx_entry(e);
	return e;
}

void
open_mxread_method(MATRIX_TOKEN * t)
{
MATRIX * m;
MX_ENTRY * e;
GMX_WORK * w;
int err;
MATRIX_PARAM mp;
XL_SEXP * current_phase[MI_MAX];
int i;

	m = t->wait_matrix;
	w = m->open_work;
	err = load_matrix_header(m,O_RDONLY,0644);
	if ( err < 0 ) {
		w->e = 0;
		set_matrix_mode(m,MM_ERR);
		return;
	}
	
	memset(&mp,0,sizeof(mp));
//	mp.write_file = matrix_standard_write_file;
	mp.read_file = matrix_standard_read_file;
	mp.close_file = close_matrix_file;

	if ( w->phase_mode < 0 ) {
		err = set_matrix_param(m,&mp);

		if ( err < 0 )
			er_panic("setup error");

		e = search_mx_entry(m);
		if ( e == 0 )
			e = new_mx_entry(0,m);

		set_matrix_cal(m,MI_FETCH_1_TP,
			sexp_commands(
				std_cm,
		"<mxFinish\n",
		"	normal-jump-status=\"MS_OK\"\n",
		"	err-jump-status=\"MS_PROCESS_ERR_1\"/>\n",
		"<mxLoad target=\"file\"/>\n",
				0));
		set_matrix_cal_equ(m,MI_FETCH_1_MD,MI_FETCH_1_TP);
		set_matrix_cal_equ(m,MI_FETCH_1_BT,MI_FETCH_1_TP);


	}
	else {
		err = set_matrix_param(m,&mp);

		if ( err < 0 )
			er_panic("setup error");

		e = search_mx_entry(m);
		if ( e == 0 )
			e = new_mx_entry(0,m);

		err=load_mode_cal(current_phase,mp.pri_area,m,w->phase_mode);
		for ( i = 0 ; i < MI_MAX ; i ++ ) {
			err = set_matrix_cal(m,i,current_phase[i]);
		}
	}

	w->e = e;
	set_matrix_mode(m,MM_STANBY);
}



MX_ENTRY *
open_mxread(L_CHAR *neturl,L_CHAR * filename,L_CHAR * key,int phase_mode)
{
GMX_WORK w;
MATRIX * m;
	memset(&w,0,sizeof(w));
	w.phase_mode = phase_mode;
	m = open_matrix_with_search(
			neturl,filename,key,
			open_mxread_method,&w);
	if ( m == 0 )
		return 0;
	wait_matrix_mode(m);
	if ( w.e == 0 ) {
		return search_mx_entry(m);
	}
	return w.e;
}

void
close_mx_entry(MX_ENTRY * e)
{
	flush_mx_cache(&e->c,1);
	d_f_ree(e->c.access_ch);
	d_f_ree(e->p.data_ix);
	close_matrix(e->c.m);
}





