/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<sys/types.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<limits.h>
#include	"memory_debug.h"
#include	"task.h"
#include	"utils.h"
#include	"stream.h"
#include	"machine/fork_lock.h"

#define CLOSE(x)	\
	{					\
	int er;					\
		for ( ; ; ) {			\
			er = close(x);		\
			if ( er >= 0 )		\
				break;		\
			if ( errno != EINTR )	\
				break;		\
		}				\
	}



int
_launch_proc_stdio_1(
	STREAM ** st_in,
	STREAM ** st_out,
	STREAM ** st_err,
	char * str)
{
int p_in[2];
int p_out[2];
int p_err[2];
int id;
int fid;

	u_child_countup(); 
	pipe(p_in);
	pipe(p_out);
	pipe(p_err);
	wlock_fork();
	id = fork();
	if ( id == 0 ) {
		for ( fid = 0 ; fid <= sys_param.max_fd ; fid ++ ) {
			if ( p_in[0] == fid )
				continue;
			if ( p_out[1] == fid )
				continue;
			if ( p_err[1] == fid )
				continue;
			CLOSE(fid);
		}
		dup(p_in[0]);
		CLOSE(p_in[0]);
		dup(p_out[1]);
		CLOSE(p_out[1]);
		dup(p_err[1]);
		CLOSE(p_err[1]);
		system(str);
		CLOSE(0);
		CLOSE(1);
		CLOSE(2);
		exit(0);
	}
	wunlock_fork();
	CLOSE(p_in[0]);
	CLOSE(p_out[1]);
	CLOSE(p_err[1]);
	*st_in = s_open_descripter(p_in[1],&s_pipe_table);
	*st_out = s_open_descripter(p_out[0],&s_pipe_table);
	*st_err = s_open_descripter(p_err[0],&s_pipe_table);
	return 0;
}


int
_launch_proc_stdio_2(
	char * str)
{
int id,fid;
	wlock_fork();
	id = fork();
	if ( id == 0 ) {
		for ( fid = 3 ; fid <= sys_param.max_fd ; fid ++ ) {
			CLOSE(fid);
		}
		system(str);
		exit(0);
	}
	wunlock_fork();
	return 0;
}


int
launch_proc_stdio(
	STREAM ** st_in,
	STREAM ** st_out,
	STREAM ** st_err,
	char * str)
{
	if ( st_in )
		return _launch_proc_stdio_1(
			st_in,st_out,st_err,str);
	else	return _launch_proc_stdio_2(str);
}

