/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


// ===========================================================================
//	VLayout.h
// ===========================================================================

#ifndef _H_VLayoutAttachment
#define _H_VLayoutAttachment
#pragma once

#include <LApplication.h>
#include <LPeriodical.h>

#include "v/VLayout.h"

class VLayoutAttachment : public LAttachment, public LPeriodical
{
protected:
	// called before event is dispatched
	virtual void	ExecuteSelf(
					MessageT	inMessage,
					void*		ioParam)
			{
				if ( VLayout::need_layout() )
					VLayout::layout_marked_window();
				mExecuteHost = true;
			}
public:
	// called after event is dipatched
	virtual	void	SpendTime( const EventRecord& inMacEvent )
			{
				if ( VLayout::need_layout() )
					VLayout::layout_marked_window();
			}

			VLayoutAttachment()
			{
				StartRepeating();
			}
};


#endif // _H_VLayoutAttachment