/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "PP_Prefix.h"
#include "LTabsControl.h"

#include "v/VTabView.h"
#include "v/VLayout.h"
#include "VReflector.h"
#include "CClickCheckAttachment.h"

const short margin_above_tab = 4;
const short margin_below_tab = 4;

VExError
VTabView::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	int i;
	tab_set *set = (tab_set*)arg;
	n_pages = set->pages;
	sts.value = 0;
	
	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	SViewInfo viewInfo = { (SDimension32){0,0}, {0,0}, {8,8}, false };
	LTabsControl *v = new LTabsControl(paneInfo, viewInfo, msg_ValueChanged,
											kControlTabLargeProc, 0, 1);
	v->SetMaxValue(n_pages);
	v->FinishCreate();
	v->AddListener(new VReflector(this));
	v->AddAttachment(new CClickCheckAttachment);
	v->FocusDraw();
	ControlTabInfoRec tabinfo = {0, 0, "\p"};
	min_width = n_pages*24 + 12;
	for ( i = 0 ; i < n_pages ; i++ ) {
		c2pstrcpy(tabinfo.name, n_string(std_cm,const_cast<L_CHAR*>(set->names[i])));
		v->SetDataTag(i+1, kControlTabInfoTag, sizeof(tabinfo), &tabinfo);
		min_width += TextWidth(tabinfo.name, 1, tabinfo.name[0]);
	}
	info = v;
	
	VExError err = nmp->add_child_do(this);
	if ( err.code )
		goto end;
	
	creating = 1;
	pages = new VTabPage*[n_pages];
	for ( i = 0 ; i < n_pages ; i++ ) {
		VObjectStatus cs;
		cs.parent = this;
		cs.alignh = cs.alignv = VALIGN_FILL;
		pages[i] = VTabPage::create(&cs, VSF_PARENT | VSF_ALIGN, &err);
		if ( i )
			pages[i]->get_info_this()->Hide();
		if ( err.code != V_ER_NO_ERR )
			er_panic("VTabView::create_do");
	}
	creating = 0;
	
end:
	return err;
}

void
VTabView::destroy_do(VObject* nmp)
{
	nmp->remove_child_do(this);
	delete[] pages;
	delete info;
	nmp->redraw();
}

VTabView::~VTabView()
{
}

VExError
VTabView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	if ( flags & VSF_POSITION ) {
		SPoint32 pos;
		info->GetFrameLocation(pos);
		s->position.x = pos.h;
		s->position.y = pos.v-margin_above_tab;
		flags &= ~VSF_POSITION;
	}
	if ( flags & VSF_SIZE ) {
		SDimension16 size;
		info->GetFrameSize(size);
		s->size.w = size.width;
		s->size.h = size.height+margin_above_tab+margin_below_tab;
		flags &= ~VSF_SIZE;
	}
	VExError err = v_get_status_standard(s, &flags, info);

	if ( flags & VSF_VALUE ) {
		s->value = info->GetValue() - 1;
		flags &= ~VSF_VALUE;
	}
	err.subcode1 = flags;

	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	V_OP_END
	return err;
}

VExError
VTabView::set_status(const VObjectStatus *s, int flags)
{
	int i;
	V_OP_START_EX

	if ( flags & VSF_SIZE ) {
		if ( s->size.w != sts.size.w || s->size.h != sts.size.h )
			info->ResizeFrameTo(s->size.w, s->size.h-margin_above_tab-margin_below_tab, true);
	}
	if ( flags & VSF_POSITION ) {
		if ( s->position.x != sts.position.x || s->position.y != sts.position.y )
			info->PlaceInSuperImageAt(s->position.x, s->position.y+margin_above_tab, true);
	}
	VExError err = v_set_status_standard(s, flags&~(VSF_SIZE|VSF_POSITION), &sts, info);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & VSF_VALUE ) {
		info->SetValue(s->value + 1);
		err.subcode1 &= ~VSF_VALUE;
	}

	if ( flags & VSF_CALC_MIN ) {
		for ( VObjectList *list = sts.children ; list ; list = list->next )
			list->object->set_status(0, VSF_CALC_MIN);
		sts.min_size.w = min_width;
		sts.min_size.h = 24;
		for ( i = 0 ; i < n_pages ; i++ ) {
			VLayout layout;
			layout.set_margin((VSize){2,26+margin_above_tab}, (VSize){2,2+margin_below_tab});
			layout.layout_in_frame(this, true, i);
			if ( sts.min_size.w < layout.parent_min_size().w )
				sts.min_size.w = layout.parent_min_size().w;
			if ( sts.min_size.h < layout.parent_min_size().h )
				sts.min_size.h = layout.parent_min_size().h;
		}
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		for ( i = 0 ; i < n_pages ; i++ ) {
			VLayout layout;
			layout.set_margin((VSize){2,26}, (VSize){2,2+margin_below_tab});
			layout.layout_in_frame(this, false, i);
			layout.do_layout(this);
		}
		err.subcode1 &= ~VSF_LAYOUT;
	}

	V_OP_END

	if ( flags & ( VSF_HOMOGEN | VSF_SPACING | VSF_ALIGN | VSF_PADDING | VSF_VISIBLE ) ) {
		VLayout::mark(this);
		err.subcode1 &= ~(VSF_HOMOGEN|VSF_SPACING|VSF_ALIGN|VSF_PADDING);
	}

	return err;
}

VExError
VTabView::add_child_do(VObject*child)
{
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VTabView::remove_child_do(VObject* child)
{
	// do nothing
}

void
VTabView::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VTabView::value_changed()
{
	int v = info->GetValue() - 1;
	if ( sts.value != v ) {
		pages[sts.value]->get_info_this()->Hide();
		pages[v]->get_info_this()->Show();
		sts.value = v;
		VObject::value_changed();
	}
}

void
VTabView::redraw(VRect* rect) const
{
	_V_OP_START()
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	V_OP_END
}

VTabPage*
VTabView::get_page(int n)
{
	VTabPage *ret;
	_V_OP_START(0)
	if ( n < 0 || n >= n_pages )
		ret = 0;
	else
		ret = pages[n];
	V_OP_END
	return ret;
}
