/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "xl.h"
#include "xlerror.h"



int
get_my_port()
{
int p;
XL_SEXP * port;
static int my_port;
	if ( my_port )
		return my_port;
	gc_push(0,0,"fetch");
	port = eval(gblisp_top_env1,get_symbol(l_string(std_cm,"ServerPort")));
	switch ( get_type(port) ) {
	case XLT_ERROR:
		if ( (port->err.code & XLE_VERB_MASK) == XLE_EXIT ) {
			gc_pop(0,0);
			return 0;
		}
		print_sexp(s_stderr,port,0);
		s_printf(s_stderr,"\n");
		er_panic("get_my_port");
	case XLT_INTEGER:
		p = port->integer.data;
		break;
	default:
		fprintf(stderr,"type missmatch");
		fflush(stderr);
		print_sexp(s_stderr,port,0);
		s_printf(s_stderr,"\n");
		er_panic("get_my_port");
	}
	gc_pop(0,0);
	my_port = p;
	return p;
}

