/**********************************************************************
 *
 * Copyright (C) 2003-2004
 * Hirohisa MORI <joshua@nichibun.ac.jp>
 * Masaki MIDORIKAWA <greenrev@nichibun.ac.jp>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GLOBALBASE
 * Library General Public License (G-LGPL) as published by
 *
 * http://www.globalbase.org/
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * **********************************************************************/

#include "xl.h"
#include "xlerror.h"
#include "utils.h"
#include "memory_debug.h"

XL_SEXP * xl_SetDirectory();

void
init_SetDirectory(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetDirectory"),
		get_func_prim(xl_SetDirectory,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_SetDirectory(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
	L_CHAR * url;
	XL_SEXP * path;
	path = get_el(s,1);
	url = get_sf_attribute(sf,l_string(std_cm,"url"));
	if(!url){
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"SetDirectory"),
			n_get_string("invalid path url"));
	}
	if((Reg_List_pathpair((path->string.data),url))==-1)
	{
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"SetDirectory"),
			n_get_string("Failed registory path_pair"));
	}
	return List(path,-1);
}
