/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"
#include	"version.h"
#include	"memory_debug.h"

XL_SEXP * xl_GetVersion();
XL_SEXP * date_format(VERSION * v);
XL_SEXP * version_format(VERSION * v);


void
init_GetVersion(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetVersion"),
		get_func_prim(xl_GetVersion,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
date_format(VERSION * v)
{
char buf[12];
	if ( v->month == 0 )
		sprintf(buf,"%i",v->year);
	else if ( v->date == 0 )
		sprintf(buf,"%i-%i",v->year,v->month);
	else	sprintf(buf,"%i-%i-%i",v->year,v->month,v->date);
	return n_get_string(buf);
}

XL_SEXP *
version_format(VERSION * v)
{
	return List(
		n_get_string(v->layer),
		n_get_string(v->name),
		n_get_string(v->publisher),
		n_get_string(v->version),
		date_format(v),
		-1);
}

VERSION *
convert_to_version(XL_SEXP * s)
{
XL_SEXP * d;
char * date;
char * p;
int y,m,dd;
VERSION * ret;

#define CV(label,nos)	\
	d = get_el(s,nos);			\
	if ( get_type(d) != XLT_STRING )	\
		goto err;			\
	ret->label = ln_copy_str(std_cm,d->string.data);

	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	
	CV(layer,0)
	CV(name,1)
	CV(publisher,2)
	CV(version,3)
	if ( list_length(s) >= 5 ) {
		CV(comment,4)
	}

	d = get_el(s,4);
	if ( get_type(d) != XLT_STRING )
		goto err;
	date = ln_copy_str(std_cm,d->string.data);
	p = date;
	for ( ; *p ; p ++ ) {
		if ( *p == '-' )
			*p = ' ';
	}
	y = dd = m = 0;

	sscanf(date,"%i %i %i",&y,&m,&dd);
	ret->year = y;
	ret->month = m;
	ret->date = dd;

	d_f_ree(date);
	return ret;
err:
	free_version(ret);
	return 0;
}



XL_SEXP *
xl_GetVersion(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
VERSION * vlist;
L_CHAR * layer;
XL_SEXP * ret;
	layer = get_sf_attribute(sf,l_string(std_cm,"layer"));
	if ( layer == 0 ) {
		vlist = get_version(0);
		ret = 0;
		for ( ; vlist ; vlist = vlist->next ) {
			ret = cons(
				version_format(vlist),ret);
		}
	}
	else {
		vlist = get_version(n_string(std_cm,layer));
		if ( vlist == 0 )
			ret = 0;
		else	ret = version_format(vlist);
	}

	return ret;
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetVersion"),
		0);
*/
}


