/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbgraph.h"

int
xl_to_gb_point(GB_POINT *p, XL_SEXP * s)
{
#define SET_REAL(a, s)	\
	if ( get_type(s) == XLT_FLOAT ) a = s->floating.data;		\
	else if ( get_type(s) == XLT_INTEGER ) a = s->integer.data;	\
	else return -1

XL_SEXP * x,* y;
	
	if ( list_length(s) != 2 )
		return -1;
	
	x = get_el(s,0);
	y = get_el(s,1);
	
	SET_REAL(p->x, x);
	SET_REAL(p->y, y);
	return 0;
}

XL_SEXP *
gb_point_to_xl(GB_POINT *p)
{
	return List(get_floating(p->x, 0), get_floating(p->y, 0), -1);
}


int
xl_to_gb_rect(GB_RECT *r, XL_SEXP * s)
{
XL_SEXP * tl,* br;

	if ( list_length(s) != 2 )
		return -1;
	
	tl = get_el(s,0);
	br = get_el(s,1);
	
	if ( xl_to_gb_point(&r->tl, tl) )
		return -1;
	if ( xl_to_gb_point(&r->br, br) )
		return -1;
	return 0;
}

XL_SEXP *
gb_rect_to_xl(GB_RECT *r)
{
	return List(gb_point_to_xl(&r->tl), gb_point_to_xl(&r->br), -1);
}
