/**********************************************************************
 
	Copyright (C) 2006 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"utils.h"

CODEHASH_ENTRY **
_search_codehash(CODEHASH * ch,int rev,int forward,int flags);

void
init_codehash(CODEHASH * ch)
{
	if ( ch->forward == 0 ) {
		ch->forward = (*ch->alloc_func)(sizeof(CODEHASH_ENTRY*)*ch->keylen);
		memset(ch->forward,0,sizeof(CODEHASH_ENTRY*)*ch->keylen);
	}
	if ( ch->reverse == 0 ) {
		ch->reverse = (*ch->alloc_func)(sizeof(CODEHASH_ENTRY*)*ch->keylen);
		memset(ch->reverse,0,sizeof(CODEHASH_ENTRY*)*ch->keylen);
	}
}

void
insert_codehash(CODEHASH * ch,int rev,int forward,int flags)
{
CODEHASH_ENTRY * e,**ep;
unsigned int key;

	init_codehash(ch);
	if ( (flags & CH_FORWARD) == 0 ) {
	retry1:
		ch->gen_forward ++;
		if ( ch->gen_forward < 0 )
			ch->gen_forward = 1;
		ep = _search_codehash(ch,0,ch->gen_forward,CH_FORWARD);
		if ( ep )
			goto retry1;

		forward = ch->gen_forward;
		
	}
	if ( (flags & CH_REVERSE) == 0 ) {
	retry2:
		ch->gen_reverse ++;
		if ( ch->gen_reverse < 0 )
			ch->gen_reverse = 1;
		ep = _search_codehash(ch,ch->gen_reverse,0,CH_REVERSE);
		if ( ep )
			goto retry2;
		rev = ch->gen_reverse;
	}
	e = (*ch->alloc_func)(sizeof(*e));
	e->forward = forward;
	e->reverse = rev;
	key = ((unsigned int)forward)%ch->keylen;
	e->forward_next = ch->forward[key];
	ch->forward[key] = e;
	
	key = ((unsigned int)rev)%ch->keylen;
	e->reverse_next = ch->reverse[key];
	ch->reverse[key] = e;
}

CODEHASH_ENTRY **
_search_codehash(CODEHASH * ch,int rev,int forward,int flags)
{
CODEHASH_ENTRY ** ep;
unsigned int key;

	init_codehash(ch);
	if ( flags & CH_FORWARD ) {
		key = ((unsigned int)forward)%ch->keylen;
		ep = &ch->forward[key];
		for ( ; *ep ; ep = &(*ep)->forward_next ) {
			if ( (*ep)->forward == forward ) {
				return ep;
			}
		}
		return 0;
	}
	else {
		key = ((unsigned int)rev)%ch->keylen;
		ep = &ch->reverse[key];
		for ( ; *ep ; ep = &(*ep)->reverse_next ) {
			if ( (*ep)->reverse == rev ) {
				return ep;
			}
		}
		return 0;
	}
}

CODEHASH_ENTRY *
search_codehash(CODEHASH * ch,int rev,int forward,int flags)
{
CODEHASH_ENTRY ** ep;
	ep = _search_codehash(ch,rev,forward,flags);
	if ( ep == 0 )
		return 0;
	return *ep;
}


void
delete_codehash(CODEHASH * ch,int rev,int forward,int flags)
{
CODEHASH_ENTRY ** ep,*e;
	ep = _search_codehash(ch,rev,forward,flags);
	if ( ep == 0 )
		return;
	if ( flags & CH_FORWARD ) {
		e = *ep;
		*ep = e->forward_next;
		ep = _search_codehash(ch,e->reverse,e->forward,CH_REVERSE);
		if ( ep == 0 || *ep != e )
			er_panic("delete_codehash");
		*ep = e->reverse_next;
		(*ch->free_func)(e);
	}
	else {
		e = *ep;
		*ep = e->reverse_next;
		ep = _search_codehash(ch,e->reverse,e->forward,CH_FORWARD);
		if ( ep == 0 || *ep != e )
			er_panic("delete_codehash");
		*ep = e->forward_next;
		(*ch->free_func)(e);
	}
}



