/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"machine/include.h"
#include 	"r64.h"
#include	"change_endian.h"

int
main(int argc,char ** argv)
{
R64_FILE * r64;
CR_FILE * cr;
int max_level;
	check_endian(); 
	r64 = 0;
	cr = 0;
	if ( argc < 2 ) {
		fprintf(stderr,"too few argments\n");
		exit(1);
	}
	r64 = r64_open_file(
		argv[1],
		O_RDONLY,
		0666,
		'P',0,0);
	if ( r64 ) {
		printf("%c %idot %idot ",
			r64->header.type,
			r64->header.width,
			r64->header.height);
		max_level = 0;
		for ( ; r64_check_level(r64,max_level) ; max_level ++);
		printf("%i\n",max_level);
		exit(0);
	}
	cr = cr_open_file(
		argv[1],
		O_RDONLY,
		0666,
		256,0,0);
	if ( cr == 0 ) {
		fprintf(stderr,"cannot open the file %s %i\n",
			argv[1],r64_error);
		perror("");
		exit(1);
	}
	printf("%i %idot %idot ",
		cr->header.rect_size,
		cr->header.h.width,
		cr->header.h.height);
	max_level = 0;
	for ( ; cr_check_level(cr,max_level) ; max_level ++);
	printf("%i\n",max_level);
	exit(0);

	return 0;
}
