/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_table.h"
#include "vpf_file.h"
#include "vpf_util.h"
#include "vpf_init.h"

int vpf_col_read(VPF_COL *col, FILE *fp){
char *buff;
 
	readToNextSeparator(fp , col->name , '=', 16);
	col->data_type=fgetc(fp);
	fgetc(fp);
	readToNextSeparator(fp , col->number , ',', 3);
	col->key_type=fgetc(fp);
	fgetc(fp);
	
	// col->column_description=malloc(1024);
	buff = calloc(0xffff,1);
	if(readToNextSeparator(fp , buff , ',', 0xffff)<0xffff){
		col->column_description = (char *)malloc(strlen(buff)+1);
		strcpy(col->column_description, buff);
		free(buff);
	}
	else{
		printf("error: column_description is too long %s\n", col->name);
		free(buff);
		return FALSE;
	}
	

	readToNextSeparator(fp , col->value_description_table_name, ',', 12);
	readToNextSeparator(fp , col->themantic_index , ',', 12);
	readToNextSeparator(fp , col->narrative_table_name , ',', 12);
	
	fgetc(fp);
	return TRUE;
}

int vpf_read_cols(FILE *fp, VPF_LIST *cols){
	VPF_COL *col;
	while(fgetc(fp) != ';'){
		fseek(fp , -1 , SEEK_CUR);
		col = vpf_col_new();
		vpf_col_read(col,fp);
		vpf_list_push(cols, col);
	}
	return TRUE;
}

VPF_TABLE_HEADER *vpf_table_header_new(){
	return calloc(sizeof(VPF_TABLE_HEADER),1);
}

int vpf_table_header_read(VPF_TABLE_HEADER *header, FILE *fp){
	if(!fp) return FALSE;
	fread(&(header->header_length) , sizeof(header->header_length) , 1 , fp);
	header->byte_order=fgetc(fp);
	fgetc(fp);
	
	readToNextSeparator(fp , header->table_description , ';', 80);
	readToNextSeparator(fp , header->narrative_table , ';', 12);
	
	header->columns = vpf_list_new((vpf_list_data_destructor_type)vpf_col_delete);
	vpf_read_cols(fp, header->columns);
//	header->columns = getColumnInfoArray(fp);
	return vpf_list_size(header->columns);
}

void vpf_table_header_delete(VPF_TABLE_HEADER *header)
{
	if(header==NULL)
		return;
	vpf_list_delete(header->columns);
	free(header);
}

VPF_COL *vpf_col_new(){
	return (VPF_COL *)calloc(sizeof(VPF_COL),1);
}

void vpf_col_delete(VPF_COL *col){
	free(col->column_description);
	free(col);
}

BOOL is_variable_length_record(VPF_TABLE *table)
{
	switch(table->type){
		case VTT_EDGE:
			return TRUE;
		default:
			return FALSE;
	}
}

VPF_TABLE *vpf_table_new(VPF_TABLE_TYPE type){
	VPF_TABLE *tbl;
	tbl = (VPF_TABLE*)(calloc(sizeof(VPF_TABLE),1));
	tbl->type = type;
	tbl->f = get_table_funcs(type);
	if(tbl->f==NULL){
		free(tbl);
		return NULL;
	}
	return tbl;
}

void vpf_table_delete(VPF_TABLE *table){
/*
VPF_LIST_ITEM *it;
VPF_COL *col;
	for(it=table->header->columns->head; it; ++it){
		col = (VPF_COL*)(it->data);
		if(col->data_type == 'T'){
			col->
		}
	}
*/
	if(table==NULL)
		return;
	vpf_table_header_delete(table->header);
	vpf_list_delete(table->records);
	free(table);
}


