/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_file.h"
#include "vpf_geographic_reference_table.h"

void geographic_reference_record_delete(GEOGRAPHIC_REFERENCE_RECORD *tbl){
	free(tbl);
}

VPF_RECORD_READER_BEGIN(
	geographic_reference_record_read, 
	GEOGRAPHIC_REFERENCE_RECORD)
	VPF_READ_FIELD(id)
	VPF_READ_FIELD(data_type)
	VPF_READ_FIELD(units)
	VPF_READ_FIELD(ellipsoid_name)
	VPF_READ_FIELD(ellipsoid_detail)
	VPF_READ_FIELD(vert_datum_name)
	VPF_READ_FIELD(vert_datum_code)
	VPF_READ_FIELD(sound_datum_name)
	VPF_READ_FIELD(sound_datum_code)
	VPF_READ_FIELD(geo_datum_name)
	VPF_READ_FIELD(geo_datum_code)
	VPF_READ_FIELD(projection_name)
	VPF_READ_FIELD(projection_code)
	VPF_READ_FIELD(parameter1)
	VPF_READ_FIELD(parameter2)
	VPF_READ_FIELD(parameter3)
	VPF_READ_FIELD(parameter4)
	VPF_READ_FIELD(false_origin_x)
	VPF_READ_FIELD(false_origin_y)
	VPF_READ_FIELD(false_origin_z)
	VPF_READ_FIELD(reg_pt_table)
	VPF_READ_FIELD(diag_pt_table)
VPF_RECORD_READER_END()
