/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_SCROLL_VIEW_H___
#define ___V_SCROLL_VIEW_H___

#include "v/VObject.h"


class VScrollView : public VObject
{
  public:
	enum { object_type = VO_SCRV };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return 1; }
	
	enum VScrollViewAttr {
		h_always = 0x0,
		h_automatic = 0x1,
		h_never = 0x2,
		
		v_always = 0x00,
		v_automatic = 0x10,
		v_never = 0x020
	};
	
	static VScrollView*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VScrollView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VScrollView*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);
	
	virtual void	redraw(VRect* rect = 0) const;
	
	VSize			get_internal_size() { return internal_size; }
	virtual VSize	get_internal_size_cur();
	virtual void	set_internal_size(const VSize size);

	virtual VExError add_child_do(VObject* child);
	virtual void	remove_child_do(VObject* child);

  protected:
	virtual ~VScrollView();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
				VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	
	VSize 			internal_size;
	VSize 			internal_size_cur;

  public:	// for VLayout
	virtual void	set_internal_size_do(const VSize size);

  private:
	static VObject *internal_new(){
		return new VScrollView();
	}
};

#endif
