/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_MACRO_H___
#define ___V_MACRO_H___

#include	"v/VObject.h"
#include	"v/VClipboard.h"
#include	"v/VBackColorView.h"

class VMacro : public VObject
{
  public:
	enum { object_type = VO_MACR };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return 1; }
	virtual VObject *	macro_base_parent() { return this; }
		
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	virtual VObject *
				get_backcolorview(VObjectStatus *,int);
	
//	virtual void	redraw(VRect* rect = 0) const;

	// XL gc processing if using XL_SEXP in VObject
	//	defined by each VMacro Object
	virtual	void gc();

  protected:
  	VMacro();
  	virtual ~VMacro();

	// VMacro specific lock system
	static void vm_lock(VMacro*m,char*f,int ln) { m->_vm_lock(f,ln); } 
	static void vm_unlock(VMacro*m) { m->_vm_unlock(); };
	void _vm_lock(char*f,int ln);
	void _vm_unlock();

	// XL gc processing if using XL_SEXP in VObject
	void insert_gc();
	void delete_gc();

	struct VMacroGCNode * gc_node;

	int inherit_child_flags;

  private:
	int vmacro_lock_cnt;
	char *vmacro_lock_file;
	int vmacro_lock_line;
	int vmacro_task;
	int vm_lock_pri;
};

/*
#define _VM_OP_START(err) \
	vm_lock((VMacro*)(this),__FILE__,__LINE__);	\
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
		unlock(this);	\
		vm_unlock((VMacro*)this);	\
		return err;		\
	}				\
	unlock(this);

#define VM_OP_START _VM_OP_START(V_ER_DESTROYED)

#define _VM_OP_START_VOID	\
	vm_lock((VMacro*)(this),__FILE__,__LINE__);	\
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
		unlock(this);	\
		vm_unlock((VMacro*)this);	\
		return ;		\
	}				\
	unlock(this);


#define _VM_OP_START_EX(c) \
	vm_lock((VMacro*)(this),__FILE__,__LINE__);	\
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
	VExError er;				\
		er.code = c;			\
		er.subcode1 = 0;		\
		er.subcode2 = 0;		\
		unlock(this);	\
		vm_unlock((VMacro*)this);	\
		return er;		\
	}				\
	unlock(this);			\

#define _VM_OP_START_ZERO \
	vm_lock((VMacro*)(this),__FILE__,__LINE__);	\
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
		unlock(this);	\
		vm_unlock((VMacro*)this);	\
		return 0;		\
	}				\
	unlock(this);			\

#define VM_OP_START_EX _VM_OP_START_EX(V_ER_DESTROYED)

#define VM_OP_END	\
	vm_unlock((VMacro*)this);
*/

#define _VM_OP_START(err) _V_OP_START(err)
#define VM_OP_START	V_OP_START
#define _VM_OP_START_VOID	_V_OP_START_VOID
#define _VM_OP_START_EX(c) V_OP_START_EX
#define _VM_OP_START_ZERO _V_OP_START(0)
#define VM_OP_START_EX V_OP_START_EX
#define VM_OP_END	V_OP_END



// ===================================
// CLIPBOARD FOR XL



extern VIM VIM_VdataXL;


class VdataXL : public VdataLString
{
  public:

	VdataXL(const L_CHAR *str,int * erp=0,bool valid=1);
	VdataXL(const char *str,int * erp=0,bool valid=1);
	VdataXL(const XL_SEXP * s,int * erp=0,bool valid=1);
	VdataXL(Vdata * d,int * erp=0,bool valid=1);
	virtual ~VdataXL();

	static bool clipboard_available(bool lock_flag=1);
	static VdataXL * new_from_clipboard();

	virtual char * get_VdataString(int * erp=0);
	virtual L_CHAR * get_VdataLString(int * erp=0);
	virtual XL_SEXP * get_VdataXL(int * erp=0);
  protected:
};


#endif

