/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VButton.h"
#include "VApplication.h"
#include "vobject_main.h"


HWND CreateButtonWindow(int exStyle, int style, HWND hwnd, int id);

VExError 
VCheckBox::create_do(const VObjectStatus* s, int flags, VObject *parent, void * arg)
{
	
	DWORD style=WS_CHILD | BS_AUTOCHECKBOX | WS_TABSTOP;
	if(!s->enabled){
		style |= WS_DISABLED;
	}
	if(s->visible){
		style |= WS_VISIBLE;
	}
	
	/* find container window that will own this button.*/
	VContainerInfo *container_info = VInfo::get_container_info(parent);
	int id = container_info->get_next_control_id();
	HWND hwnd = v_serialized_exec_func(CreateButtonWindow, 0, style, container_info->get_hwnd(), id);
	info = new VInfo(this, hwnd, id);
	
	/* set event handlers */
	info->add_message_handler(new OnCommand(::value_changed));
	
	return parent->add_child_do(this);
}

void
VCheckBox::destroy_do(VObject *parent)
{
	VButton::destroy_do(parent);
}

VCheckBox::~VCheckBox()
{
}

VExError
VCheckBox::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,flags,0);

	if ( flags & VSF_VALUE ) {
		s->value = v_serialized_exec_func(_SendMessage,
			info->get_hwnd(), BM_GETCHECK , 0 , 0);
		flags &= ~VSF_VALUE;
	}

	VExError err2 = VButton::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	V_OP_END
	return err;
};

VExError
VCheckBox::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VSize last_size = sts.min_size;
	VExError err = VButton::set_status(s,flags);

	if ( flags & VSF_VALUE ) {
		v_serialized_exec_sub(SendMessage,
			info->get_hwnd(), BM_SETCHECK, s->value ? BST_CHECKED : BST_UNCHECKED, 0);
		flags &= ~VSF_VALUE;
	}

	if ( flags & (VSF_DESC | VSF_VERTD) ) {
		sts.min_size.w += 16;
	}
	
	V_OP_END
	
	if ( (flags & (VSF_ALIGN | VSF_PADDING | VSF_VISIBLE)) ||
		 (flags & (VSF_DESC | VSF_WS | VSF_FSIZE)) &&
			(sts.min_size.w != last_size.w ||
			 sts.min_size.h != last_size.h) )
		VLayout::mark(this);
	return err;
}
