
/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<string.h>

#include	"v_pango.h"
#include	"v/v_serialized_exec.h"

extern "C" {

#include	"memory_debug.h"
#include	"utils.h"
#include	"lc_encode.h"

int v_pango_new(LC_FONT *,LC_FONT_ENGINE*);
int v_pango_coverage(LC_FONT *,int,L_CHAR);

void _insert_lc_font_size_list(LC_FONT * f,LC_FONT_SIZE_LIST * sl);
int insert_font_work(LC_FONT * f,LC_FONT_ENGINE * fe,void * work);

LC_FONT_ENGINE_TYPE pango_font_engine_type = {
	"pango",
	v_pango_new,
	0,
	v_pango_coverage,
	{0,0},
	0
};


void
v_init_pango()
{
LC_FONT_ENGINE * fe;

	fe = (LC_FONT_ENGINE*)d_alloc(sizeof(*fe));
	fe->work = (void*)gtk_window_new(GTK_WINDOW_TOPLEVEL);
	fe->type = &pango_font_engine_type;
	fe->name = "pango-font-engine";
	insert_font_engine(fe);
}


int
_v_pango_coverage(LC_FONT *f, int size, L_CHAR ch)
{
V_PANGO_FONT * vf;
V_P_COVERAGE_CACHE * pc;
int i,ret;
char * desc_buf;
PangoContext * context;
GtkWindow * w;

	for ( i = 0 ; i < f->fw_len ; i ++ )
		if ( f->fw_list[i].fe->type == 
				&pango_font_engine_type )
			break;
	if ( f->fw_len == i ) {
		return -1;
	}
	vf = (V_PANGO_FONT*)f->fw_list[i].work;
	w = (GtkWindow*)f->fw_list[i].fe->work;
	for ( pc = vf->coverage ; pc ; pc = pc->next )
		if ( pc->size == size ) {
			if ( pango_coverage_get(pc->cov,ch & 0x0ffff)
					== PANGO_COVERAGE_NONE )
				return -1;
			else	return 0;
		}
	pc = (V_P_COVERAGE_CACHE*)d_alloc(sizeof(*pc));
	pc->size = size;

	desc_buf = (char*)d_alloc(strlen(vf->fontname) + 20);
	sprintf(desc_buf,"%s %i",vf->fontname,size/10);
	pc->fd = pango_font_description_from_string(desc_buf);
	if ( pc->fd == 0 ) {
		ret = -1;
		goto end1;
	}
	context = gtk_widget_get_pango_context(GTK_WIDGET(w));
	if ( context == 0 )
		er_panic("pango");
	pc->font = pango_context_load_font(context,pc->fd);
	if ( pc->font == 0 ) {
		ret = -1;
		goto end2;
	}
	pc->cov = pango_font_get_coverage(pc->font,0);
	if ( pc->cov == 0 ) {
		ret = -1;
		goto end2;
	}
	if ( pango_coverage_get(pc->cov,ch & 0x0ffff)
			== PANGO_COVERAGE_NONE )
		ret = -1;
	else	ret = 0;
	pc->next = vf->coverage;
	vf->coverage = pc;
	return ret;
end2:
	pango_font_description_free(pc->fd);
end1:
	d_f_ree(desc_buf);
	d_f_ree(pc);
	return ret;
}

int
v_pango_coverage(LC_FONT * f,int size,L_CHAR ch)
{
	return v_serialized_exec_func(_v_pango_coverage,f,size,ch);
}



int
v_pango_new(LC_FONT * f,LC_FONT_ENGINE * fe)
{
V_PANGO_FONT * vf;
int ret;
LC_FONT_SIZE_LIST sl;
L_CHAR * ptr;
	for ( ptr = f->fontname ; *ptr ; ptr ++ )
		if ( *ptr == '*' )
			goto err;
	goto ok;
err:
	return -1;
ok:
	vf = (V_PANGO_FONT*)d_alloc(sizeof(*vf));
	vf->fontname = ln_copy_str(&utf8_cm,f->fontname);
	vf->coverage = 0;
	if ( f->mask[0] == LCZM_ALL || f->mask[0] == 0  ) {
		f->mask[0] = LCZM_2B_TYPE;
		f->lcz[0] = LCZ_2BC_UNICODE_v3_0_UN;
	}
	f->mask[1] = LCZM_ALL;
	f->lcz[1] = LCC_ERROR;
	sl.size = -1;
	sl.from = LCZ_2BC_UNICODE_v3_0_UN;
	sl.to = sl.from + 0x0ffff;
	_insert_lc_font_size_list(f,&sl);
	insert_font_work(f,fe,vf);
	ret = 0;
	return ret;
}

}
