/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <string.h>

#include "v/v_types.h"
#include "v/v_serialized_exec.h"

extern "C" {


void
v_image_new_m(VImage* img, short w, short h, char depth)
{
	img->info = v_serialized_exec_func(gdk_pixbuf_new,
		GDK_COLORSPACE_RGB,1, 8, (int)w, (int)h);
	img->buf_32 = 0;
	img->w_border = v_serialized_exec_func(gdk_pixbuf_get_rowstride, (const GdkPixbuf*)img->info)/4;
}

void
v_image_free_m(VImage* img)
{
	v_serialized_exec_sub(gdk_pixbuf_unref, img->info);
}

void
v_image_draw_start_m(VImage* img)
{
	img->buf_32 = (long*)gdk_pixbuf_get_pixels(img->info);
}

void
v_image_draw_end_m(VImage* img)
{
	img->buf_32 = 0;
}

VImage*
v_image_ref(VImage* img)
{
	extern VImage* _v_image_ref(VImage* img);
	return v_serialized_exec_func(_v_image_ref, img);
}

VImage*
v_image_unref(VImage* img)
{
	extern VImage* _v_image_unref(VImage* img);
	return v_serialized_exec_func(_v_image_unref, img);
}

bool
v_image_call_lock_m(VImage* img)
{
	extern bool v_image_lock(VImage *img);
	return v_serialized_exec_func(v_image_lock, img);
}

void 
v_image_call_unlock_m(VImage* img)
{
	extern void v_image_unlock(VImage *img);
	v_serialized_exec_sub(v_image_unlock, img);
}

} //extern "C"
