// ===========================================================================
//	CColorViewImp.h
// ===========================================================================

#ifndef _H_CColorViewImp
#define _H_CColorViewImp
#pragma once

#include <LAMControlImp.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ---------------------------------------------------------------------------

class	CColorViewImp : public LStdControlImp {
public:
						CColorViewImp( LStream* inStream = nil );

	virtual				~CColorViewImp();

	virtual void		Init(	LControlPane*	inControlPane,
								SInt16			inControlKind,
								ConstStringPtr	inTitle = Str_Empty,
								ResIDT			inTextTraitsID = 0,
								SInt32			inRefCon = 0);

	virtual bool		GetForeAndBackColors(
								RGBColor*		outForeColor,
								RGBColor*		outBackColor) const;

	bool				GetColor(RGBColor*		color) const
		{
			if (mIsColorSet) *color = mColor;
			return mIsColorSet;
		}

	void				SetColor(RGBColor*		color)
		{
			if (color) mColor = *color;
			mIsColorSet = (color != 0);
			Refresh();
		}

protected:
	static pascal void	ControlUserPaneDrawProc(
								ControlRef		control,
								ControlPartCode	part);
	static ControlUserPaneDrawUPP sDrawUPP;

	static pascal ControlPartCode	ControlUserPaneHitTestProc(
								ControlRef		control,
								Point			where);
	static ControlUserPaneHitTestUPP sHitTestUPP;

	static pascal void				ControlActionProc(
								ControlRef theControl,
								ControlPartCode partCode);
	static ControlActionUPP sActionUPP;

	bool				mIsColorSet;
	RGBColor			mColor;
};

PP_End_Namespace_PowerPlant


#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
