#! /bin/csh


setenv XLHOMEDIR /usr/local/xl-gbs
setenv SERVERPORT 8080

setenv UNAME `uname`
setenv REV `uname -r`

echo $XLHOMEDIR > xlhomedir

echo "Making Directories....."

rm -rf $XLHOMEDIR
mkdir $XLHOMEDIR
cp -rf xlscript $XLHOMEDIR/xlscript
cp -rf xlsamples $XLHOMEDIR/xlsamples
cp -rf xlconf $XLHOMEDIR/xlconf


mkdir $XLHOMEDIR/xldocs
mkdir $XLHOMEDIR/xlsys
mkdir $XLHOMEDIR/xlwork
mkdir $XLHOMEDIR/xlwork/lump
mkdir $XLHOMEDIR/xlopt
mkdir $XLHOMEDIR/xlopt/ftfont
mkdir $XLHOMEDIR/xllog
mkdir $XLHOMEDIR/tmp

pushd $XLHOMEDIR/xlscript/bin

chmod 0755 *
popd

cd $XLHOMEDIR/tmp

echo "Basic Agent Configulation ...."

pushd $XLHOMEDIR/xlconf/std
$XLHOMEDIR/xlscript/bin/replace agent.xl ++XLHOMEDIR++ $XLHOMEDIR
$XLHOMEDIR/xlscript/bin/replace agent.xl ++SERVERPORT++ $SERVERPORT
popd

echo Making .xlrc .....

cp -f $XLHOMEDIR/xlscript/init/xlrc xlrc
$XLHOMEDIR/xlscript/bin/replace xlrc ++XLHOMEDIR++ $XLHOMEDIR
rm -f /.xlrc
cp -f xlrc /.xlrc

echo Making launch script for $UNAME .....



switch ($UNAME)
case Linux:
case linux:
    setenv RET `$XLHOMEDIR/xlscript/bin/replace -cmp $REV 2.6`
    switch ($RET)
    case large:
	setenv UNAME linux-old
	breaksw
    case small:
    case equ:
	setenv UNAME linux-new
	breaksw
    endsw
    breaksw
endsw

echo $UNAME

switch ($UNAME)
case SunOS:

    cp -f ../xlscript/init/launch-xl.$UNAME launch-xl
    $XLHOMEDIR/xlscript/bin/replace launch-xl ++XLHOMEDIR++ $XLHOMEDIR

    cp -f launch-xl /etc/init.d
    chmod 0755 /etc/init.d/launch-xl
    cp -f launch-xl /etc/rc3.d/S91xl
    chmod 0755 /etc/rc3.d/S91xl


    echo Making font table for gbview .....

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index -d `find /usr -name fonts.dir -print`

    breaksw
case linux-old:
     cp -f ../xlscript/init/launch-xl.linux launch-xl
    $XLHOMEDIR/xlscript/bin/replace launch-xl ++XLHOMEDIR++ $XLHOMEDIR

    cp -f launch-xl /etc/init.d
    chmod 0755 /etc/init.d/launch-xl

    /sbin/chkconfig --add launch-xl

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index -d `find /usr -name fonts.dir -print`

   breaksw

case linux-new:
     cp -f ../xlscript/init/launch-xl.linux launch-xl
    $XLHOMEDIR/xlscript/bin/replace launch-xl ++XLHOMEDIR++ $XLHOMEDIR

    rm -f /etc/rc.d/init.d/launch-xl
    cp -f launch-xl /etc/rc.d/init.d
    chmod 0755 /etc/rc.d/init.d/launch-xl

    /sbin/chkconfig --add launch-xl

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index -d `find /usr -name fonts.dir -print`

   breaksw

case Darwin:

    cp -rf ../xlscript/init/$UNAME d
    $XLHOMEDIR/xlscript/bin/replace d/XLServer ++XLHOMEDIR++ $XLHOMEDIR

    mkdir /Library/StartupItems
    setenv D_ST /Library/StartupItems
    setenv D_TARGET $D_ST/XLServer
    rm -rf $D_TARGET
    cp -rf d $D_TARGET
    chmod 0755 $D_TARGET/XLServer

    $XLHOMEDIR/xlscript/bin/replace -switch-add2 /etc/hostconfig XLSERVER=-NO- XLSERVER=-YES-

    echo Making font table for gbview .....

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index /Library/Fonts /System/Library/Fonts

    breaksw
case FreeBSD:

    cp -f ../xlscript/init/launch-xl.$UNAME launch-xl
    $XLHOMEDIR/xlscript/bin/replace launch-xl ++XLHOMEDIR++ $XLHOMEDIR

    cp -f launch-xl /etc/init.d
    chmod 0755 /etc/init.d/launch-xl
    cp -f launch-xl /usr/local/etc/rc.d/launch-xl
    chmod 0755 /usr/local/etc/rc.d/launch-xl


    echo Making font table for gbview .....

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index -d `find /usr -name fonts.dir -print`

    breaksw
endsw

cd $XLHOMEDIR
rm -rf tmp


echo Successfly Finish Install




