/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_routine.h"
#include	"memory_debug.h"
#include	"mlong_char.h"
#include	"xl.h"
#include	"xlerror.h"

XL_SEXP *
quote_trace(XLISP_ENV * env,XL_SEXP * s);

XL_SEXP *
quote_trace_pair(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * r, * r1;
	r = car(s);
	switch ( get_type(r) ) {
	case XLT_ERROR:
		return r;
	case XLT_SYMBOL:
		break;
	default:
		goto non_eval;
	}
	if ( l_strcmp(r->symbol.data,l_string(std_cm,"$")) )
		goto non_eval;
	if ( list_length(s) != 2 )
		goto non_eval;
	return eval(env,get_el(s,1));
non_eval:
	r = 0;
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		r1 = car(s);
		if ( get_type(r1) == XLT_ERROR )
			return r1;
		r1 = quote_trace(env,r1);
		if ( get_type(r1) == XLT_ERROR )
			return r1;
		r = cons(r1,r);
	}
	r1 = s;
	for ( ; get_type(r) ; r = cdr(r) )
		r1 = cons(car(r),r1);
	return r1;
}

XL_SEXP *
quote_trace_symbol(XLISP_ENV * env,XL_SEXP * s)
{
XL_SYM_FIELD * sf, ** sfp;
XL_SYM_FIELD * sf2, * sf3;
int f;
char * buf;
XL_SEXP * dd;
void gc_gb_sym_field();
	f = 0;
	for ( sf = s->symbol.field ; sf ; sf = sf->next )
		if ( sf->data[0] == '$' ) {
			f = 1;
			break;
		}
	if ( f == 0 )
		return s;
	sf = s->symbol.field;
	sf2 = 0;
	sfp = &sf2;
	for ( ; sf ; sf = sf->next ) {
		sf3 = mmalloc(sizeof(*sf3),gc_gb_sym_field);
		sf3->next = 0;
		sf3->name = sf->name;
		if ( sf->data[0] == '$' ) {
			dd = eval(env,get_symbol(&sf->data[1]));
			switch ( get_type(dd) ) {
			case XLT_ERROR:
				return dd;
			case XLT_STRING:
				sf3->data = dd->string.data;
				break;
			case XLT_INTEGER:
				if ( dd->integer.unit ) {
					buf = mmalloc(50+
						l_strlen(dd->integer.unit)
						*sizeof(L_CHAR),gc_text);
					sprintf(buf,"%i%s",
						dd->integer.data,
						n_string(std_cm,
							dd->integer.unit));
				}
				else {
					buf = mmalloc(50,gc_text);
					sprintf(buf,"%i",dd->integer.data);
				}
				sf3->data = nl_copy_mstr(std_cm,buf);
				break;
			case XLT_FLOAT:
				if ( dd->integer.unit ) {
					buf = mmalloc(50+
						l_strlen(dd->floating.unit)
						*sizeof(L_CHAR),gc_text);
					sprintf(buf,"%f%s",
						dd->floating.data,
						n_string(std_cm,
							dd->floating.unit));
				}
				else {
					buf = mmalloc(50,gc_text);
					sprintf(buf,"%i",(int)dd->floating.data);
				}
				sf3->data = nl_copy_mstr(std_cm,buf);
				break;
			default:
				return get_error(
					s->h.file,
					s->h.line,
					XLE_SEMANTICS_TYPE_MISSMATCH,
					l_string(std_cm,"quote attribute $"),
					dd);
			}
		}
		else {
			sf3->data = sf->data;
		}
		*sfp = sf3;
		sfp = &sf3->next;
	}
	dd = get_symbol(s->symbol.data);
	dd->symbol.field = sf2;
	return dd;
}


XL_SEXP *
quote_trace(XLISP_ENV * env,XL_SEXP * s)
{
	switch ( get_type(s) ) {
	case XLT_ERROR:
		return s;
	case XLT_PAIR:
		return quote_trace_pair(env,s);
	case XLT_SYMBOL:
		return quote_trace_symbol(env,s);
	default:
		return s;
	}
}

XL_SEXP *
gb_quote_trace(XLISP_ENV * env,XL_SEXP * s,L_CHAR * type)
{
	if ( type == 0 )
		goto normal;
	if ( l_strcmp(type,l_string(std_cm,"direct")) == 0 )
		goto direct;
	if ( l_strcmp(type,l_string(std_cm,"normal")) == 0 )
		goto normal;
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"quote"),
		List(n_get_string("invalid type attribute"),-1));
direct:
	return s;
normal:
	return quote_trace(env,s);
}

XL_SEXP *
gb_quote_long(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * type;
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	return gb_quote_trace(env,get_el(s,1),type);
}

XL_SEXP *
gb_quote(XLISP_ENV * env,XL_SEXP * s)
{
	return gb_quote_long(env,s,0,0);
}

