/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <stdlib.h>

#include "v/VSlider.h"
#include "v/vobj_utils.h"

extern "C" {
#include "xl.h"

XL_SEXP *
vobj_VSlider(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);

XL_SEXP *
vobj_VSlider(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
	L_CHAR *l_min  = get_sf_attribute(sf, l_string(std_cm, "min"));
	L_CHAR *l_max  = get_sf_attribute(sf, l_string(std_cm, "max"));
	L_CHAR *l_step = get_sf_attribute(sf, l_string(std_cm, "step"));
	if ( !( l_min && l_max && l_step ) )
		return vobj_get_error(initial_VExError(V_ER_PARAM,0,0), arg);
	int min  = atoi(n_string(std_cm, l_min));
	int max  = atoi(n_string(std_cm, l_max));
	int step = atoi(n_string(std_cm, l_step));
	
	VObjectStatus sts;
	VObject::FreeList *free_list;
	int flags = get_sts_from_sf(env,&sts,0, sf, &free_list);
	VExError err;
	
	XL_SEXP *p = eval(env, n_get_symbol("__parent"));
	if ( get_type(p) == XLT_ERROR )
		return p;
	if ( get_type(p) != XLT_INTEGER )
		return vobj_get_error(initial_VExError(V_ER_PARENT,0,0), arg);
	VObject *parent = VObject::get_object_by_id(p->integer.data);
	
	sts.parent = parent;
	flags |= VSF_PARENT;
	
	VSlider *obj = VSlider::create(&sts, flags, min, max, step, &err);
	if ( err.code != V_ER_NO_ERR )
		return vobj_get_error(err, arg);
	obj->free_on_release_list(free_list);
	obj->get_status(&sts, VSF_ID);
	return vobj_get_id_list(sts.id, 0, sf,0);
}

void
init_VSlider(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VSlider"),
		get_func_prim((XL_SEXP*(*)())vobj_VSlider,FO_NORMAL,0,1,1));
}


} // extern "C"
