/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"utils.h"
#include	"lock_level.h"
#include	"pri_level.h"




unsigned int _start_time;
int _force_limit;
int _limit;
int (*_sync_func)();
void timeout_exit_task();
void exit_tick();


void
timeout_exit_task()
{
int t;
	t = get_xltime() - _start_time;
	if ( t < _limit )
		sleep_sec(_limit - t);
	if ( _sync_func ) {
		for ( ; get_xltime() - _start_time
				< _force_limit; ) {
			if ( (*_sync_func)() == 0 )
				break;
			sleep_sec(1);
		}
	}
	exit_stabilizer('r');
	exit(0);
}

void
exit_tick()
{
	create_task(timeout_exit_task,0,0);
}

void
timeout_exit(int limit,int force_limit,int (*sync_func)())
{
	_start_time = get_xltime();
	_limit = limit;
	_force_limit = force_limit;
	_sync_func = sync_func;
	new_tick(exit_tick,-limit*0.9,0);
}

