/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<errno.h>
#include	"memory_debug.h"
#include	"task.h"
#include	"netutils.h"
#include	"utils.h"
#include	"resolve.h"


int
localhostcmp(HOST_ADDR ip,char * h)
{
HOST_ADDR lip;
char * bf;
int ret;
	lip.d.v4 = get_localhostip();
	lip.type = HAT_V4;
	lip.size = 4;
	bf = d_alloc(1000);
	get_localhostname(bf);
	if ( cmp_HA(ip,lip) == 0 && strcmp(bf,h) == 0 )
		ret = 0;
	else	ret = 1;
	d_f_ree(bf);
	return ret;
}

int
hostcmp(char * h1,HOST_ADDR ip1,char * h2,HOST_ADDR ip2)
{
int ret;
int i,j;
HOST_ENTRY * he, * he1, * he2;

	if ( h1 == 0 && h2 == 0 ) {
		if ( cmp_HA(ip1,ip2) == 0 )
			ret = 0;
		else	ret = 1;
	}
	else if ( h1 == 0 ) {
		ret = localhostcmp(ip1,h2);
		if ( ret == 0 )
			goto end;
		he = r_gethostbyname(h2);
		if ( he == 0 ) {
			ret = -1;
			goto end;
		}
		for ( i = 0 ; i < he->ips_length ; i ++ )
			if ( cmp_HA(ip1,he->ips[i]) == 0 ) {
				ret = 0;
				goto end;
			}
		ret = 1;
		goto end;
	}
	else if ( h2 == 0 ) {
		ret = localhostcmp(ip2,h1);
		if ( ret == 0 )
			goto end;
		he = r_gethostbyname(h1);
		if ( he == 0 ) {
			ret = -1;
			goto end;
		}
		for ( i = 0 ; i < he->ips_length ; i ++ )
			if ( cmp_HA(ip2,he->ips[i]) == 0 ) {
				ret = 0;
				goto end;
			}
		ret = 1;
		goto end;
	}
	else {
		if ( strcmp(h1,h2) == 0 ) {
			ret = 0;
			goto end;
		}
		he1 = r_gethostbyname(h1);
		he2 = r_gethostbyname(h2);
		if ( he1 == 0 || he2 == 0 ) {
			ret = -1;
			goto end;
		}
		for ( i = 0 ; i < he1->ips_length ; i ++ )
			for ( j = 0 ; j < he2->ips_length ; j ++ )
				if ( cmp_HA(he1->ips[i],he2->ips[j])
						== 0 ) {
					ret = 0;
					goto end;
				}
		ret = 1;
		goto end;
	}
end:
	return ret;
}
