#include "ossl.h"
#include "openssl/rand.h"
#include <string.h>

#ifndef GBSSL_TEST
#include "init.h"
#endif

int gbrsa_test_main()
{
#define KEY_BIT_LENGTH 1024

	/* open ssl test code */
	unsigned char test_plain_text[] = "aiueo kakikukeko sasisuseso tachituteto aaaaaaaaa b";
	unsigned char decrypted_buff[256];
	int crypted_data_size;
	RSA *rsa;
	int encodable_length;
	unsigned char *crypted;
	int crypted_len;
	int decrypted_len;

	oSSL_init();
	oSSL_RSA_init();

	encodable_length = 64-11;
	
	rsa = RSA_generate_key(KEY_BIT_LENGTH, RSA_F4, NULL, NULL);
	
	crypted_data_size = RSA_size(rsa);
	crypted = (unsigned char*)malloc(crypted_data_size);

	crypted_len = RSA_private_encrypt(
			sizeof(test_plain_text), 
			(unsigned char*)test_plain_text, 
			crypted,
			rsa,
			RSA_PKCS1_PADDING);
	
	decrypted_len = RSA_public_decrypt(
		crypted_len,
		crypted,
		decrypted_buff,
		rsa,
		RSA_PKCS1_PADDING);
	
	if(memcmp(test_plain_text, decrypted_buff, sizeof(test_plain_text)) == 0){
		printf("RSA openssl lib ok\n");
	}
	else{
		printf("RSA openssl lib err\n");
		exit(-1);
	}

	{
		RSA *r;
		int decrypted_len2;
		r = RSA_new();
		r->n = rsa->n;
		r->e = rsa->e;
		
		decrypted_len2 = RSA_public_decrypt(
			crypted_len,
			crypted,
			decrypted_buff,
			r,
			RSA_PKCS1_PADDING);
		
		r->n=NULL;
		r->e=NULL;
		RSA_free(r);
	}
	RSA_free(rsa);

	/* gbs RSA test code */
	{
		oSSL_object *public_key;
		oSSL_object *private_key;
		oSSL_data *encoded;
		oSSL_data *org;
		oSSL_data *decoded;
		
		oSSL_data *private_key_data;
		oSSL_object *private_key_loaded;

		if(oSSL_RSA_genkey(&public_key, &private_key, 1024) == -1){
			printf("err 1");
		}
		
		private_key_data = oSSL_object2data(private_key, OSSL_DATA_FORMAT_DER);
		private_key_loaded = oSSL_data2object(private_key_data, OSSL_DATA_FORMAT_DER);
		
		org = oSSL_data_new(OSSL_RAW, (unsigned char*)"hogehogefoobar abcdefghijklmn", strlen("hogehogefoobar abcdefghijklmn")+1, FALSE, 0);
		encoded = oSSL_RSA_encode(public_key, org);
		if(encoded == 0){
			printf("err 2");
		}
		
		oSSL_object_free(public_key);
		
		decoded = oSSL_RSA_decode(private_key_loaded, encoded);
		if(decoded == 0){
			printf("err 3");
		}
		
		oSSL_object_free(private_key);
		oSSL_data_free(encoded);
		
		if(memcmp(decoded->data, org->data, org->len) == 0){
			printf("gbrsa ok\n");
		}
		else{
			printf("gbrsa error\n");
		}
		printf("test decoded data = %s\n", decoded->data);

		oSSL_data_free(decoded);
		oSSL_data_free(org);
	}
	oSSL_close();
	return 0;
}

int gbrc4_test_main()
{
	int result;
	oSSL_object *encode_key;
	oSSL_data *encode_key_data;
	oSSL_object *decode_key;
	oSSL_data key_data;
	
	oSSL_init();
	oSSL_RC4_init();

	{
		/* generate random key */
		key_data.len = 128;
		key_data.data = d_alloc(key_data.len);
		RAND_bytes(key_data.data, key_data.len);
		
		/* make key object */
		encode_key = oSSL_RC4_genkey(&key_data);
		if(encode_key==0){
			printf("error oSSL_RC4_genkey 1\n");
			exit(-1);
		}
		
		encode_key_data = oSSL_object2data(encode_key, OSSL_DATA_FORMAT_DER);
		oSSL_object_free(encode_key);
		encode_key = oSSL_data2object(encode_key_data, OSSL_DATA_FORMAT_DER);

		decode_key = oSSL_RC4_genkey(&key_data);
		if(decode_key==0){
			printf("error oSSL_RC4_genkey 2\n");
			exit(-1);
		}
		d_f_ree(key_data.data);
	}
	
	{
		oSSL_data *encoded_data;
		oSSL_data *decoded_data;
		oSSL_data *org_data;
		org_data = oSSL_data_new(OSSL_RAW, (unsigned char*)"test abcdefg", strlen("test abcdefg")+1, FALSE, 0);
		encoded_data = oSSL_data_new(OSSL_RAW, NULL, 0, TRUE, 0);
		
		/*
		oSSL_data *oSSL_object2data(oSSL_object * obj, int convert_type);
		oSSL_object *oSSL_data2object(oSSL_data * data, int convert_type);
		*/

		/* encode */
		result = oSSL_RC4_encode(encoded_data, encode_key, org_data);
		oSSL_object_free(encode_key);
		if(result < 0){
			printf("error oSSL_RC4_encode \n");
			exit(-1);
		}
		
		decoded_data = oSSL_data_new(OSSL_RAW, NULL, 0, TRUE, 0);
		/* decode */
		result = oSSL_RC4_decode(decoded_data, decode_key, encoded_data);
		oSSL_object_free(decode_key);
		oSSL_data_free(encoded_data);
		if(result < 0){
			printf("error oSSL_RC4_decode \n");
			exit(-1);
		}
		
		if(memcmp(org_data->data, decoded_data->data, org_data->len) == 0){
			printf("gbrc4 ok\n");
		}
		else{
			printf("gbrc4 error\n");
		}
		
		oSSL_data_free(decoded_data);
		oSSL_data_free(org_data);
	}

	oSSL_close();
	return 0;
}

#ifndef GBSSL_TEST
void init_gb(){
	init_task(INI_DONTWAITCHI);
	init_tick();
	init_d_alloc();
	init_longchar();
	init_stream();
	init_utils();
	init_resolve();
}
#else
void init_gb(){
}
#endif

int main(int argc, char* argv[])
{
	init_gb();
	gbrsa_test_main();
	gbrc4_test_main();
	return 0;
}
