#include "ossl.h"


SEM *oss_lock_ary;

oSSL_method *oSSL_types[MAX_OSSL_OBJECT_TYPE];

oSSL_object *oSSL_object_new(int type, oSSL_method *method)
{
	oSSL_object *obj;
	obj = d_alloc(sizeof(oSSL_object));
	obj->type = type;
	obj->method = method;
	return obj;
}

void oSSL_object_free(oSSL_object * obj)
{
	if(obj && obj->method){
		obj->method->free(obj);
	}
	obj->method = 0;
	free(obj);
}

oSSL_data *oSSL_data_new(int type, unsigned char *data, int len, int own_data, int buff_size)
{
	oSSL_data *ret;
	ret = d_alloc(sizeof(oSSL_data));
	ret->type = type;
	ret->data = data;
	ret->len = len;
	ret->own_data = own_data;
	ret->buff_size = buff_size;
	return ret;
}

void
oSSL_data_free(oSSL_data * d)
{
	if(d->len){
		if(d->own_data){
			if(d->data)
				d_f_ree(d->data);
		}
		d->len = 0;
	}
	if(d)
		d_f_ree(d);
}

void oSSL_data_ensure_buff_size(oSSL_data *data, int size){
	if(data->data == NULL || data->buff_size < size){
		if(data->own_data && data->data){
			d_f_ree(data->data);
		}
		data->buff_size = size;
		data->data = d_alloc(size);
		data->len = size;
		data->own_data = TRUE;
	}
}

static void oSSL_lock_func(int mode, int index, const char* file, int line)
{
	if(mode & CRYPTO_LOCK){
		lock_task(oss_lock_ary[index]);
	}
	else{
		unlock_task(oss_lock_ary[index], "oSSL_lock_func");
	}
}

static unsigned long oSSL_get_thread_id(void)
{
	return (unsigned long)get_tid();
}

void oSSL_init()
{
	int i;
	
	oss_lock_ary = d_alloc(CRYPTO_NUM_LOCKS*sizeof(SEM));

	for(i=0; i<CRYPTO_NUM_LOCKS; ++i){
		oss_lock_ary[i] = new_lock(LL_OSSL);
	}
	CRYPTO_set_id_callback(oSSL_get_thread_id);
	CRYPTO_set_locking_callback(oSSL_lock_func);

}

void oSSL_close()
{
	int i;
	CRYPTO_set_id_callback(0);
	CRYPTO_set_locking_callback(0);
	for(i=0; i<CRYPTO_NUM_LOCKS; ++i){
		close_lock(oss_lock_ary[i]);
	}
	if(oss_lock_ary){
		d_f_ree(oss_lock_ary);
		oss_lock_ary = NULL;
	}
}

oSSL_data *oSSL_object2data(oSSL_object * obj, int convert_type)
{
	return oSSL_types[obj->type]->object2data(obj,convert_type);
}

oSSL_object *oSSL_data2object(oSSL_data * data, int convert_type)
{
	return oSSL_types[data->type]->data2object(data,convert_type);
}

