/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "xlerror.h"
#include "xl.h"
#include "svg2gb.h"


XL_SEXP * xl_switch();

void
init_switch(XLISP_ENV * env)
{
	set_env(
			env,
			l_string(std_cm,"switch"),
			get_func_prim(xl_switch, FO_NORMAL, gblisp_top_env0, 2, -1)
			);
}


XL_SEXP *
xl_switch(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * _sf)
{
	XL_SYM_FIELD *sf;
	XL_SEXP *foreignObject;
	XL_SEXP *foreignObject_sym;
	XL_SEXP *err;

	/* switch support foreignObject element only now */
	foreignObject = car(cdr(s));
	
	/*print_sexp(s_stdout, foreignObject, PF_XML); */
	if(foreignObject == 0){
		ss_printf("svg witch cannot found \"foreignObject\" \n");
		return 0;
	}

	foreignObject_sym = car(foreignObject);
	err = get_sym_field(&sf, env, foreignObject_sym);
	if(get_type(err) == XLT_ERROR){
		return err;
	}
	
	for(; sf; sf=sf->next){
		if(strcmp(n_string(std_cm, sf->name), "requiredExtensions") == 0){
			if(strcmp(n_string(std_cm, sf->data), "xlp://www.globalbase.org/SVGExtensions/pdb") == 0){
				return eval(env, foreignObject);
			}
			else{
				return eval(env, get_el(s, 2));
			}
		}
	}
	
	return 0;
}
