/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"


XL_SEXP *
xl_mxCH(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_mxCH(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxCH"),
		get_func_prim(xl_mxCH,FO_APPLICATIVE,0,1,3));
}


XL_SEXP *
xl_mxCH(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * c;
MATRIX_TOKEN * t;
L_CHAR * _type;
INTEGER64 * dim_code;
MATRIX_NODE * n;
int err;
int _ch;
XL_SEXP * ch;
MATRIX * m;
XL_SEXP * ret;
INTEGER64 ** p_addr;
L_CHAR * _neturl;
L_CHAR * _filename;
L_CHAR * _key;
XL_SEXP * neturl;
XL_SEXP * filename;
XL_SEXP * key;
	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	_type = get_sf_attribute(sf,l_string(std_cm,"type"));
	dim_code = copy_dim_code(t->process_node->matrix,t->process_node->dim_code);
	m = t->process_node->matrix;
	if ( l_strcmp(_type,l_string(std_cm,"me")) == 0 ) {
		n = t->process_node;
		ch = get_el(s,1);
		if ( get_type(ch) != XLT_INTEGER )
			goto type_missmatch;
		_ch = ch->integer.data;
	}
	else if ( l_strcmp(_type,l_string(std_cm,"parent")) == 0 ) {
		dim_code[0] ++;
		if ( dim_code[0] >= t->process_node->matrix->total_levels ) {
			d_f_ree(dim_code);
			dim_code = 0;
			n = 0;
			return 0;
		}
		else {
			n = get_matrix_node(&err,m,dim_code,0,t);
			d_f_ree(dim_code);
			if ( err != 0 )
				return matrix_error("mxCH",s);
		}
		ch = get_el(s,1);
		if ( get_type(ch) != XLT_INTEGER )
			goto type_missmatch;
		_ch = ch->integer.data;
	}
	else if ( l_strcmp(_type,l_string(std_cm,"children")) == 0 ) {
		ch = get_el(s,1);
		if ( get_type(ch) != XLT_INTEGER )
			goto type_missmatch;
		_ch = ch->integer.data;
		n = t->process_node;
		if ( n->nlist_dim_addr ) {
			ret = 0;
			for ( p_addr = n->nlist_dim_addr ; *p_addr ; p_addr ++ ) {
				dim_code = *p_addr;
				n = get_matrix_node(&err,m,dim_code,0,t);
				if ( err != 0 )
					return matrix_error("mxCH",s);
				if ( n->channel == 0 )
					goto no_obj;
				ret = cons(
					List(n_get_symbol("data"),
						get_sexp_from_dim_code(m,dim_code),
						get_channel_data(n,_ch,s),
						-1),
					ret);
			}
			return cons(n_get_symbol("Children"),ret);
		}
		else {
			return 0;
		}
	}
	else if ( l_strcmp(_type,l_string(std_cm,"matrix")) == 0 ) {
		neturl = get_sf_attribute(sf,l_string(std_cm,"neturl"));
		if ( neturl )
			_neturl = neturl->string.data;
		else	_neturl = 0;
		filename = get_sf_attribute(sf,l_string(std_cm,"filename"));
		if ( filename )
			_filename = filename->string.data;
		else	_filename = 0;
		key = get_sf_attribute(sf,l_string(std_cm,"key"));
		if ( key )
			_key = key->string.data;
		else	_key = 0;
	retry:
		m = search_matrix(&err,_neturl,_filename,_key,t);
		switch ( err ) {
		case ME_PROC_NODE:
			return matrix_error("mxCH",s);
		case ME_NO_NODE:
			open_matrix(_neturl,_filename,_key,
					t->process_node->matrix->p.open_method);
			goto retry;
		case ME_ERROR:
			goto matrix_err;
		default:
			er_panic("mxCH");
		}
		c = get_el(s,1);
		if ( get_type(c) != XLT_PAIR )
			goto type_missmatch;
		dim_code = get_dim_code_from_sexp(c);
		n = get_matrix_node(&err,m,dim_code,0,t);
		d_f_ree(dim_code);
		if ( err != 0 )
			return matrix_error("mxCH",s);
		ch = get_el(s,2);
		if ( get_type(ch) != XLT_INTEGER )
			goto type_missmatch;
		_ch = ch->integer.data;
	}
	else {
		c = get_el(s,1);
		if ( get_type(c) != XLT_PAIR )
			goto type_missmatch;
		dim_code = get_dim_code_from_sexp(c);
		n = get_matrix_node(&err,m,dim_code,0,t);
		d_f_ree(dim_code);
		if ( err != 0 )
			return matrix_error("mxCH",s);
		ch = get_el(s,2);
		if ( get_type(ch) != XLT_INTEGER )
			goto type_missmatch;
		_ch = ch->integer.data;
	}
	if ( _ch < 0 || _ch >= m->p.channel_nos )
		goto inv_param;
	if ( n->channel == 0 )
		goto no_obj;
	return get_channel_data(n,_ch,s);
	
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxCH"),
		0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxCH"),
		n_get_string("invalid parameter in mxCH"));
no_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxCH"),
		n_get_string("invalid object in channel of NODE"));
matrix_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxCH"),
		n_get_string("invalid matrix loading"));
}





