/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"matrix.h"


/*
CHANNEL		0		attribute plet of color

CANNNEL		8		compressed data CHANNEL corresponding to Kiban layer
CANNNEL		9
CANNNEL		10
CANNNEL		11
CANNNEL		12
CANNNEL		13
CANNNEL		14
CANNNEL		15

CHANNEL		16		unsigned 8 bit original data
CHANNEL		17
CHANNEL		18
CHANNEL		19
CHANNEL		20
CHANNEL		21
CHANNEL		22
CHANNEL		23

CHANNEL		24		unsigned 8 bit work data
CHANNEL		25
CHANNEL		26
CHANNEL		27
CHANNEL		28
CHANNEL		29
CHANNEL		30
CHANNEL		31

*/


void
matrix_open_kiban(char * filename,int x,int y)
{
MATRIX * m;
int er;
MATRIX_PARAM p;
MATRIX_CHANNEL_INFO inf;
int i;

	m = open_matrix(
		0,				// open URL name (ignore)
		l_string(std_cm,filename,	// save filename
		0);				// KEY name for searching
	if ( m == 0 )
		goto error;

	memset(&p,0,sizeof(p));
	p.channel_nos = 24;
	p.dim = 2;
	p.pri_area[MI_EDIT_1] = PR_UP + 0;
	p.pri_area[MI_EDIT_2] = PRI_DOWN + 0x100
	p.pri_area[MI_SAVE] = PRI_STRT + 0x200

	er = set_matrix_param(m,&p);
	if ( er < 0 )
		goto error;
	er = set_matrix_dim_divide(m,0,1);		// divide 2^1
	if ( er < 0 )
		goto error;
	er = set_matrix_block_size(m,0,7);		// blocksize = 2^7
	if ( er < 0 )
		goto error;
	er = set_matrix_dim_divide(m,1,1);
	if ( er < 0 )
		goto error;
	er = set_matrix_block_size(m,1,7);
	if ( er < 0 )
		goto error;

	er = set_matrix_pixel_size(m,0,x);
	if ( er < 0 )
		goto error;
	er = set_matrix_pixel_size(m,1,y);
	if ( er < 0 )
		goto error;
	
	inf.data_type = &mdt_uint32;
	inf.flags = MF_SEND|MF_FILE;
	er = set_matrix_channel_info(m,0,&inf);
	if ( er < 0 )
		goto error;

	for ( i = 8 ; i < 16 ; i ++ ) {

		inf.data_type = &mdt_block;
		inf.flags = MF_SEND|MF_FILE;
		er = set_matrix_channel_info(m,i,&inf);
		if ( er < 0 )
			goto error;
	}
	for ( i = 16 ; i < 32 ; i ++ ) {

		inf.data_type = &mdt_uint8;
		inf.flags = MF_FILE;
		er = set_matrix_channel_info(m,i,&inf);
		if ( er < 0 )
			goto error;
	}

	er = set_matrix_cal(m,MI_EDIT_1,
		sexp_commands(
			"("
			"(Define ch 16)"
			"(mxSet ch (mxThined ([mxCH type=\"children\"] ch)))"
			"(Define ch 17)"
			"(mxSet ch (mxThined ([mxCH type=\"children\"] ch)))"
			"(Define ch 18)"
			"(mxSet ch (mxThined ([mxCH type=\"children\"] ch)))"
			"(Define ch 19)"
			"(mxSet ch (mxThined ([mxCH type=\"children\"] ch)))"
			"(Define ch 20)"
			"(mxSet ch (mxThined ([mxCH type=\"children\"] ch)))"
			"(Define ch 21)"
			"(mxSet ch (mxThined ([mxCH type=\"children\"] ch)))"
			"(Define ch 22)"
			"(mxSet ch (mxThined ([mxCH type=\"children\"] ch)))"
			"(Define ch 23)"
			"(mxSet ch (mxThined ([mxCH type=\"children\"] ch)))"
			"<mxTrigger type=\"parent\"/>"
			"<mxTrigger if=\"top\" type=\"this\" access=\"MI_EDIT_2\")"
			")"
		));
	if ( er < 0 )
		goto error;
	er = set_matrix_cal(m,MI_EDIT_2,
		sexp_commands(
			"("
			"(Define ch 8)"
			"(mxSet ch (mxCompressJPEG (mxDiff"
				"([mxCH type=\"parent\"] (+ ch 16)) (mxCH (+ ch 8)) )))"
			"(Define ch 9)"
			"(mxSet ch (mxCompressJPEG (mxDiff"
				"([mxCH type=\"parent\"] (+ ch 16)) (mxCH (+ ch 8)) )))"
			"(Define ch 10)"
			"(mxSet ch (mxCompressJPEG (mxDiff"
				"([mxCH type=\"parent\"] (+ ch 16)) (mxCH (+ ch 8)) )))"
			"(Define ch 11)"
			"(mxSet ch (mxCompressJPEG (mxDiff"
				"([mxCH type=\"parent\"] (+ ch 16)) (mxCH (+ ch 8)) )))"
			"(Define ch 12)"
			"(mxSet ch (mxCompressJPEG (mxDiff"
				"([mxCH type=\"parent\"] (+ ch 16)) (mxCH (+ ch 8)) )))"
			"(Define ch 13)"
			"(mxSet ch (mxCompressJPEG (mxDiff"
				"([mxCH type=\"parent\"] (+ ch 16)) (mxCH (+ ch 8)) )))"
			"(Define ch 14)"
			"(mxSet ch (mxCompressJPEG (mxDiff"
				"([mxCH type=\"parent\"] (+ ch 16)) (mxCH (+ ch 8)) )))"
			"(Define ch 15)"
			"(mxSet ch (mxCompressJPEG (mxDiff"
				"([mxCH type=\"parent\"] (+ ch 16)) (mxCH (+ ch 8)) )))"

			"(Define ch 8)"
			"(mxSet (+ ch 16) (mxAdd"
				"(mxUncompressJPEG (mxCH ch))"
				"([mxCH type=\"parent\"] (+ ch 16)) ))"
			"(Define ch 9)"
			"(mxSet (+ ch 16) (mxAdd"
				"(mxUncompressJPEG (mxCH ch))"
				"([mxCH type=\"parent\"] (+ ch 16)) ))"
			"(Define ch 10)"
			"(mxSet (+ ch 16) (mxAdd"
				"(mxUncompressJPEG (mxCH ch))"
				"([mxCH type=\"parent\"] (+ ch 16)) ))"
			"(Define ch 11)"
			"(mxSet (+ ch 16) (mxAdd"
				"(mxUncompressJPEG (mxCH ch))"
				"([mxCH type=\"parent\"] (+ ch 16)) ))"
			"(Define ch 12)"
			"(mxSet (+ ch 16) (mxAdd"
				"(mxUncompressJPEG (mxCH ch))"
				"([mxCH type=\"parent\"] (+ ch 16)) ))"
			"(Define ch 13)"
			"(mxSet (+ ch 16) (mxAdd"
				"(mxUncompressJPEG (mxCH ch))"
				"([mxCH type=\"parent\"] (+ ch 16)) ))"
			"(Define ch 14)"
			"(mxSet (+ ch 16) (mxAdd"
				"(mxUncompressJPEG (mxCH ch))"
				"([mxCH type=\"parent\"] (+ ch 16)) ))"
			"(Define ch 15)"
			"(mxSet (+ ch 16) (mxAdd"
				"(mxUncompressJPEG (mxCH ch))"
				"([mxCH type=\"parent\"] (+ ch 16)) ))"

			"<mxTrigger type=\"children\"/>"
			")"
		));
	if ( er < 0 )
		goto error;
	er = set_matrix_cal(m,MI_SAVE,
		sexp_commands(
			"("
			"(mxSave)"
			")"
		));
	if ( er < 0 )
		goto error;
	
	
	
	er = set_matrix_mode(m,MM_STANBY);
	if ( er < 0 )
		goto error;
}


