/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef GM_ROAD_LFT_H___
#define GM_ROAD_LFT_H___

#include "vpf_table.h"

typedef struct {
	LONG id;
	char f_code[6];
	SHORT acc;
	SHORT exs;
	SHORT rst;
	SHORT med;
	SHORT rtt;
	SHORT rsu;
	SHORT soc;
	SHORT tile_id;
	LONG edg_id;
}GM_ROAD_LFT_RECORD;

void gm_road_lft_delete(GM_ROAD_LFT_RECORD *record);
BOOL gm_road_lft_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
LONG gm_road_lft_get_tileid(const GM_ROAD_LFT_RECORD *record);
LONG gm_road_lft_get_edge_id(const GM_ROAD_LFT_RECORD *record);
void gm_road_lft_write_information_tag(FILE *fp, const GM_ROAD_LFT_RECORD *record);

#endif

