/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___GBERROR_H___
#define ___GBERROR_H___

#define XLE_ERR			0x80000000
#define XLE_LAYER_MASK		0x00ff0000
#define XLE_VERB_MASK		0x0000ff00
#define XLE_CODE_MASK		0x000000ff

/* layer */

#define XLE_SYS		0x00010000
#define XLE_SYN		0x00020000
#define XLE_SEM		0x00030000
#define XLE_PRO		0x00040000

/* verb */

#define XLE_READ	0x00000100
#define XLE_EXEC	0x00000200
#define XLE_MANY	0x00000300
#define XLE_NOTH	0x00000400 /* nothing */
#define XLE_INVA	0x00000500 /* invalid */
#define XLE_USUP	0x00000600 /* unsupport */
#define XLE_UDEF	0x00000700 /* undefined */
#define XLE_MACH	0x00000800 /* missmatch */
#define XLE_REQU	0x00000900 /* required */
#define XLE_OPEN	0x00000a00 /* cannot open / cannot access */
#define XLE_DUPP	0x00000b00 /* dupplicate definition */
#define XLE_CLSE	0x00000c00 /* closed */
#define XLE_DENI	0x00000d00 /* denied */
#define XLE_UNSP	0x00000e00 /* unspecified */
#define XLE_ALRD	0x00000f00 /* already open/ already definde */
#define XLE_UNST	0x00001000 /* unsutisfied */
#define XLE_RELY	0x00001100 /* relaied error */
#define XLE_UTIL	0x00001200 /* error utility */
#define XLE_CORR	0x00001300 /* not corresponding */
#define XLE_EXIT	0x00001400 /* exit, interrupt and so on */
#define XLE_MATH	0x00001500 /* mathematical error */
#define XLE_LOOP	0x00001600 /* loop command for system */
#define XLE_OVER	0x00001700 /* over something */

/* code */

#define XLE_OK				0
#define XLE_SYSTEM_READ_FILE		(XLE_ERR|XLE_SYS|XLE_READ|1)
#define XLE_SYSTEM_NETWORK		(XLE_ERR|XLE_SYS|XLE_READ|2)
#define XLE_SYSTEM_DONTPRINT		(XLE_ERR|XLE_SYS|XLE_UTIL|3)
#define XLE_SYSTEM_EXIT			(XLE_ERR|XLE_SYS|XLE_EXIT|4)
#define XLE_SYSTEM_CANCEL		(XLE_ERR|XLE_SYS|XLE_EXIT|5)
#define XLE_SYSTEM_INTERRUPT		(XLE_ERR|XLE_SYS|XLE_EXIT|6)
#define XLE_SYSTEM_INTERNAL		(XLE_ERR|XLE_SYS|XLE_INVA|7)
#define XLE_SYSTEM_LOOP_BREAK		(XLE_ERR|XLE_SYS|XLE_LOOP|8)
#define XLE_SYSTEM_LOOP_CONTINUE	(XLE_ERR|XLE_SYS|XLE_LOOP|9)
#define XLE_SYSTEM_APPLICATION		(XLE_ERR|XLE_SYS|XLE_LOOP|10)

#define XLE_SYNTAX_TOO_MANY_PUNC	(XLE_ERR|XLE_SYN|XLE_MANY|1)
#define XLE_SYNTAX_NO_PUNC		(XLE_ERR|XLE_SYN|XLE_NOTH|2)
#define XLE_SYNTAX_ERROR_CODE		(XLE_ERR|XLE_SYN|XLE_UNST|3)
#define XLE_SYNTAX_UNSUTISFIED_FILE_END	(XLE_ERR|XLE_SYN|XLE_UNST|4)
#define XLE_SYNTAX_TOKEN_ERROR		(XLE_ERR|XLE_SYN|XLE_UNST|5)
#define XLE_SYNTAX_NOT_CORRESPOND_TAG	(XLE_ERR|XLE_SYN|XLE_CORR|6)
#define XLE_SYNTAX_UNTERMINATED_TEXT	(XLE_ERR|XLE_SYN|XLE_INVA|7)
#define XLE_SYNTAX_INVALID_ENTITY	(XLE_ERR|XLE_SYN|XLE_INVA|8)

#define XLE_SEMANTICS_EXEC_NO_FUNC	(XLE_ERR|XLE_SEM|XLE_EXEC|1)
#define XLE_SEMANTICS_INV_PARAM_LENGTH	(XLE_ERR|XLE_SEM|XLE_INVA|2)
#define XLE_SEMANTICS_INV_FORMAT	(XLE_ERR|XLE_SEM|XLE_INVA|3)
#define XLE_SEMANTICS_UNSUPPORT_FUNC	(XLE_ERR|XLE_SEM|XLE_USUP|4)
#define XLE_SEMANTICS_UNDEF_SYMBOL	(XLE_ERR|XLE_SEM|XLE_UDEF|5)
#define XLE_SEMANTICS_TYPE_MISSMATCH	(XLE_ERR|XLE_SEM|XLE_MACH|6)
#define XLE_SEMANTICS_REQ_SYMBOL	(XLE_ERR|XLE_SEM|XLE_REQU|7)
#define XLE_SEMANTICS_DIV_ZERO		(XLE_ERR|XLE_SEM|XLE_MATH|8)
#define XLE_SEMANTICS_UNIT_MISSMATCH	(XLE_ERR|XLE_SEM|XLE_MACH|9)

#define XLE_PROTO_INV_OBJECT		(XLE_ERR|XLE_PRO|XLE_INVA|1)
#define XLE_PROTO_INV_RESOURCE		(XLE_ERR|XLE_PRO|XLE_INVA|2)
#define XLE_PROTO_INV_PARAM		(XLE_ERR|XLE_PRO|XLE_INVA|3)
#define XLE_PROTO_INV_FIELD_NAME	(XLE_ERR|XLE_PRO|XLE_INVA|4)
#define XLE_PROTO_INV_FILE_TYPE		(XLE_ERR|XLE_PRO|XLE_INVA|5)
#define XLE_PROTO_OPEN_FILE		(XLE_ERR|XLE_PRO|XLE_OPEN|6)
#define XLE_PROTO_UNSUPPORT_FILE_TYPE	(XLE_ERR|XLE_PRO|XLE_USUP|7)
#define XLE_PROTO_UNSUPPORT_MODE	(XLE_ERR|XLE_PRO|XLE_USUP|8)
#define XLE_PROTO_UNSUPPORT_PROTO	(XLE_ERR|XLE_PRO|XLE_USUP|9)
#define XLE_PROTO_UNSUPPORT_TYPE	(XLE_ERR|XLE_PRO|XLE_USUP|10)
#define XLE_PROTO_DUP_DEFINITION	(XLE_ERR|XLE_PRO|XLE_DUPP|11)
#define XLE_PROTO_UNDEF_NAME		(XLE_ERR|XLE_PRO|XLE_UDEF|12)
#define XLE_PROTO_UNDEF_DATABASE	(XLE_ERR|XLE_PRO|XLE_UDEF|13)
#define XLE_PROTO_UNDEF_RESOURCE	(XLE_ERR|XLE_PRO|XLE_UDEF|14)
#define XLE_PROTO_REQ_PRESET		(XLE_ERR|XLE_PRO|XLE_REQU|15)
#define XLE_PROTO_PERMISSION_DENIED	(XLE_ERR|XLE_PRO|XLE_DENI|16)
#define XLE_PROTO_CLOSED		(XLE_ERR|XLE_PRO|XLE_CLSE|17)
#define XLE_PROTO_ACCESS_STREAM		(XLE_ERR|XLE_PRO|XLE_OPEN|18)
#define XLE_PROTO_UNSPC_RESOURCE	(XLE_ERR|XLE_PRO|XLE_UNSP|19)
#define XLE_PROTO_ALREADY_OPEN		(XLE_ERR|XLE_PRO|XLE_ALRD|20)
#define XLE_PROTO_UNSUTISFIED_INFO	(XLE_ERR|XLE_PRO|XLE_UNST|21)
#define XLE_PROTO_REQ_PUT		(XLE_ERR|XLE_PRO|XLE_REQU|22)
#define XLE_PROTO_EXEC_ERROR		(XLE_ERR|XLE_PRO|XLE_EXEC|23)
#define XLE_PROTO_RELAY			(XLE_ERR|XLE_PRO|XLE_RELY|24)
#define XLE_PROTO_LAUNCH		(XLE_ERR|XLE_PRO|XLE_OPEN|25)
#define XLE_PROTO_USER_ERROR		(XLE_ERR|XLE_PRO|XLE_EXEC|26)
#define XLE_PROTO_UNKNOWN		(XLE_ERR|XLE_PRO|XLE_UNSP|27)
#define XLE_PROTO_NO_ROUTE		(XLE_ERR|XLE_PRO|XLE_UDEF|28)
#define XLE_PROTO_OVER_TTL		(XLE_ERR|XLE_PRO|XLE_OVER|28)
#define XLE_PROTO_INV_IID		(XLE_ERR|XLE_PRO|XLE_INVA|29)

#endif
